/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.trade.IFutureMarketMakingApi;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.message.PComponent;
import cms.tmx.datatype.message.PField;
import cms.tmx.datatype.proto.strategy.PAlgo;
import cms.tmx.datatype.proto.strategy.PStrategy;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.notice.FutureStrategyReport;
import cms.tmx.entity.trade.FutureAlgo;
import cms.tmx.futures.views.FormulaUtils;
import cms.tmx.http.api.marketdata.dto.CalcResult;
import cms.tmx.http.api.marketdata.dto.SubscribeReq;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.utils.QueryModel;
import cms.tmx.utils.MarketUtils;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class FutureAlgoModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(FutureAlgoModel.class);
    private MxList<FutureAlgo> mlist = new MxList();
    private MxList<FutureAlgo> mlistStrategyLib = new MxList();
    public static final String STRATEGY_LIB = "strategy.lib";
    public static final String STRATEGY_EXE = "strategy.exe";
    public BooleanProperty statusChangedAndSelected = new SimpleBooleanProperty();
    public BooleanProperty statusChanged = new SimpleBooleanProperty();
    @Inject
    private IFutureMarketMakingApi api;
    @Inject
    private QueryModel queryModel;
    @Inject
    private ScheduledExecutorService ses;
    private Future<?> future;
    @Inject
    protected IBaseApi iba;
    @Inject
    protected MObjFactory of;
    @Inject
    private MEventService es;
    public static BooleanProperty isEditting = new SimpleBooleanProperty(false);
    public static StringProperty refreshTime = new SimpleStringProperty("");
    private FutureAlgo copyStrategy;
    @Inject
    private MScheduler scheduler;
    @Inject
    protected MScheduler schedulerStatus;
    private static final String expr1 = "LOG(([CODE].BID_QTY_1/[CODE].ASK_QTY_1);3)";
    private static final String expr2 = "LOG(([CODE].BID_QTY_1+[CODE].BID_QTY_2)/([CODE].ASK_QTY_1+[CODE].ASK_QTY_2);3)";
    private static final String expr3 = "((([CODE].BID_1+[CODE].ASK_1)-[CODE].LAST*2)/0.005)/2";
    private static final String expr4 = "MAX((([CODE].ASK_1-[CODE].BID_1)/0.005-2);0)";
    private Map<String, Double> map = new HashMap<String, Double>();
    @Inject
    public CtpAccountMap accMng;
    public BooleanProperty changedLib = new SimpleBooleanProperty();
    public BooleanProperty changedSub = new SimpleBooleanProperty();

    @PostConstruct
    public void init() {
        this.scheduler.setInterval(800);
        this.schedulerStatus.setInterval(1000);
        this.es.subscribe("server.sub", event -> this.onPush(event));
        this.es.subscribe("uap.push.ficc.mdcalc.formula", event -> this.onPushMD(event));
        try {
            this.query(STRATEGY_EXE);
        }
        catch (MException | InvalidProtocolBufferException e1) {
            logger.error(e1.getMessage(), e1);
        }
        logger.debug("\u6267\u884cFutureMarketMakingModel\u7684init");
        try {
            this.future = this.ses.scheduleAtFixedRate(() -> {
                logger.debug("\u51c6\u5907\u5237\u65b0\u671f\u8d27\u81ea\u52a8\u505a\u5e02\u7b56\u7565");
                long start = System.currentTimeMillis();
                if (!isEditting.get()) {
                    try {
                        this.query(STRATEGY_EXE);
                        Platform.runLater(() -> refreshTime.set((Object)("\u5237\u65b0\u65f6\u95f4\uff1a" + new SimpleDateFormat("HH:mm:ss:SSS").format(new Date()))));
                    }
                    catch (MException | Exception e) {
                        e.printStackTrace();
                        logger.error("FutureMarketMakingModel\u5237\u65b0\u5931\u8d25\uff1a" + Thread.currentThread(), e);
                    }
                } else {
                    logger.debug("\u6b63\u5728\u7f16\u8f91, \u8df3\u8fc7\u5237\u65b0");
                }
                logger.debug("\u56fd\u503a\u671f\u8d27\u67e5\u8be2\u4e00\u6b21\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
            }, 0L, 120L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("FutureMarketMakingModel\u7ebf\u7a0b\u6c60\u5f02\u5e38\uff1a" + Thread.currentThread(), (Throwable)e);
        }
    }

    private void onPushStrategyLib(FutureAlgo strategy) {
        FutureAlgo old = (FutureAlgo)this.mlistStrategyLib.getListMap().get(strategy);
        if (old == null) {
            this.mlistStrategyLib.add((MxObject)strategy);
        } else {
            old.update((Object)strategy);
        }
        this.changedLib();
    }

    private void onPush(MEvent event) {
        if (!event.get((Object)"push_type").equals("154")) {
            return;
        }
        if (event.getObj() instanceof FutureStrategyReport) {
            FutureStrategyReport contextSettings = (FutureStrategyReport)event.getObj();
            if (!contextSettings.getReport().getExecModeType().equals((Object)PField.ExecModeType.EXEC_MODE_TYPE_FUTURE_ALGO)) {
                return;
            }
            FutureAlgo strategy = new FutureAlgo();
            strategy.update((Object)contextSettings.getReport());
            this.updateFunctionResult(strategy);
            logger.info("\u7b56\u7565\u63a8\u9001(id:" + strategy.getContextId() + (strategy.isInExe() ? " \u6267\u884c\u9762\u677f" : " \u7b56\u7565\u5e93") + " status:" + strategy.getStatus().getValue() + " errorMsg:" + strategy.getErrorMsg());
            strategy.setInvestorId(this.queryModel.getCtpInvestId(strategy.getExtFundAccntId()));
            strategy.setInvestorSecId(this.queryModel.getCtpInverstorSecId(strategy.getExtSecAccntId()));
            FutureAlgo old = (FutureAlgo)this.mlist.getListMap().get(strategy);
            if (!strategy.isInExe()) {
                this.onPushStrategyLib(strategy);
                if (old != null) {
                    this.mlist.remove((MxObject)old);
                    this.changed();
                }
                return;
            }
            boolean inExeChanged = false;
            if (old == null) {
                this.mlist.add((MxObject)strategy);
                this.changed();
            } else {
                inExeChanged = old.isInExe() ^ strategy.isInExe();
                boolean statusChanged = !old.getStatus().getRaw().equals(strategy.getStatus().getRaw());
                old.update((Object)strategy);
                if (inExeChanged) {
                    this.changed();
                }
                if (statusChanged) {
                    this.schedulerStatus.schedule(e -> this.statusChanged());
                    if (strategy.getStatus().getValue().equals("\u505c\u6b62")) {
                        this.es.postEvent("strategy_stopped_algo", null);
                    }
                }
                if (statusChanged && old.isSelected()) {
                    this.statusChangedAndSelected();
                }
            }
        }
    }

    public void changed() {
        this.scheduler.schedule(e -> super.changed());
    }

    private void onPushMD(MEvent event) {
        if (event.getObj() instanceof CalcResult) {
            CalcResult result = (CalcResult)event.getObj();
            double res = Double.valueOf(result.getText());
            String expr = result.getExpr();
            if (result.getId().startsWith("expr1_") || result.getId().startsWith("expr2_") || result.getId().startsWith("expr3_")) {
                if (res >= 1.0) {
                    res = 1.0;
                }
                if (res <= -1.0) {
                    res = -1.0;
                }
            }
            this.map.put(expr, res);
            for (FutureAlgo algo : this.mlist.getList()) {
                if (algo.getDirectionFunction().equals(expr)) {
                    algo.setDirectionResult(res);
                    double directionFinal = FormulaUtils.round(res * algo.getDirectionMaxEffect(), 0.005);
                    algo.setDirectionFinal(directionFinal);
                    continue;
                }
                if (!algo.getSpreadProtectionFunction().equals(expr)) continue;
                algo.setProtectionResult(res);
                double protectionFinal = FormulaUtils.round(res * algo.getBoundEffect(), 0.005);
                algo.setProtectionFinal(protectionFinal);
            }
        }
    }

    private void updateFunctionResult(FutureAlgo algo) {
        Double direction = this.map.get(algo.getDirectionFunction());
        if (direction != null) {
            algo.setDirectionResult(direction.doubleValue());
            double directionFinal = FormulaUtils.round(direction * algo.getDirectionMaxEffect(), 0.005);
            algo.setDirectionFinal(directionFinal);
        } else {
            String function = algo.getDirectionFunction().replace(algo.getSecurity(), "CODE").replace(",", ";");
            this.subscribe(function, algo.getSecurity());
        }
        Double protect = this.map.get(algo.getSpreadProtectionFunction());
        if (protect != null) {
            algo.setProtectionResult(protect.doubleValue());
            double protectionFinal = FormulaUtils.round(protect * algo.getBoundEffect(), 0.005);
            algo.setProtectionFinal(protectionFinal);
        } else {
            String function = algo.getSpreadProtectionFunction().replace(algo.getSecurity(), "CODE").replace(",", ";");
            this.subscribe(function, algo.getSecurity());
        }
    }

    public void subscribe(String function, String securityId) {
        String id = "";
        switch (function) {
            case "LOG(([CODE].BID_QTY_1/[CODE].ASK_QTY_1);3)": {
                id = "expr1_" + securityId;
                break;
            }
            case "LOG(([CODE].BID_QTY_1+[CODE].BID_QTY_2)/([CODE].ASK_QTY_1+[CODE].ASK_QTY_2);3)": {
                id = "expr2_" + securityId;
                break;
            }
            case "((([CODE].BID_1+[CODE].ASK_1)-[CODE].LAST*2)/0.005)/2": {
                id = "expr3_" + securityId;
                break;
            }
            case "MAX((([CODE].ASK_1-[CODE].BID_1)/0.005-2);0)": {
                id = "expr4_" + securityId;
            }
        }
        if (!id.isEmpty()) {
            cms.tmx.http.api.marketdata.dto.Message message = new cms.tmx.http.api.marketdata.dto.Message();
            SubscribeReq req = new SubscribeReq();
            req.setId(id);
            message.setTopic("ficc.mdcalc.formula");
            message.setKey("CalcResult");
            message.setData((Object)req);
            MEvent event = new MEvent();
            event.setObj((Object)message);
            this.es.postEvent("subscribe.market.data.calc", event);
        }
    }

    @PreDestroy
    public void close() {
        if (this.future != null) {
            this.future.cancel(true);
        }
    }

    public SecAccount getExtSecAcc(String fundAcct, String hedgeFlag, String market) throws Exception, MException {
        CtpSecAccount secAcct = null;
        CtpFundAccount fund = this.accMng.getFundAcc(fundAcct);
        List listSec = (List)this.accMng.getAccountMap().get(fund);
        for (SecAccount sec : listSec) {
            CtpSecAccount acc = (CtpSecAccount)sec;
            if (!hedgeFlag.equals(String.valueOf(acc.getHedgeFlag())) || !acc.getExchange().getRaw().equals(market)) continue;
            secAcct = acc;
            break;
        }
        if (secAcct == null) {
            throw new Exception("\u6839\u636e\u8d44\u91d1\u8d26\u53f7\u548c\u6295\u4fdd\u6807\u8bc6\u672a\u80fd\u627e\u5230\u8bc1\u5238\u8d26\u53f7");
        }
        return secAcct;
    }

    public synchronized void query(String type) throws MException, InvalidProtocolBufferException {
        long start = System.currentTimeMillis();
        PStrategy.GetCtxSettingsReq.Builder builder = PStrategy.GetCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setExecModeTypeValue(21);
        builder.setMarketGroup("FUTURES");
        builder.setCtxSettingStatus(STRATEGY_LIB.equals(type) ? PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_TEMPLATE : PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_RUNNING);
        logger.debug("\u6784\u5efabuilder\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        List list = this.api.getStrategy(builder);
        logger.debug("api.getStrategy\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
        start = System.currentTimeMillis();
        this.updateData(list, type);
        for (FutureAlgo algo : this.mlist.getList()) {
            this.updateFunctionResult(algo);
        }
        logger.debug("\u7b56\u7565\u6570\u636e\u66f4\u65b0\u6240\u7528\u65f6\u95f4\uff1a" + (System.currentTimeMillis() - start));
    }

    private void updateData(List<PStrategy.ContextSettings> listInfo, String type) throws InvalidProtocolBufferException {
        ArrayList<FutureAlgo> listTmp = new ArrayList<FutureAlgo>();
        for (PStrategy.ContextSettings info : listInfo) {
            FutureAlgo strategy = new FutureAlgo();
            strategy.update((Object)info);
            strategy.setInvestorId(this.queryModel.getCtpInvestId(strategy.getExtFundAccntId()));
            strategy.setInvestorSecId(this.queryModel.getCtpInverstorSecId(strategy.getExtSecAccntId()));
            strategy.isInExe();
            listTmp.add(strategy);
        }
        switch (type) {
            case "strategy.exe": {
                this.mlist.update(listTmp);
                this.changed();
                break;
            }
            case "strategy.lib": {
                this.mlistStrategyLib.update(listTmp);
                this.changedLib();
            }
        }
    }

    public PStrategy.ContextSettings getSettingsByStrategy(FutureAlgo strategy) {
        PAlgo.AccountSettings.Builder builderAcct = PAlgo.AccountSettings.newBuilder();
        builderAcct.setExtFundAccntId(strategy.getExtFundAccntId());
        builderAcct.setExtSecAccntId(strategy.getExtSecAccntId());
        if (this.accMng.getCtpAccountMap().get(strategy.getExtFundAccntId()) != null) {
            builderAcct.setParentExtAccntId(((CtpFundAccount)this.accMng.getCtpAccountMap().get(strategy.getExtFundAccntId())).getParentId());
        }
        PComponent.Instrument.Builder builderInst = PComponent.Instrument.newBuilder();
        builderInst.setSecurityId(strategy.getSecurity());
        builderInst.setSecurityType(strategy.getSecurityType());
        builderInst.setMarket(strategy.getMarket());
        builderInst.setMarketGroup(MarketUtils.getMarketGroup((String)strategy.getMarket()));
        builderInst.setApplId("010");
        PAlgo.SecuritySettings.Builder builderSec = PAlgo.SecuritySettings.newBuilder();
        builderSec.setInstrument(builderInst);
        builderSec.setBidPriceSlip(0.005);
        builderSec.setOfferPriceSlip(0.005);
        builderSec.setBidRefPriceCustom(strategy.getBidRefPriceCustom());
        builderSec.setOfferRefPriceCustom(strategy.getOfferRefPriceCustom());
        builderSec.setBidRefQty(strategy.getBidRefQtyStr());
        builderSec.setAskRefQty(strategy.getAskRefQtyStr());
        builderSec.setShFlag(PField.SHFlag.forNumber((int)Integer.valueOf(strategy.getShFlag())));
        builderSec.setPositionEffect(PField.PositionEffect.forNumber((int)Integer.valueOf(strategy.getOcFlag())));
        builderSec.setMaxAllowFilledQty(strategy.getMaxAllowFilledQty());
        builderSec.setMaxHaveFilledQty(strategy.getMaxHaveFilledQty());
        builderSec.setMaxAllowExposure(strategy.getMaxAllowExposure());
        builderSec.setCurrentExposure(strategy.getCurrentExposure());
        builderSec.setDelay(strategy.isDelay());
        builderSec.setFullFilledCancel(Boolean.valueOf(strategy.getCancelType().getRaw()).booleanValue());
        builderSec.setExposureEnable(Boolean.valueOf(strategy.getExposureEnable().getRaw()).booleanValue());
        PAlgo.AdjustFunctionSettings.Builder adjust = PAlgo.AdjustFunctionSettings.newBuilder();
        adjust.setDirectionFunction(strategy.getDirectionFunction());
        adjust.setDirectionMaxEffect(strategy.getDirectionMaxEffect());
        if (strategy.getAdjustLimit() != null) {
            adjust.setBidAdjustLimit(strategy.getAdjustLimit());
            if (strategy.getAdjustLimit().contains("BID")) {
                adjust.setOfferAdjustLimit(strategy.getAdjustLimit().replace("BID", "ASK"));
            } else {
                adjust.setOfferAdjustLimit(strategy.getAdjustLimit().replace("ASK", "BID"));
            }
        }
        adjust.setSpreadProtectionFunction(strategy.getSpreadProtectionFunction());
        adjust.setBoundEffect(strategy.getBoundEffect());
        adjust.setFuseLimit(strategy.getFuseLimit());
        PAlgo.HedgeSettings.Builder hedge = PAlgo.HedgeSettings.newBuilder();
        if (strategy.getPositonAdjustMode().toString().equals("\u5b9e\u65f6\u5bf9\u51b2")) {
            hedge.setHedgeContract(strategy.getHedgeContract());
            hedge.setLongHedgePriceCustom(strategy.getLongHedgePriceCustom());
            hedge.setShortHedgePriceCustom(strategy.getShortHedgePriceCustom());
            hedge.setAlgoContractQtyScale(strategy.getAlgoContractQtyScale());
            hedge.setHedgeContractQtyScale(strategy.getHedgeContractQtyScale());
            hedge.setTimeoutFill(strategy.getTimeoutFill());
            hedge.setStoplossFill(strategy.getStoplossFill());
        }
        PAlgo.PositionAdjustSettings.Builder position = PAlgo.PositionAdjustSettings.newBuilder();
        if (strategy.getPositonAdjustMode().toString().equals("\u52a8\u6001\u8c03\u4ed3")) {
            position.setTriggerPositon(strategy.getTriggerPositon());
            position.setBidAdjust(strategy.getBidAdjust());
            position.setAskAdjust(strategy.getAskAdjust());
        }
        PAlgo.AlgoContextSettings.Builder builderCtx = PAlgo.AlgoContextSettings.newBuilder();
        builderCtx.setAccount(builderAcct);
        builderCtx.setSecurity(builderSec);
        builderCtx.setAdjustFunctionSetting(adjust);
        builderCtx.setPositonAdjustMode(Integer.valueOf(strategy.getPositonAdjustMode().getRaw()).intValue());
        builderCtx.setHedge(hedge);
        builderCtx.setPositionAdjust(position);
        PStrategy.ContextSettings.Builder builderCt = PStrategy.ContextSettings.newBuilder();
        builderCt.setName(ByteString.copyFrom((byte[])strategy.getName().getBytes()));
        if (strategy.getContextId() != null) {
            builderCt.setContextId(strategy.getContextId());
        }
        builderCt.setUserId(this.iba.getUserId());
        builderCt.setPartyId(this.iba.getPartyId());
        builderCt.setPostId(this.iba.getPostId());
        builderCt.setCtxState(PStrategy.CtxState.CTX_STATE_STOPPED);
        builderCt.setErrorMsg(strategy.getErrorMsg());
        builderCt.setDetails(Any.pack((Message)builderCtx.build()));
        builderCt.setStrategyTypeValue(Integer.valueOf(strategy.getTacticsType().getRaw()).intValue());
        builderCt.setCtxSettingStatus(strategy.isInExe() ? PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_RUNNING : PStrategy.CtxSettingStatus.CTX_SETTING_STATUS_TEMPLATE);
        builderCt.setExecModeTypeValue(21);
        return builderCt.build();
    }

    public void addStrategy(FutureAlgo strategy) throws MException {
        PStrategy.ContextSettings settings = this.getSettingsByStrategy(strategy);
        PStrategy.NewCtxSettingsReq.Builder builder = PStrategy.NewCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setSettings(settings);
        builder.setExecModeTypeValue(21);
        this.api.addStrategy(builder.build());
    }

    public void updateStrategy(FutureAlgo strategy) throws MException {
        PStrategy.ContextSettings settings = this.getSettingsByStrategy(strategy);
        PStrategy.UpdateCtxSettingsReq.Builder builder = PStrategy.UpdateCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setSettings(settings);
        builder.setExecModeTypeValue(21);
        this.api.updateStrategy(builder.build());
    }

    public void delStrategy(String contextId) throws MException {
        PStrategy.DeleteCtxSettingsReq.Builder builder = PStrategy.DeleteCtxSettingsReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.setContextId(contextId);
        builder.setExecModeTypeValue(21);
        this.api.delStrategy(builder.build());
    }

    public Map<String, String> startStrategy(List<String> listId) throws MException {
        PStrategy.StartContextReq.Builder builder = PStrategy.StartContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        builder.setExecModeTypeValue(21);
        return this.api.startStrategy(builder.build());
    }

    public Map<String, String> stopStrategy(List<String> listId) throws MException {
        PStrategy.StopContextReq.Builder builder = PStrategy.StopContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        builder.setExecModeTypeValue(21);
        return this.api.stopStrategy(builder.build());
    }

    public Map<String, String> resumeStrategy(List<String> listId) throws MException {
        PStrategy.ResumeContextReq.Builder builder = PStrategy.ResumeContextReq.newBuilder();
        builder.setOpUser(this.iba.getOpUser());
        builder.addAllContextId(listId);
        builder.setExecModeTypeValue(21);
        return this.api.resumeStrategy(builder.build());
    }

    public ObservableList<FutureAlgo> getMlistStrategyLib() {
        return this.mlistStrategyLib.getList();
    }

    public ObservableList<FutureAlgo> getList() {
        return this.mlist.getList();
    }

    public FutureAlgo getFutureStrategy(String contextId) {
        for (FutureAlgo strategy : this.mlist.getList()) {
            if (!strategy.getContextId().equals(contextId)) continue;
            return strategy;
        }
        return null;
    }

    public final BooleanProperty statusChangedAndSelectedProperty() {
        return this.statusChangedAndSelected;
    }

    public void statusChangedAndSelected() {
        this.statusChangedAndSelected.set(!this.statusChangedAndSelected.get());
    }

    public final BooleanProperty statusChangedProperty() {
        return this.statusChanged;
    }

    public void statusChanged() {
        this.statusChanged.set(!this.statusChanged.get());
    }

    public FutureAlgo getCopyStrategy() {
        return this.copyStrategy;
    }

    public void setCopyStrategy(FutureAlgo copyStrategy) {
        this.copyStrategy = copyStrategy;
    }

    public BooleanProperty changedLibProperty() {
        return this.changedLib;
    }

    public void changedLib() {
        this.changedLib.set(!this.changedLib.get());
    }

    public BooleanProperty changedSubProperty() {
        return this.changedSub;
    }

    public void changedSub() {
        this.changedSub.set(!this.changedSub.get());
    }
}

