/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.entity.data.CtpContract;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.futures.entrust.EntrustFactory;
import cms.tmx.futures.models.CtpAccountDistribution;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CtpPositionModel;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cmx.tmx.data.IContractService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CtpEntrustSplitModel {
    private boolean today;
    private CtpRefItem refItem;
    private String instructionType;
    private CtpAccountDistribution accDis;
    private MxNode ocFlag;
    private MxNode close = MxNodeFactory.create((String)"position_effect", (String)"67");
    private MxNode open = MxNodeFactory.create((String)"position_effect", (String)"79");
    private MxNode closeToday = MxNodeFactory.create((String)"position_effect", (String)"84");
    @Inject
    CtpPositionModel pstModel;
    @Inject
    private IContractService contractService;
    private CtpContract con;
    @Inject
    private EntrustFactory ef;

    public void setRefItem(CtpRefItem item) {
        this.refItem = item;
    }

    public List<FutureSingleEntrust> split(FutureSingleEntrust en, String type, Instruction instruction) throws Exception {
        LinkedList<FutureSingleEntrust> list = new LinkedList<FutureSingleEntrust>();
        if (type.isEmpty()) {
            return list;
        }
        switch (this.instructionType) {
            case "0": 
            case "1": 
            case "2": {
                this.do2To4Split(en, list, type);
                break;
            }
            case "3": 
            case "4": {
                en.setSide(instruction.getOrderAdvice().getSide());
                this.ocFlag = MxNodeFactory.create((String)"position_effect", (String)Integer.toString(instruction.getOrderAdvice().getOcFlag()));
                en.setOffsetFlag(this.ocFlag);
                list.add(en);
                break;
            }
        }
        switch (this.instructionType) {
            case "0": 
            case "1": 
            case "2": {
                this.do4To6Split(list);
                break;
            }
            case "3": 
            case "4": {
                for (FutureSingleEntrust future : list) {
                    future.setAmt(this.getAmt(future.getOffsetFlag(), future.getPrice(), future.getQuantity()));
                }
                break;
            }
        }
        return list;
    }

    private void do2To4Split(FutureSingleEntrust en, List<FutureSingleEntrust> list, String type) {
        switch (type) {
            case "order_buy": {
                en.setSide(49);
                long canCloseShort = en.getCanCloseShort();
                if (en.getQuantity() > canCloseShort) {
                    en.setOffsetFlag(this.open);
                    break;
                }
                en.setOffsetFlag(this.close);
                break;
            }
            case "order_sell": {
                en.setSide(50);
                long canCloseLong = en.getCanCloseLong();
                if (en.getQuantity() > canCloseLong) {
                    en.setOffsetFlag(this.open);
                    break;
                }
                en.setOffsetFlag(this.close);
                break;
            }
            case "order_open_buy": {
                en.setSide(49);
                en.setOffsetFlag(this.open);
                break;
            }
            case "order_open_sell": {
                en.setSide(50);
                en.setOffsetFlag(this.open);
                break;
            }
            case "order_close_sell": {
                en.setSide(50);
                en.setOffsetFlag(this.close);
                break;
            }
            case "order_close_buy": {
                en.setSide(49);
                en.setOffsetFlag(this.close);
                break;
            }
        }
        list.add(en);
    }

    public List<FutureSingleEntrust> do4To6Split(List<FutureSingleEntrust> list) throws Exception {
        LinkedList<FutureSingleEntrust> forList = new LinkedList<FutureSingleEntrust>();
        forList.addAll(list);
        for (FutureSingleEntrust en : forList) {
            FutureSingleEntrust enFirst;
            this.con = this.contractService.getContract("FUTURES", en.getMarket(), en.getSec(), en.getBrokerId(), en.getInvestorId());
            if (!"67".equals(en.getOffsetFlag().getRaw()) || !this.isXSGE().booleanValue()) {
                en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
                continue;
            }
            if (en.getSide() == 50) {
                if (!this.isToday()) {
                    if (this.accDis.getCanCloseYdLong() >= en.getQuantity()) {
                        en.setOffsetFlag(this.close);
                        en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
                        continue;
                    }
                    enFirst = this.ef.createSingle(en.getAcc(), en.getSecAcc());
                    if (this.accDis.getCanCloseYdLong() > 0L) {
                        this.copyEn(en, enFirst);
                        enFirst.setOffsetFlag(this.close);
                        enFirst.setQuantity(new Double(this.accDis.getCanCloseYdLong()).longValue());
                        enFirst.setAmt(this.getAmt(enFirst.getOffsetFlag(), enFirst.getPrice(), enFirst.getQuantity()));
                        list.add(enFirst);
                    }
                    en.setOffsetFlag(this.closeToday);
                    en.setQuantity(en.getQuantity() - enFirst.getQuantity());
                    en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
                    continue;
                }
                if (this.isToday()) {
                    if (this.accDis.getCanCloseTdLong() >= en.getQuantity()) {
                        en.setOffsetFlag(this.closeToday);
                        en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
                        continue;
                    }
                    enFirst = this.ef.createSingle(en.getAcc(), en.getSecAcc());
                    if (this.accDis.getCanCloseTdLong() > 0L) {
                        this.copyEn(en, enFirst);
                        enFirst.setOffsetFlag(this.closeToday);
                        enFirst.setQuantity(new Double(this.accDis.getCanCloseTdLong()).longValue());
                        enFirst.setAmt(this.getAmt(enFirst.getOffsetFlag(), enFirst.getPrice(), enFirst.getQuantity()));
                        list.add(enFirst);
                    }
                    en.setOffsetFlag(this.close);
                    en.setQuantity(en.getQuantity() - enFirst.getQuantity());
                    en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
                }
            }
            if (en.getSide() != 49) continue;
            if (!this.isToday()) {
                if (this.accDis.getCanCloseYdShort() >= en.getQuantity()) {
                    en.setOffsetFlag(this.close);
                    en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
                    continue;
                }
                enFirst = this.ef.createSingle(en.getAcc(), en.getSecAcc());
                if (this.accDis.getCanCloseYdShort() > 0L) {
                    this.copyEn(en, enFirst);
                    enFirst.setOffsetFlag(this.close);
                    enFirst.setQuantity(new Double(this.accDis.getCanCloseYdShort()).longValue());
                    enFirst.setAmt(this.getAmt(enFirst.getOffsetFlag(), enFirst.getPrice(), enFirst.getQuantity()));
                    list.add(enFirst);
                }
                en.setOffsetFlag(this.closeToday);
                en.setQuantity(en.getQuantity() - enFirst.getQuantity());
                en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
                continue;
            }
            if (!this.isToday()) continue;
            if (this.accDis.getCanCloseTdShort() >= en.getQuantity()) {
                en.setOffsetFlag(this.closeToday);
                en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
                continue;
            }
            enFirst = this.ef.createSingle(en.getAcc(), en.getSecAcc());
            if (this.accDis.getCanCloseTdShort() > 0L) {
                this.copyEn(en, enFirst);
                enFirst.setOffsetFlag(this.closeToday);
                enFirst.setQuantity(new Double(this.accDis.getCanCloseTdShort()).longValue());
                enFirst.setAmt(this.getAmt(enFirst.getOffsetFlag(), enFirst.getPrice(), enFirst.getQuantity()));
                list.add(enFirst);
            }
            en.setOffsetFlag(this.close);
            en.setQuantity(en.getQuantity() - enFirst.getQuantity());
            en.setAmt(this.getAmt(en.getOffsetFlag(), en.getPrice(), en.getQuantity()));
        }
        return list;
    }

    private double getAmt(MxNode ocFlag, double price, long quantity) {
        if (this.con == null) {
            return 0.0;
        }
        String offsetFlag = ocFlag.getRaw();
        if ("79".equals(offsetFlag)) {
            BigDecimal amt = BigDecimal.valueOf(price).multiply(BigDecimal.valueOf(quantity)).multiply(BigDecimal.valueOf(this.con.getUnderlyingMultiple())).multiply(BigDecimal.valueOf(this.con.getLongMarginRatio())).multiply(BigDecimal.valueOf(this.con.getVolumeMultiple())).setScale(this.refItem.getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        if ("67".equals(offsetFlag) || "84".equals(offsetFlag)) {
            BigDecimal amt = BigDecimal.valueOf(price).multiply(BigDecimal.valueOf(quantity)).multiply(BigDecimal.valueOf(this.con.getUnderlyingMultiple())).multiply(BigDecimal.valueOf(this.con.getShortMarginRatio())).multiply(BigDecimal.valueOf(this.con.getVolumeMultiple())).setScale(this.refItem.getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        return 0.0;
    }

    private void copyEn(FutureSingleEntrust oldEn, FutureSingleEntrust newEn) {
        newEn.setAcc(oldEn.getAcc());
        newEn.setSecAcc(oldEn.getSecAcc());
        newEn.setSecAccount(oldEn.getSecAccount());
        newEn.setMarket(oldEn.getMarket());
        newEn.setMarketGrp(oldEn.getMarketGrp());
        newEn.setSecType(oldEn.getSecType());
        newEn.setOrderType(oldEn.getOrderType());
        newEn.setPrice(oldEn.getPrice());
        newEn.setSec(oldEn.getSec());
        newEn.setSecName(oldEn.getSecName());
        newEn.setHedgeFlag(oldEn.getHedgeFlag());
        newEn.setOffsetFlag(oldEn.getOffsetFlag());
        newEn.setBrokerId(oldEn.getBrokerId());
        newEn.setInvestorId(oldEn.getInvestorId());
        newEn.setInvestorSecId(oldEn.getInvestorSecId());
        newEn.setSide(oldEn.getSide());
        newEn.setFundAccount(oldEn.getFundAccount());
        newEn.setCanCloseLong(oldEn.getCanCloseLong());
        newEn.setCanCloseShort(oldEn.getCanCloseShort());
        newEn.setCanOpenLong(oldEn.getCanOpenLong());
        newEn.setCanOpenShort(oldEn.getCanOpenShort());
        newEn.setCanCloseYdLong(oldEn.getCanCloseYdLong());
        newEn.setCanCloseTdLong(oldEn.getCanCloseTdLong());
        newEn.setCanCloseYdShort(oldEn.getCanCloseYdShort());
        newEn.setCanCloseTdShort(oldEn.getCanCloseTdShort());
    }

    public Boolean isXSGE() {
        if (!this.isValidRef()) {
            return false;
        }
        if ("XSGE".equals(this.refItem.getMarket()) || "XINE".equals(this.refItem.getMarket())) {
            return true;
        }
        return false;
    }

    public boolean isValidRef() {
        if (this.refItem == null) {
            return false;
        }
        return this.refItem.getType().equals("FUT");
    }

    public boolean isToday() {
        return this.today;
    }

    public void setToday(boolean today) {
        this.today = today;
    }

    public void setInstructionType(String instructionType) {
        this.instructionType = instructionType;
    }

    public void setAccDis(CtpAccountDistribution accDis) {
        this.accDis = accDis;
    }
}

