/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpContract;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.futures.models.CtpAccountDistribution;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.current.models.CtpPositionModel;
import cms.tmx.utils.MathUtils;
import cmx.tmx.data.IContractService;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class CtpAccountDistributionModel
extends MxModel {
    public static final String INSTANCE_NAME = "account.distribution.model";
    @Inject
    private CtpAccountMap accMng;
    @Inject
    private IFundAccountService fundAccMng;
    @Inject
    private MObjFactory of;
    @Inject
    protected CtpPositionModel posModel;
    @Inject
    private ExecutorService exe;
    @Inject
    private IContractService contractService;
    private MxList<CtpAccountDistribution> accMxList = new MxList();
    private List<CtpAccountDistribution> accList = new LinkedList<CtpAccountDistribution>();
    private Map<CtpFundAccount, List<SecAccount>> mapAccount;
    private CtpRefItem ctpRefItem;
    private StringProperty security = new SimpleStringProperty("");
    private BooleanProperty multiAccount = new SimpleBooleanProperty(true);
    private StringProperty countStg = new SimpleStringProperty("");
    private StringProperty distStg = new SimpleStringProperty("");
    private DoubleProperty percent = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private IntegerProperty unit = new SimpleIntegerProperty(1);
    private StringProperty hedgeType = new SimpleStringProperty("");
    private BooleanProperty permission = new SimpleBooleanProperty(true);
    private IntegerProperty count = new SimpleIntegerProperty(0);
    private boolean selected = false;
    @Inject
    protected MScheduler sdFullQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    protected InvalidationListener lstnPosition = ob -> this.filterAcc();
    private InvalidationListener fundListLst = ob -> {
        try {
            this.onFundChange();
        }
        catch (Exception e) {
            this.logger.error("\u4ea4\u6613\u9762\u677f\u4e2d\u671f\u8d27\u8d26\u53f7\u5237\u65b0\u51fa\u9519", (Throwable)e);
        }
    };

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.price.addListener(ob -> this.onPriceChange());
        this.hedgeType.addListener(ob -> this.onHedgeChange());
        this.fundAccMng.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.fundListLst));
        this.posModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.lstnPosition));
        this.queryPostition();
        this.count.addListener(ob -> this.calCount());
        this.distStgProperty().addListener(ob -> this.calCount());
    }

    public synchronized void create() throws MException {
        this.createTableList();
    }

    protected Map<CtpFundAccount, List<SecAccount>> getAccountMap() throws MException {
        return this.accMng.getAccountMap();
    }

    protected void createTableList() throws MException {
        this.accMxList = new MxList();
        this.accList = new LinkedList<CtpAccountDistribution>();
        this.mapAccount = this.getAccountMap();
        if (this.mapAccount == null) {
            return;
        }
        for (FundAccount fundAccount : this.mapAccount.keySet()) {
            CtpFundAccount fundAcc = (CtpFundAccount)CtpFundAccount.class.cast(fundAccount);
            CtpAccountDistribution accDst = (CtpAccountDistribution)((Object)this.of.create(CtpAccountDistribution.class));
            accDst.setCtpAcc(fundAcc);
            accDst.setSelected(this.isSelected());
            accDst.selectedProperty().addListener(ob -> this.onAccSelectChange());
            accDst.weightProperty().addListener(ob -> this.calCount());
            this.accList.add(accDst);
        }
        this.accMxList.update(this.accList);
        this.filterAcc();
        this.sdFullQuery.schedule(event -> {
            try {
                for (CtpAccountDistribution acc : this.accList) {
                    CtpFundAccount account = acc.getCtpAcc();
                    this.contractService.query(account.getMarketGrp(), "", "", account.getBrokerId(), account.getInvestId());
                }
            }
            catch (MException e1) {
                this.logger.error("\u67e5\u8be2\u671f\u8d27\u5408\u7ea6\u4fe1\u606f\u4fdd\u8bc1\u91d1\u7387\u5931\u8d25\uff1a" + e1.getMessage(), (Throwable)e1);
            }
        });
    }

    public void onPriceChange() {
        this.calCanOpen();
    }

    private void onHedgeChange() {
        this.filterAcc();
    }

    public void refreshAll() {
        this.clearLongShort();
        this.refreshFunds();
        this.calCanOpen();
        this.refreshPosition();
    }

    public void filterAcc() {
        this.clearLongShort();
        this.clearCount();
        if (this.ctpRefItem == null) {
            this.accMxList.update((List)FXCollections.observableList(this.accList).filtered(pd -> this.mapAccount.get(pd.getCtpAcc()).size() != 0));
            this.setPermission(this.accList.size() != 0);
            return;
        }
        String exchange = this.ctpRefItem.getMarket();
        LinkedList<CtpAccountDistribution> newList = new LinkedList<CtpAccountDistribution>();
        newList.addAll(this.accList);
        for (CtpAccountDistribution accDis : this.accList) {
            if (accDis.getCtpAcc().getInvestmarkets().indexOf(exchange) < 0) {
                newList.remove((Object)accDis);
                continue;
            }
            if (this.getSecAcc(accDis.getCtpAcc(), exchange) != null) continue;
            newList.remove((Object)accDis);
        }
        newList.forEach(each -> this.calPosition((CtpAccountDistribution)((Object)each)));
        this.accMxList.update(newList);
        this.setPermission(newList.size() != 0);
        this.calCanOpen();
        this.calCount();
    }

    public CtpSecAccount getSecAcc(CtpFundAccount account, String exchange) {
        for (SecAccount secAcc : this.mapAccount.get(account)) {
            if (!(secAcc instanceof CtpSecAccount)) {
                return null;
            }
            CtpSecAccount ctpSecAcc = (CtpSecAccount)CtpSecAccount.class.cast(secAcc);
            if (!ctpSecAcc.getExchange().getRaw().equals(exchange)) continue;
            switch (this.getHedgeType()) {
                case "1": {
                    if (!ctpSecAcc.isHedgeOne()) break;
                    return ctpSecAcc;
                }
                case "2": {
                    if (!ctpSecAcc.isHedgeTwo()) break;
                    return ctpSecAcc;
                }
                case "4": {
                    if (!ctpSecAcc.isHedgeFour()) break;
                    return ctpSecAcc;
                }
                case "8": {
                    if (!ctpSecAcc.isHedgeEight()) break;
                    return ctpSecAcc;
                }
            }
        }
        return null;
    }

    public void clearSelect() {
        if (this.accMxList != null) {
            this.accMxList.getList().forEach(each -> each.setSelected(false));
        }
    }

    public void selectSecAcc(String secAcc, String mkt) {
        if (this.mapAccount == null) {
            return;
        }
        this.mapAccount.keySet().forEach(each -> {
            for (SecAccount sub : this.mapAccount.get(each)) {
                if (!sub.getExtSecAccntId().equals(secAcc) || !sub.getExchange().getRaw().equals(mkt)) continue;
                this.accMxList.getList().forEach(accEach -> {
                    if (accEach.getCtpAcc().getExtAccntId().equals(each.getExtAccntId())) {
                        accEach.setSelected(true);
                    }
                });
                break;
            }
        });
    }

    private void refreshPosition() {
        this.posModel.query();
        this.accMxList.getList().forEach(each -> this.calPosition((CtpAccountDistribution)((Object)each)));
    }

    private void queryPostition() {
        this.exe.execute(() -> this.posModel.query());
    }

    private void calPosition(CtpAccountDistribution accDis) {
        if (this.ctpRefItem == null) {
            return;
        }
        FilteredList positionList = this.posModel.getPositionList((SecAccount)this.getSecAcc(accDis.getCtpAcc(), this.ctpRefItem.getMarket()), this.getSecurity()).filtered(pb -> pb.getHedgeFlag().getRaw().equals(this.getHedgeType()));
        positionList.forEach(each -> {
            if (each.getPosiDirection().getRaw().equals("1")) {
                accDis.setCanCloseLong(each.getCanClose());
                accDis.setCanCloseTdLong(each.getCanCloseTdLong());
                accDis.setCanCloseYdLong(each.getCanCloseYdLong());
            } else if (each.getPosiDirection().getRaw().equals("2")) {
                accDis.setCanCloseShort(each.getCanClose());
                accDis.setCanCloseTdShort(each.getCanCloseTdShort());
                accDis.setCanCloseYdShort(each.getCanCloseYdShort());
            }
        });
    }

    private void calCanOpen() {
        this.clearCanOpen();
        if (this.ctpRefItem == null) {
            return;
        }
        for (CtpAccountDistribution item : this.accList) {
            CtpContract con = this.contractService.getContract("FUTURES", this.ctpRefItem.getMarket(), this.ctpRefItem.getCode(), item.getCtpAcc().getBrokerId(), item.getCtpAcc().getInvestId());
            if (con == null || this.getPrice() == 0.0) {
                item.setLongCount(0L);
                item.setShortCount(0L);
                continue;
            }
            if (!(con.getUnderlyingMultiple() > 0.0) || !(con.getLongMarginRatio() > 0.0) || !(con.getShortMarginRatio() > 0.0) || !(this.getPrice() > 0.0)) continue;
            BigDecimal available = new BigDecimal(item.getCtpAcc().getAvailable());
            BigDecimal longCon = available.divide(new BigDecimal(this.getPrice()).multiply(new BigDecimal(con.getUnderlyingMultiple())).multiply(new BigDecimal(con.getVolumeMultiple())).multiply(new BigDecimal(con.getLongMarginRatio())), 0, RoundingMode.DOWN);
            BigDecimal shortCon = available.divide(new BigDecimal(this.getPrice()).multiply(new BigDecimal(con.getUnderlyingMultiple())).multiply(new BigDecimal(con.getVolumeMultiple())).multiply(new BigDecimal(con.getShortMarginRatio())), 0, RoundingMode.DOWN);
            item.setLongCount(longCon.longValue());
            item.setShortCount(shortCon.longValue());
        }
    }

    private void clearCanOpen() {
        for (CtpAccountDistribution acc : this.accList) {
            acc.setLongCount(0L);
            acc.setLongCount(0L);
        }
    }

    private void clearLongShort() {
        for (CtpAccountDistribution acc : this.accList) {
            acc.setCanCloseLong(0L);
            acc.setCanCloseShort(0L);
            acc.setLongCount(0L);
            acc.setLongCount(0L);
        }
    }

    public void setRefItem(CtpRefItem item) {
        this.ctpRefItem = item;
    }

    private void onAccSelectChange() {
        this.calCount();
    }

    public final BooleanProperty multiAccountProperty() {
        return this.multiAccount;
    }

    public final boolean isMultiAccount() {
        return this.multiAccountProperty().get();
    }

    public final void setMultiAccount(boolean multiAccount) {
        this.multiAccountProperty().set(multiAccount);
    }

    public final StringProperty distStgProperty() {
        return this.distStg;
    }

    public final String getDistStg() {
        return (String)this.distStgProperty().get();
    }

    public final void setDistStg(String distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public final StringProperty countStgProperty() {
        return this.countStg;
    }

    public final String getCountStg() {
        return (String)this.countStgProperty().get();
    }

    public final void setCountStg(String countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public final DoubleProperty moneyProperty() {
        return this.money;
    }

    public final double getMoney() {
        return this.moneyProperty().get();
    }

    public final void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final IntegerProperty unitProperty() {
        return this.unit;
    }

    public final int getUnit() {
        return this.unitProperty().get();
    }

    public final void setUnit(int unit) {
        this.unitProperty().set(unit);
    }

    public final DoubleProperty percentProperty() {
        return this.percent;
    }

    public final double getPercent() {
        return this.percentProperty().get();
    }

    public final void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public final MxList<CtpAccountDistribution> accMxListProperty() {
        return this.accMxList;
    }

    public final ObservableList<CtpAccountDistribution> getAccList() {
        return this.accMxListProperty().getList();
    }

    public List<String> getFundAccList() {
        ArrayList<String> list = new ArrayList<String>();
        this.getAccList().forEach(each -> {
            boolean bl = list.add(each.getCtpAcc().getInvestId());
        });
        return list;
    }

    public CtpAccountDistribution getFundAcc(String investorId) {
        for (CtpAccountDistribution each : this.getAccList()) {
            if (!each.getCtpAcc().getInvestId().equals(investorId)) continue;
            return each;
        }
        return null;
    }

    public final StringProperty hedgeTypeProperty() {
        return this.hedgeType;
    }

    public final String getHedgeType() {
        return (String)this.hedgeTypeProperty().get();
    }

    public final void setHedgeType(String hedgeType) {
        this.hedgeTypeProperty().set((Object)hedgeType);
    }

    public final BooleanProperty permissionProperty() {
        return this.permission;
    }

    public final boolean isPermission() {
        return this.permissionProperty().get();
    }

    public final void setPermission(boolean permission) {
        this.permissionProperty().set(permission);
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public void refreshFunds() {
        this.fundAccMng.queryFundAccountList();
        this.accList.forEach(each -> this.updateFund(each.getCtpAcc()));
    }

    public void updateFund(CtpFundAccount praAcc) {
        this.accList.forEach(each -> {
            if (each.getCtpAcc().getExtAccntId().equals(praAcc.getExtAccntId())) {
                FundAccount acc = this.fundAccMng.getFundAccount(praAcc.getExtAccntId(), "FUTURES");
                if (acc == null) {
                    return;
                }
                if (acc instanceof CtpFundAccount) {
                    each.getCtpAcc().update(CtpFundAccount.class.cast(acc));
                }
            }
        });
    }

    public void onFundChange() {
        this.accMxList.getList().forEach(acc -> this.updateFund(acc.getCtpAcc()));
        this.calCanOpen();
    }

    private void calCount() {
        this.calByCount(this.getCount());
    }

    private long calByCount(long totalCount) {
        totalCount = this.doQuantityAllocate(totalCount);
        return totalCount;
    }

    private long doQuantityAllocate(long pTotal) {
        this.clearCount();
        int totalWeight = 0;
        long totalCount = pTotal;
        int countAcc = this.accMxList.getList().filtered(ad -> ad.isSelected()).size();
        for (CtpAccountDistribution ad2 : this.accMxList.getList().filtered(ad -> ad.isSelected())) {
            totalWeight += 100 * ad2.getWeight();
        }
        long assigned = 0L;
        Iterator it = this.accMxList.getList().filtered(ad -> ad.isSelected()).iterator();
        while (it.hasNext()) {
            CtpAccountDistribution ad3 = (CtpAccountDistribution)((Object)it.next());
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ad3.setCount(count);
                assigned += count;
                break;
            }
            long target = 0L;
            if (this.getDistStg().equals("1")) {
                target = totalCount / (long)countAcc;
            } else if (this.getDistStg().equals("2")) {
                target = totalCount * (long)ad3.getWeight() * 100L / (long)totalWeight;
            }
            long count = MathUtils.calCount((long)target, (int)this.getUnit());
            assigned += count;
            ad3.setCount(count);
        }
        return assigned;
    }

    public void clearCount() {
        for (CtpAccountDistribution acc : this.accList) {
            acc.setCount(0L);
        }
    }

    public final IntegerProperty countProperty() {
        return this.count;
    }

    public final int getCount() {
        return this.countProperty().get();
    }

    public final void setCount(int count) {
        this.countProperty().set(count);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

