/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.viewers;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MException;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.futures.instructions.viewers.InstructionFuturesBasePart;
import cms.tmx.futures.instructions.viewers.LoadPartModel;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IMarketDataMng;
import java.net.URL;
import java.util.Timer;
import java.util.TimerTask;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionFuturesPassivePart
extends InstructionFuturesBasePart {
    @FXML
    private StackPane stkPaneCommon;
    @FXML
    private HBox hBoxDistStg;
    protected OrderAdvice advice;
    protected MEvent instructEvent = new MEvent();
    protected boolean isInstructionEvent = false;
    private boolean inApprove = false;
    @Inject
    private IMarketDataMng mktMng;
    @FXML
    private Label lbUpDownPrice;
    @Inject
    private LoadPartModel load;
    protected boolean initFinished = false;
    protected MEventHandler hSetCode = event -> Platform.runLater(() -> {
        this.instructEvent = event;
        if (this.instructEvent.get((Object)"instruction") == null || !(this.instructEvent.get((Object)"instruction") instanceof Instruction)) {
            return;
        }
        if (!this.validOrderFill()) {
            return;
        }
        this.instruction = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        this.doSetCode();
    });
    protected ChangeListener<Boolean> lstnFocusPrice = (ob, old, newV) -> {
        if (this.advice == null) {
            return;
        }
        if (this.model.isLimit() && this.advice.getPriceLimit() == 1 && !newV.booleanValue() && this.model.getPrice() > this.advice.getPrice()) {
            this.model.setPrice(this.advice.getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
        if (this.model.isLimit() && this.advice.getPriceLimit() == 4 && !newV.booleanValue() && this.model.getPrice() < this.advice.getPrice()) {
            this.model.setPrice(this.advice.getPrice());
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    };
    protected ChangeListener<Boolean> lstnFocusQuantity = (ob, old, newV) -> {
        if (this.advice == null) {
            return;
        }
        if (newV.booleanValue()) {
            return;
        }
        this.modifyQuantity();
    };

    public boolean isInApprove() {
        return this.inApprove;
    }

    public void setInApprove(boolean inApprove) {
        this.inApprove = inApprove;
    }

    @Override
    protected URL getFXMLLocation() {
        URL url = super.getFXMLLocation();
        if (url == null) {
            url = this.load.getClass().getResource(String.valueOf(((Object)((Object)this)).getClass().getSuperclass().getSuperclass().getSimpleName()) + ".fxml");
        }
        return url;
    }

    @Inject
    public InstructionFuturesPassivePart() {
    }

    @Override
    @FXML
    public void initialize() {
        this.lbUpDownPrice.setVisible(false);
        super.initialize();
        this.cmbPriceType.setDisable(true);
        this.cmbHedgeType.setDisable(true);
        this.cmbPriceTypeLimited.setDisable(true);
        this.lbUpDownPrice.setDisable(true);
        this.cmbPriceTypeBidAsk.setDisable(true);
        this.countStg.setDisable(true);
        this.stkPaneCommon.setDisable(true);
        this.hBoxDistStg.setDisable(true);
        this.checkBoxCol.setEditable(false);
        CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
        this.priceSpn.getEditor().focusedProperty().addListener(this.lstnFocusPrice);
        this.countSpn.getEditor().focusedProperty().addListener(this.lstnFocusQuantity);
        this.initFinished = true;
        Platform.runLater(() -> this.doSetCode());
    }

    @PreDestroy
    private void close() {
        this.priceSpn.getEditor().focusedProperty().removeListener(this.lstnFocusPrice);
        this.countSpn.getEditor().focusedProperty().removeListener(this.lstnFocusQuantity);
    }

    protected void doSetCode() {
        if (!this.initFinished || this.instruction == null) {
            return;
        }
        this.initPanel();
        if (this.instruction.getType().getRaw().equals("64")) {
            this.advice = this.instruction.getOrderAdvice();
            this.model.setInstruction(this.instruction);
            if (this.advice == null) {
                return;
            }
            if (this.instruction.getIsOrderStep()) {
                this.stkPaneCommon.setDisable(false);
            }
            RefItem refItem = this.refMng.getItem(this.advice.getMarket(), this.advice.getSec());
            this.doSecurityChange(refItem);
        }
    }

    private void doSecurityChange(RefItem refItem) {
        super.doChange(refItem);
        if (this.isInstructionEvent && this.advice != null && this.getValidRef() != null && this.instruction.getType().getRaw().equals("64")) {
            this.isInstructionEvent = false;
            this.doOrderFill();
        }
    }

    protected boolean validOrderFill() {
        return false;
    }

    private void doOrderFill() {
        int scale;
        this.lbUpDownPrice.setVisible(false);
        if (this.getValidRef() == null) {
            return;
        }
        long effectiveQuantity = this.instruction.getIsOrderStep() ? this.advice.getOrderAvailableQuantity() : this.advice.getOrderQty();
        this.countSpn.getEditor().setText(Long.toString(effectiveQuantity));
        this.cmbDist.getSelectionModel().select(1);
        this.model.getAccDis().fillAccount(this.instruction);
        this.tableAcct.setItems(this.model.getAccDis().getAccList());
        this.lbUpDownPrice.setText(StringUtils.toPriceStr((double)this.advice.getPrice(), (double)this.getValidRef().getPriceUnit()));
        this.cmbPriceType.getSelectionModel().select((Object)this.model.getPriceStg().getNode(Integer.toString(this.advice.getOrdType())));
        this.cmbHedgeType.getSelectionModel().select((Object)this.model.getHedgeType().getNode(Integer.toString(this.advice.getShFlag())));
        this.buyIn2Sty.setDisable(true);
        this.sellIn2Sty.setDisable(true);
        this.openBuy.setDisable(true);
        this.closeBuy.setDisable(true);
        this.openSell.setDisable(true);
        this.closeSell.setDisable(true);
        if (this.advice.getSide() == 49 && this.advice.getOcFlag() == 79) {
            this.btnOrder.setText("\u4e70\u5f00\u5ba1\u6279\u901a\u8fc7");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.setOrderType("order_open_buy");
            if (this.isExecution() && this.model.getPreModel().getKeyStyle().equals("1")) {
                this.buyIn2Sty.requestFocus();
                this.buyIn2Sty.setDisable(false);
            } else if (this.isExecution() && this.model.getPreModel().getKeyStyle().equals("2")) {
                this.openBuy.requestFocus();
                this.openBuy.setDisable(false);
            }
        } else if (this.advice.getSide() == 49 && (this.advice.getOcFlag() == 67 || this.advice.getOcFlag() == 84)) {
            this.btnOrder.setText("\u4e70\u5e73\u5ba1\u6279\u901a\u8fc7");
            CssUtils.addStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.setOrderType("order_close_buy");
            if (this.isExecution() && this.model.getPreModel().getKeyStyle().equals("1")) {
                this.buyIn2Sty.requestFocus();
                this.buyIn2Sty.setDisable(false);
            } else if (this.isExecution() && this.model.getPreModel().getKeyStyle().equals("2")) {
                this.closeBuy.requestFocus();
                this.closeBuy.setDisable(false);
            }
        } else if (this.advice.getSide() == 50 && this.advice.getOcFlag() == 79) {
            this.btnOrder.setText("\u5356\u5f00\u5ba1\u6279\u901a\u8fc7");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.setOrderType("order_open_sell");
            if (this.isExecution() && this.model.getPreModel().getKeyStyle().equals("1")) {
                this.sellIn2Sty.requestFocus();
                this.sellIn2Sty.setDisable(false);
            } else if (this.isExecution() && this.model.getPreModel().getKeyStyle().equals("2")) {
                this.openSell.requestFocus();
                this.openSell.setDisable(false);
            }
        } else if (this.advice.getSide() == 50 && (this.advice.getOcFlag() == 67 || this.advice.getOcFlag() == 84)) {
            this.btnOrder.setText("\u5356\u5e73\u5ba1\u6279\u901a\u8fc7");
            CssUtils.removeStyleClass((Control)this.btnOrder, (String)"btnRed");
            this.setOrderType("order_close_sell");
            if (this.isExecution() && this.model.getPreModel().getKeyStyle().equals("1")) {
                this.sellIn2Sty.requestFocus();
                this.sellIn2Sty.setDisable(false);
            } else if (this.isExecution() && this.model.getPreModel().getKeyStyle().equals("2")) {
                this.closeSell.requestFocus();
                this.closeSell.setDisable(false);
            }
        }
        if (this.model.getPriceTypeLimitedStg() != null && this.advice.getPriceLimit() != 0) {
            String limitStg = "";
            if (this.advice.getPriceLimit() == 1 || this.advice.getPriceLimit() == 4) {
                limitStg = "5";
                this.cmbPriceTypeLimited.getSelectionModel().select((Object)this.model.getPriceTypeLimitedStg().getNode(limitStg));
            } else {
                limitStg = Integer.toString(this.advice.getPriceLimit());
                this.cmbPriceTypeLimited.getSelectionModel().select((Object)this.model.getPriceTypeLimitedStg().getNode(limitStg));
            }
        }
        if (this.model.getPriceTypeBidAskStg() != null) {
            this.cmbPriceTypeBidAsk.getSelectionModel().select((Object)this.model.getPriceTypeBidAskStg().getNode(Integer.toString(this.advice.getPriceTypeBidAsk())));
            this.model.setBidAskPrice();
        }
        if (this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            if (this.model.isSpecify()) {
                double price = this.advice.getPrice();
                if (this.model.isValidRef()) {
                    scale = this.getValidRef().getScale();
                    if (scale == 0) {
                        this.priceSpn.getEditor().setText(String.valueOf((int)price));
                        this.model.setPrice(price);
                    } else {
                        this.model.setPrice(price);
                        this.priceSpn.getValueFactory().setValue((Object)price);
                    }
                }
            } else {
                this.priceSpn.getEditor().clear();
            }
        }
        if (!this.instruction.getIsOrderStep() && this.model.isLimitPrice()) {
            double price = this.advice.getPrice();
            if (this.model.isValidRef()) {
                scale = this.getValidRef().getScale();
                if (scale == 0) {
                    this.priceSpn.getEditor().setText(String.valueOf((int)price));
                    this.model.setPrice(price);
                } else {
                    this.model.setPrice(price);
                    this.priceSpn.getValueFactory().setValue((Object)price);
                }
            }
        }
        if (this.model.isLimit()) {
            this.lbUpDownPrice.setVisible(true);
        }
        this.onApprove(true);
        this.tableAcct.refresh();
    }

    private void clearPanel() {
        this.setInApprove(false);
        this.advice = null;
        this.instruction = null;
        this.lbUpDownPrice.setVisible(false);
        this.txtCode.requestFocus();
        this.txtCode.clear();
        this.onSecurityChange();
        this.cmbPriceType.getSelectionModel().select(0);
        this.cmbHedgeType.getSelectionModel().select(0);
        this.cmbPriceTypeLimited.getSelectionModel().select(0);
        this.countSpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.model.getAccDis().setActive(true);
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new Instruction());
        this.onApprove(false);
        this.model.getAccDis().setActive(true);
        this.stkPaneCommon.setDisable(true);
    }

    private void initPanel() {
        this.setInApprove(true);
        this.isInstructionEvent = true;
        this.onApprove(true);
        this.lbUpDownPrice.setVisible(false);
        this.txtCode.clear();
        this.countSpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.countStg.getSelectionModel().select(0);
        this.model.setInstruction(new Instruction());
        this.model.getAccDis().setActive(false);
        this.stkPaneCommon.setDisable(true);
    }

    protected void onApprove(boolean disable) {
        this.txtCode.setEditable(!disable);
    }

    @Override
    @FXML
    protected void orderOpenBuy() {
        this.modifyQuantity();
        super.orderOpenBuy();
    }

    @Override
    @FXML
    protected void orderOpenSell() {
        this.modifyQuantity();
        super.orderOpenSell();
    }

    @Override
    @FXML
    protected void orderCloseBuy() {
        this.modifyQuantity();
        super.orderCloseBuy();
    }

    @Override
    @FXML
    protected void orderCloseSell() {
        this.modifyQuantity();
        super.orderCloseSell();
    }

    @Override
    @FXML
    protected void orderBuy() {
        this.modifyQuantity();
        super.orderBuy();
    }

    @Override
    @FXML
    protected void orderSell() {
        this.modifyQuantity();
        super.orderSell();
    }

    @Override
    protected void order() {
        super.order();
        if ("3".equals(this.model.getAccDis().getInstructType())) {
            this.clearPanel();
        } else if (this.preModel.isClearAfterOrder()) {
            this.clearPanel();
        } else {
            Timer timer = new Timer();
            TimerTask task = new TimerTask(){

                @Override
                public void run() {
                    Platform.runLater(() -> {
                        try {
                            InstructionFuturesPassivePart.this.model.getInstructionModel().refreshResource(InstructionFuturesPassivePart.this.instruction);
                        }
                        catch (MException mException) {
                            InstructionFuturesPassivePart.this.alert.alert(Alert.AlertType.ERROR, "\u81ea\u52a8\u586b\u5165\u5269\u4f59\u6570\u91cf\u5f02\u5e38\uff0c\u8bf7\u624b\u52a8\u518d\u6b21\u6267\u884c\u586b\u5355");
                        }
                        if (InstructionFuturesPassivePart.this.instruction.getResource().getAvailOrderQty() <= 0L) {
                            InstructionFuturesPassivePart.this.clearPanel();
                            return;
                        }
                        InstructionFuturesPassivePart.this.advice = InstructionFuturesPassivePart.this.instruction.getOrderAdvice();
                        InstructionFuturesPassivePart.this.countSpn.getEditor().clear();
                        InstructionFuturesPassivePart.this.priceSpn.getEditor().clear();
                        InstructionFuturesPassivePart.this.model.onSecChange();
                        InstructionFuturesPassivePart.this.countSpn.getEditor().setText(StringUtils.toStr((double)InstructionFuturesPassivePart.this.instruction.getResource().getAvailOrderQty(), (int)0));
                    });
                }
            };
            timer.schedule(task, 1000L);
        }
    }

    @Override
    public boolean valid() {
        String tip1 = "\u8bf7\u4ece\u6307\u4ee4\u5217\u8868\u4e2d\u586b\u5165\u6307\u4ee4";
        if (!this.alert.check(this.isInApprove(), Alert.AlertType.WARNING, tip1)) {
            return false;
        }
        return super.valid();
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() || this.model.isUnlimited() || this.model.isSpecify() || this.model.getAccDis().isActive(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty(), this.model.getAccDis().activeProperty()}));
    }

    @Override
    protected void countDisableBind() {
        this.countSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1") || this.model.getAccDis().isActive(), (Observable[])new Observable[]{this.model.countStgProperty(), this.model.getAccDis().activeProperty()}));
    }

    @Override
    public void setPrice(double price) {
        if (this.model.isLimitPrice() && price > 0.0 && !this.model.isUnlimited() && !this.priceSpn.isDisabled()) {
            this.priceSpn.getValueFactory().setValue((Object)price);
        }
    }

    @Override
    protected void onMktItemChange() {
    }

    @Override
    protected void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            this.txtCode.selectAll();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.priceSpn.requestFocus();
            this.modifyQuantity();
            if (this.advice.getSide() == 49 && this.advice.getOcFlag() == 79) {
                this.orderOpenBuy();
            } else if (this.advice.getSide() == 49 && this.advice.getOcFlag() == 67) {
                this.orderCloseBuy();
            } else if (this.advice.getSide() == 50 && this.advice.getOcFlag() == 79) {
                this.orderOpenSell();
            } else if (this.advice.getSide() == 50 && this.advice.getOcFlag() == 67) {
                this.orderCloseSell();
            }
            this.preModel.selectTwoOrAllPriceDecimal();
            key.consume();
        }
    }

    private void modifyQuantity() {
        long effectiveQuantity;
        long l = effectiveQuantity = this.instruction.getIsOrderStep() ? this.advice.getOrderAvailableQuantity() : this.advice.getOrderQty();
        if (this.model.getCount() > effectiveQuantity) {
            this.model.setCount(effectiveQuantity);
            this.countSpn.getEditor().requestFocus();
            this.countSpn.getEditor().selectAll();
        }
    }
}

