/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.viewers;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.futures.instructions.viewers.InstructionFuturesPassivePart;
import cms.tmx.futures.views.FuturesEntrustConfirmDialog;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionFuturesExecutionPart
extends InstructionFuturesPassivePart {
    private MxNode node = MxNodeFactory.create((String)"cstr_price_type_limited", (String)"5");

    @Inject
    public InstructionFuturesExecutionPart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.es.subscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    @FXML
    public void initialize() {
        this.model.create("4");
        this.setBuySymbol("\u4e70\u5165");
        this.setSellSymbol("\u5356\u51fa");
        super.setExecution(true);
        super.initialize();
    }

    @PreDestroy
    public void destroy() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    protected void getSymbol(FuturesEntrustConfirmDialog obj, String type) {
        block18: {
            if (!"5".equals(this.model.getPriceTypeLimitedStg().getRaw())) break block18;
            switch (type) {
                case "order_open_buy": 
                case "order_close_buy": 
                case "order_buy": {
                    this.node.setRaw("1");
                    break;
                }
                case "order_open_sell": 
                case "order_sell": 
                case "order_close_sell": {
                    this.node.setRaw("4");
                    break;
                }
            }
            obj.setPriceTypeLimitedStg(this.node);
        }
    }

    @Override
    protected boolean validOrderFill() {
        Instruction eventInstr = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        return "64".equals(eventInstr.getType().getRaw()) && eventInstr.getIsOrderStep();
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        return this.alert.check(this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    public void setPrice(double price) {
        if (this.model.isLimitPrice() && !this.model.isSpecify() && price > 0.0) {
            this.model.setPrice(price);
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.priceSpn.getEditor().requestFocus();
            this.priceSpn.getEditor().selectAll();
        }
    }

    @Override
    protected void setPrePrice() {
        if (this.model.isBidAskPrice() && !this.priceSettle) {
            this.model.setBidAskPrice();
            double price = this.model.getPrice();
            if (this.model.isValidRef()) {
                int scale = this.getValidRef().getScale();
                if (scale == 0) {
                    this.priceSpn.getEditor().setText(String.valueOf((int)price));
                    this.model.setPrice(price);
                } else {
                    this.model.setPrice(price);
                    this.priceSpn.getValueFactory().setValue((Object)price);
                }
            }
            if (this.model.getPrice() > 0.0) {
                this.priceSettle = true;
            }
        }
    }

    @Override
    protected ObservableList<Boolean> doAction() throws MException, Exception {
        this.model.execute(this.instruction);
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.future.part.unorder");
        }
        return super.doAction();
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.isLimitPrice() || this.model.isSpecify() || this.model.getAccDis().isActive(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty(), this.model.getAccDis().activeProperty()}));
    }
}

