/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.viewers;

import cms.tmx.core.MException;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.futures.instructions.viewers.InstructionFuturesPassivePart;
import cms.tmx.futures.views.FuturesEntrustConfirmDialog;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;

public class InstructionFuturesApprovePart
extends InstructionFuturesPassivePart {
    private MxNode node = MxNodeFactory.create((String)"cstr_price_type_limited", (String)"5");

    @Inject
    public InstructionFuturesApprovePart() {
    }

    @PostConstruct
    public void init() {
        super.init();
        this.es.subscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    @FXML
    public void initialize() {
        this.model.create("3");
        this.setBuySymbol("\u5ba1\u6279\u901a\u8fc7");
        this.setSellSymbol("\u5ba1\u6279\u901a\u8fc7");
        this.setConfirmSymbol("\u5ba1\u6279");
        super.setApprove(true);
        super.initialize();
    }

    @PreDestroy
    public void destroy() {
        this.es.unSubscribe("instruction.set.on.panel", this.hSetCode);
    }

    @Override
    protected void getSymbol(FuturesEntrustConfirmDialog obj, String type) {
        block18: {
            if (!"5".equals(this.model.getPriceTypeLimitedStg().getRaw())) break block18;
            switch (type) {
                case "order_open_buy": 
                case "order_close_buy": 
                case "order_buy": {
                    this.node.setRaw("1");
                    break;
                }
                case "order_open_sell": 
                case "order_sell": 
                case "order_close_sell": {
                    this.node.setRaw("4");
                    break;
                }
            }
            obj.setPriceTypeLimitedStg(this.node);
        }
    }

    @Override
    protected boolean validOrderFill() {
        Instruction eventInstr = (Instruction)Instruction.class.cast(this.instructEvent.get((Object)"instruction"));
        return "64".equals(eventInstr.getType().getRaw()) && !eventInstr.getIsOrderStep();
    }

    @Override
    protected boolean priceValid() {
        return true;
    }

    @Override
    protected void priceDisableBind() {
        this.priceSpn.setDisable(true);
    }

    @Override
    protected void countDisableBind() {
        this.countSpn.setDisable(true);
    }

    @Override
    protected void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.isSpecify(), (Observable[])new Observable[]{this.model.priceTypeLimitedStgProperty(), this.model.priceStgProperty()}));
    }

    @Override
    protected ObservableList<Boolean> doAction() throws Exception, MException {
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.future.instructions.part.instruct.query");
        }
        return this.model.submitApprove(this.instruction, this.orderType);
    }
}

