/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.viewers;

import cms.tmx.core.MException;
import cms.tmx.futures.instructions.viewers.InstructionFuturesBasePart;
import cms.tmx.futures.views.FuturesEntrustConfirmDialog;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javax.inject.Inject;

public class InstructionFuturesAdvisorPart
extends InstructionFuturesBasePart {
    private MxNode node = MxNodeFactory.create((String)"cstr_price_type_limited", (String)"5");

    @Inject
    public InstructionFuturesAdvisorPart() {
    }

    @Override
    @FXML
    public void initialize() {
        this.model.create("2");
        this.setConfirmSymbol("\u5efa\u8bae");
        super.initialize();
        this.mktItem.changedProperty().addListener(ob -> this.setPrePrice());
    }

    @Override
    protected boolean priceValid() {
        String tip3 = "\u672a\u8f93\u5165\u4ef7\u683c";
        if (!this.alert.check(!this.model.isLimitPrice() || this.model.isUnlimited() || this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3)) {
            return false;
        }
        return !this.model.isBidAskPrice() || this.alert.check(this.model.getPrice() > 0.0, Alert.AlertType.WARNING, tip3);
    }

    @Override
    @FXML
    protected void orderBuy() {
        this.setOrderType("order_buy");
        super.orderBuy();
    }

    @Override
    @FXML
    protected void orderSell() {
        this.setOrderType("order_sell");
        super.orderSell();
    }

    @Override
    protected void getSymbol(FuturesEntrustConfirmDialog obj, String type) {
        block44: {
            String ocFlag = null;
            if ("79" == obj.getList().get(0).getOffsetFlag().getRaw()) {
                ocFlag = "\u5f00";
            } else if ("67" == obj.getList().get(0).getOffsetFlag().getRaw() || "84" == obj.getList().get(0).getOffsetFlag().getRaw()) {
                ocFlag = "\u5e73";
            }
            switch (type) {
                case "order_buy": {
                    this.setBuySymbol("\u5efa\u8bae\u4e70" + ocFlag);
                    break;
                }
                case "order_open_buy": {
                    this.setBuySymbol("\u5efa\u8bae\u4e70\u5f00");
                    break;
                }
                case "order_close_buy": {
                    this.setBuySymbol("\u5efa\u8bae\u4e70\u5e73");
                    break;
                }
                case "order_sell": {
                    this.setSellSymbol("\u5efa\u8bae\u5356" + ocFlag);
                    break;
                }
                case "order_open_sell": {
                    this.setSellSymbol("\u5efa\u8bae\u5356\u5f00");
                    break;
                }
                case "order_close_sell": {
                    this.setSellSymbol("\u5efa\u8bae\u5356\u5e73");
                    break;
                }
            }
            if (!"5".equals(this.model.getPriceTypeLimitedStg().getRaw())) break block44;
            switch (type) {
                case "order_open_buy": 
                case "order_close_buy": 
                case "order_buy": {
                    this.node.setRaw("1");
                    break;
                }
                case "order_open_sell": 
                case "order_sell": 
                case "order_close_sell": {
                    this.node.setRaw("4");
                    break;
                }
            }
            obj.setPriceTypeLimitedStg(this.node);
        }
    }

    @Override
    protected ObservableList<Boolean> doAction() throws Exception, MException {
        if (this.preModel.isUnfinishedAfterOrder()) {
            this.uiService.showPart("cms.tmx.future.instructions.part.instruct.query");
        }
        return this.model.submitAdvice(this.orderType);
    }
}

