/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.viewers;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.formatters.MxFormatter;
import cms.tmx.control.formatters.SecFilter;
import cms.tmx.control.search.Search;
import cms.tmx.control.spinner.DoubleSpinnerCtrl;
import cms.tmx.control.spinner.IntSpinnerCtrl;
import cms.tmx.control.utils.TooltipUtil;
import cms.tmx.core.MEventHandler;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.utils.FuturePriceCell;
import cms.tmx.data.utils.HandicapCountCell;
import cms.tmx.data.utils.HandicapOrderCell;
import cms.tmx.data.utils.SecConverter;
import cms.tmx.data.utils.SecSuggest;
import cms.tmx.entity.data.HandicapInfo;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.FutureMarket;
import cms.tmx.futures.FuturesUtils;
import cms.tmx.futures.instructions.models.FuturesTradeMarketModel;
import cms.tmx.futures.instructions.models.UserPreCtrlFuturesMarket;
import cms.tmx.futures.models.FutureMarketListModel;
import cms.tmx.futures.views.FuturesEntrustConfirmDialog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxBindings;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.query.current.models.CtpUnfinishedOrderModel;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.settings.UserPreOrderTips;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.UnaryOperator;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Spinner;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FuturesTradeMarketPart
extends MxPart {
    @FXML
    private TableView<FutureMarket> tableMarketList;
    @FXML
    private TableView<HandicapInfo> tableSell;
    @FXML
    private TableView<HandicapInfo> tableBuy;
    @FXML
    private TableColumn<String, String> colSellIndex;
    @FXML
    private TableColumn<String, String> colBuyIndex;
    @FXML
    private TableColumn<HandicapInfo, String> colSellPrice;
    @FXML
    private TableColumn<HandicapInfo, String> colBuyPrice;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyCount;
    @FXML
    private TableColumn<HandicapInfo, Number> colSellOrder;
    @FXML
    private TableColumn<HandicapInfo, Number> colBuyOrder;
    @FXML
    private CheckBox checkHedge;
    @FXML
    private CheckBox checkArbitrage;
    @FXML
    private CheckBox checkSplit;
    @FXML
    private TextField txtCode;
    @FXML
    private Label lbName;
    @FXML
    private ComboBox<MxNode> cmbOcFlag;
    @FXML
    private ComboBox<MxNode> cmbPriceType;
    @FXML
    private ComboBox<MxNode> cmbPriceTypeLimited;
    @FXML
    private ComboBox<MxNode> cmbPriceTypeBidAsk;
    @FXML
    private Spinner<Double> priceSpn;
    @FXML
    private Spinner<Integer> countSpn;
    @FXML
    private ComboBox<MxNode> countStg;
    @FXML
    private Spinner<Integer> spnSplitCount;
    @FXML
    private HBox hboxCounts;
    @FXML
    private Label lbCountOne;
    @FXML
    private Label lbCountTwo;
    @FXML
    private Label lbCountThree;
    @FXML
    private Label lbCountFour;
    @FXML
    private Button btnBuy;
    @FXML
    private Button btnSell;
    @FXML
    private Label lbNowPrice;
    @FXML
    private Label lbRate;
    @FXML
    private Label lbUpLimit;
    @FXML
    private Label lbDownLimit;
    @FXML
    private ComboBox<String> cmbAcct;
    private MxList<FutureMarket> mlist = new MxList();
    @FXML
    private TableColumn<FutureMarket, String> code;
    @FXML
    private TableColumn<FutureMarket, Number> isMain;
    @FXML
    private TableColumn<FutureMarket, String> lastDay;
    @FXML
    private TableColumn<FutureMarket, Number> lastPrice;
    @FXML
    private TableColumn<FutureMarket, Number> qtyBuy;
    @FXML
    private TableColumn<FutureMarket, String> priceBuy;
    @FXML
    private TableColumn<FutureMarket, String> priceSell;
    @FXML
    private TableColumn<FutureMarket, Number> qtySell;
    @FXML
    private TableColumn<FutureMarket, Number> openPrice;
    @FXML
    private TableColumn<FutureMarket, Number> highestPrice;
    @FXML
    private TableColumn<FutureMarket, Number> lowestPrice;
    @FXML
    private TableColumn<FutureMarket, Number> totalDealQty;
    @FXML
    private TableColumn<FutureMarket, Number> totalPositionQty;
    @FXML
    private TableColumn<FutureMarket, Number> lastDealQty;
    @FXML
    private TableColumn<FutureMarket, Number> lastPositionQty;
    @Inject
    private FutureMarketListModel marketListModel;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private UserPreOrderTips setTips;
    @Inject
    private FuturesTradeMarketModel model;
    @Inject
    private UserPreCtrlFuturesMarket preModel;
    @Inject
    private MxAlert alert;
    @Inject
    private DialogFactory df;
    @Inject
    private MEventService es;
    @Inject
    private MObjFactory of;
    private MarketItem mktItem;
    private SecSuggest spCode = new SecSuggest();
    private DoubleSpinnerCtrl ctrlPrice = new DoubleSpinnerCtrl(true, 6, 3);
    private IntSpinnerCtrl ctrlCount = new IntSpinnerCtrl(true, 9, 1);
    private IntSpinnerCtrl ctrlSplitCount = new IntSpinnerCtrl(true, 9, 1);
    private static final Logger logger = LogManager.getLogger(FuturesTradeMarketPart.class);
    private String orderType = "";
    private boolean priceSettle = false;
    private SecConverter secCvt;
    private String buySymbol = "\u4e70\u5165";
    private String sellSymbol = "\u5356\u51fa";
    private String confirmSymbol = "";
    @Inject
    private CtpUnfinishedOrderModel unfinishedModel;
    @Inject
    private ExecutorService exe;
    public Map<String, List<CtpOrder>> map;
    private double selectPrice;
    private FutureMarket market;
    private boolean selectFlag = false;
    private List<RefItem> nationalRefList = null;
    private InvalidationListener listenerMktItem = ob -> this.onMarketChange();
    private List<HandicapInfo> listBuyHandicap = new ArrayList<HandicapInfo>();
    private List<HandicapInfo> listSellHandicap = new ArrayList<HandicapInfo>();
    private InvalidationListener listenerUnfinishChange = ob -> this.resetMarketOrder();
    private MEventHandler handler = event -> {
        String secCode = event.getStr("sec_code");
        String side = event.getStr("side_sell");
        Platform.runLater(() -> {
            this.txtCode.requestFocus();
            if (this.txtCode.isFocused()) {
                this.txtCode.setText(secCode);
                if (side.equals("49") || side.equals("2")) {
                    this.btnBuy.requestFocus();
                } else if (side.equals("50") || side.equals("1")) {
                    this.btnSell.requestFocus();
                }
            }
        });
    };
    private List<CtpOrder> orders = new ArrayList<CtpOrder>();
    private ObservableList<RefItem> obList = FxUtils.newArrayList();
    private InvalidationListener lstnModel = ob -> Platform.runLater(() -> {
        ObservableList<FutureMarket> observableList = this.marketListModel.getList();
        synchronized (observableList) {
            this.mlist.update(this.marketListModel.getList());
        }
        this.tableMarketList.refresh();
    });
    private SecSuggest.StrSuggest strSuggest = SecSuggest.getStrSuggest();

    private List<RefItem> getRefList() {
        if (this.nationalRefList == null || this.nationalRefList.size() == 0) {
            this.nationalRefList = FuturesUtils.getNationalDebtCode(this.refMng.getItems(new String[]{"FUT"}));
        }
        this.nationalRefList.sort((o1, o2) -> o1.getCode().compareTo(o2.getCode()));
        return this.nationalRefList;
    }

    public void initListenerUnfinish() {
        this.mktItem.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerMktItem));
        this.unfinishedModel.changedProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.listenerUnfinishChange));
        if (this.unfinishedModel.getList().size() == 0) {
            this.exe.execute(() -> this.unfinishedModel.query());
        }
    }

    private void onMarketChange() {
        this.exe.execute(() -> {
            long start = System.currentTimeMillis();
            if (this.isSame(this.listSellHandicap, (List<HandicapInfo>)this.mktItem.getListSellHandicap()) && this.isSame(this.listBuyHandicap, (List<HandicapInfo>)this.mktItem.getListBuyHandicap())) {
                logger.error("\u4e0b\u8fbe\u59d4\u6258\uff0c\u884c\u60c5\u76f8\u540c\uff0c\u4e0d\u5237\u65b0\uff01");
            } else {
                logger.error("\u4e0b\u8fbe\u59d4\u6258\uff0c\u884c\u60c5\u4e0d\u76f8\u540c\uff0c\u5237\u65b0\uff01");
                this.resetMarketOrder();
                if (this.model.isBidAskPrice()) {
                    double price = this.model.getHandicapPrice();
                    Platform.runLater(() -> this.model.setPrice(price));
                }
            }
            this.update();
            logger.error("\u884c\u60c5\u53d8\u5316\uff1a" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        });
    }

    private void update() {
        this.updateHandicapInfo(this.listBuyHandicap, (List<HandicapInfo>)this.mktItem.getListBuyHandicap());
        this.updateHandicapInfo(this.listSellHandicap, (List<HandicapInfo>)this.mktItem.getListSellHandicap());
    }

    private void updateHandicapInfo(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int i = 0;
        while (i < 5) {
            if (listInfo.size() <= i) {
                listHandicap.get(i).clear();
            }
            listHandicap.get(i).update((Object)listInfo.get(i));
            ++i;
        }
    }

    private boolean isSame(List<HandicapInfo> listHandicap, List<HandicapInfo> listInfo) {
        int i = 0;
        while (i < 5) {
            if (listHandicap.get(i).getPrice() != listInfo.get(i).getPrice()) {
                logger.error("old: " + listHandicap.get(i).getPrice() + "new: " + listInfo.get(i).getPrice());
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void resetMarketOrder() {
        if (this.mktItem.getRefItem() != null && this.txtCode.getText().equals(this.mktItem.getRefItem().getCode()) && !this.mktItem.getRefItem().getCode().isEmpty()) {
            int count;
            long start = System.currentTimeMillis();
            ObservableList observableList = this.unfinishedModel.getList();
            synchronized (observableList) {
                this.orders.clear();
                this.orders.addAll((Collection<CtpOrder>)this.unfinishedModel.getList());
            }
            for (HandicapInfo info : this.mktItem.getListSellHandicap()) {
                info.setOrder(0);
                if (this.orders == null || this.orders.isEmpty()) continue;
                for (CtpOrder order : this.orders) {
                    if (!order.getSecId().equals(this.txtCode.getText()) || order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            for (HandicapInfo info : this.mktItem.getListBuyHandicap()) {
                info.setOrder(0);
                if (this.orders == null || this.orders.isEmpty()) continue;
                for (CtpOrder order : this.orders) {
                    if (!order.getSecId().equals(this.txtCode.getText()) || order.getPrice() != info.getPrice()) continue;
                    count = info.getOrder() + order.getOrderQty() - order.getCumQty();
                    info.setOrder(count);
                }
            }
            logger.error("resetMarketOrder\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        }
    }

    @FXML
    public void initialize() {
        this.mktItem = this.model.getMI();
        this.initListenerUnfinish();
        this.mktItem.refItemProperty().addListener(ob -> this.onRefChange());
        this.refMng.changedProperty().addListener(ob -> {
            this.spCode.setAllSuggestions(this.getRefList());
            this.obList.setAll(this.getRefList());
        });
        this.initUserPre();
        this.initControls();
        this.createMarketTable();
        this.createMarketTab();
        this.es.subscribe("input_futures_trade_market", this.handler);
        this.cmbPriceTypeLimited.valueProperty().unbindBidirectional(this.model.priceTypeLimitedStgProperty());
        MxNode node = MxNodeFactory.create((String)"cstr_price_type_limited", (String)"2");
        node.removeOthers("2");
        this.cmbPriceTypeLimited.setItems(node.getNodes());
        this.cmbPriceTypeLimited.setValue((Object)node.getNode("2"));
        this.marketListModel.changedProperty().addListener(this.lstnModel);
        this.listenerUnfinishChange.invalidated(null);
        int i = 0;
        while (i < 5) {
            HandicapInfo infoBuy = new HandicapInfo();
            HandicapInfo infoSell = new HandicapInfo();
            infoBuy.setIndex(i + 1);
            infoSell.setIndex(i + 1);
            this.listBuyHandicap.add(infoBuy);
            this.listSellHandicap.add(infoSell);
            ++i;
        }
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("input_futures_trade_market", this.handler);
        this.marketListModel.changedProperty().removeListener(this.lstnModel);
    }

    private void initControls() {
        this.cmbAcct.valueProperty().bindBidirectional((Property)this.model.fundAcctProperty());
        if (this.model.accMng.getFundAccList().size() == 0) {
            logger.debug("\u8d44\u91d1\u8d26\u53f7\u4e3a\u7a7a\uff0c\u89e6\u53d1\u76d1\u542c...");
            this.model.accMng.changedProperty().addListener((ob, old, now) -> {
                logger.debug("\u8d44\u91d1\u8d26\u53f7change\u5df2\u89e6\u53d1" + this.model.accMng.getFundAccList().size());
                this.cmbAcct.getItems().setAll((Collection)this.model.accMng.getFundAccList());
                this.strSuggest.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
                Platform.runLater(() -> this.cmbAcct.getSelectionModel().select(0));
            });
        } else {
            logger.debug("FutureManualPart \u8d44\u91d1\u8d26\u53f7\u4e0d\u4e3a\u7a7a\uff0c");
            this.cmbAcct.getItems().setAll((Collection)this.model.accMng.getFundAccList());
            this.strSuggest.addPossibleSuggestions((Collection)this.model.accMng.getFundAccList());
        }
        Search.bindAutoCompletion((TextField)this.cmbAcct.getEditor(), (Callback)this.strSuggest);
        this.cmbAcct.getEditor().setTextFormatter((TextFormatter)new MxFormatter("[0-9]+", 16));
        this.cmbAcct.getSelectionModel().select(0);
        this.cmbAcct.getEditor().textProperty().addListener((ob, old, now) -> {
            this.cmbAcct.getSelectionModel().select(now);
            this.cmbAcct.hide();
        });
        this.checkHedge.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.checkArbitrage.isSelected()) {
                this.checkArbitrage.setSelected(false);
            }
        });
        this.checkArbitrage.selectedProperty().addListener((ob, old, now) -> {
            if (now.booleanValue() && this.checkHedge.isSelected()) {
                this.checkHedge.setSelected(false);
            }
        });
        this.secCvt = (SecConverter)this.of.create(SecConverter.class);
        this.spCode.addPossibleSuggestions(this.getRefList());
        this.obList.setAll(this.getRefList());
        Search.bindAutoCompletion((TextField)this.txtCode, (Callback)this.spCode, (StringConverter)this.secCvt).changedProperty().addListener((ob, oldV, newV) -> {
            this.onSecurityChange();
            this.tableBuy.refresh();
            this.tableSell.refresh();
        });
        this.txtCode.setTextFormatter(new TextFormatter((UnaryOperator)new SecFilter("[A-Za-z0-9]*", 6)));
        this.txtCode.addEventFilter(KeyEvent.KEY_PRESSED, event -> this.codeKeyPress((KeyEvent)event));
        this.txtCode.focusedProperty().addListener((ob, old, newV) -> this.loseFocus((Boolean)newV));
        this.txtCode.textProperty().bindBidirectional((Property)this.model.securityProperty());
        this.lbName.textProperty().bindBidirectional((Property)this.model.nameProperty());
        TooltipUtil.bind((Label)this.lbName);
        this.cmbOcFlag.setItems(this.model.getOcFlag().getNodes());
        this.cmbOcFlag.valueProperty().bindBidirectional(this.model.ocFlagProperty());
        this.cmbPriceType.setItems(this.model.getPriceStg().getNodes());
        this.cmbPriceType.valueProperty().bindBidirectional(this.model.priceStgProperty());
        this.cmbPriceType.valueProperty().addListener(ob -> this.checkPriceType());
        this.cmbPriceTypeLimited.setItems(this.model.getPriceTypeLimitedStg().getNodes());
        this.cmbPriceTypeLimited.valueProperty().bindBidirectional(this.model.priceTypeLimitedStgProperty());
        this.cmbPriceTypeLimited.valueProperty().addListener((ob, old, now) -> this.onPriceTypeLimitedChange((MxNode)now));
        this.cmbPriceTypeBidAsk.setItems(this.model.getPriceTypeBidAskStg().getNodes());
        this.cmbPriceTypeBidAsk.valueProperty().bindBidirectional(this.model.priceTypeBidAskStgProperty());
        this.ctrlPrice.ctrl(this.priceSpn);
        this.priceDisableBind();
        MxBindings.bindSD((Property)this.priceSpn.getEditor().textProperty(), (Property)this.model.priceProperty());
        this.priceSpn.getEditor().setText("");
        this.priceVisibleBind();
        this.priceSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.priceKeyPress((KeyEvent)event));
        this.priceSpn.getEditor().setOnMouseClicked(event -> this.preModel.selectTwoOrAllPriceDecimal());
        this.priceSpn.getEditor().focusedProperty().addListener((ob, old, newV) -> this.pricelLoseFocus((Boolean)newV));
        this.model.priceProperty().addListener((observ, old, now) -> {
            if (this.model.isValidRef() && !this.priceSpn.getEditor().isFocused()) {
                double price = this.model.getPrice();
                int scale = this.getValidRef().getScale();
                if (scale == 0) {
                    this.priceSpn.getEditor().setText(String.valueOf((int)price));
                    this.model.setPrice(price);
                } else {
                    this.model.setPrice(price);
                    this.priceSpn.getValueFactory().setValue((Object)price);
                }
            }
        });
        this.ctrlCount.ctrl(this.countSpn);
        this.countDisableBind();
        MxBindings.bindSI((Property)this.countSpn.getEditor().textProperty(), (Property)this.model.countProperty());
        this.countSpn.getEditor().addEventFilter(KeyEvent.KEY_PRESSED, event -> this.quantityKeyPress((KeyEvent)event));
        this.countSpn.getEditor().setOnMouseClicked(event -> this.countSpn.getEditor().selectAll());
        this.ctrlSplitCount.ctrl(this.spnSplitCount);
        this.spnSplitCount.getEditor().setText("39");
        this.spnSplitCount.disableProperty().bind((ObservableValue)this.checkSplit.selectedProperty().not());
        this.countStg.setItems(this.model.getCountStg().getNodes());
        this.countStg.valueProperty().bindBidirectional(this.model.countStgProperty());
        this.hboxCounts.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
        this.btnBuy.addEventHandler(KeyEvent.KEY_PRESSED, event -> this.orderBuyKeyPress((KeyEvent)event));
        this.btnSell.addEventHandler(KeyEvent.KEY_PRESSED, event -> this.orderSellKeyPress((KeyEvent)event));
        CssUtils.addStyleClass((Control)this.btnBuy, (String)"btnRed");
        CssUtils.addStyleClass((Control)this.btnSell, (String)"btnBlue");
    }

    private void onSecurityChange() {
        RefItem refItem = null;
        Object obj = this.txtCode.getUserData();
        if (obj instanceof RefItem) {
            refItem = (RefItem)RefItem.class.cast(obj);
        }
        this.doChange(refItem);
    }

    private void doChange(RefItem refItem) {
        this.model.getMI().setRefItem(refItem);
        this.countSpn.getEditor().clear();
        this.priceSpn.getEditor().clear();
        this.model.onSecChange();
        this.resetMarketOrder();
        this.preModel.onSecurityChange();
        this.p.layout();
        if (refItem != null) {
            this.txtCode.setText(refItem.getCode());
            this.txtCode.selectEnd();
            this.txtCode.deselect();
        }
        if (this.txtCode.getText().length() >= 6 && refItem == null) {
            this.check();
        }
        if (this.selectFlag) {
            this.selectFlag = false;
            this.model.setPrice(this.selectPrice);
        }
        if (this.model.isValidRef()) {
            this.priceSettle = false;
            this.setPrePrice();
        }
    }

    private void setPrePrice() {
        if (this.model.getPrice() > 0.0 || this.priceSpn.isDisabled() || this.priceSettle) {
            return;
        }
        double price = this.preModel.getDefPrice();
        if (this.model.isValidRef()) {
            int scale = this.getValidRef().getScale();
            if (scale == 0) {
                this.priceSpn.getEditor().setText(String.valueOf((int)price));
                this.model.setPrice(price);
            } else {
                this.model.setPrice(price);
                this.priceSpn.getValueFactory().setValue((Object)price);
            }
        }
        if (this.model.getPrice() != 0.0) {
            this.priceSettle = true;
        }
    }

    @FXML
    private void buy() {
        this.order(true);
    }

    @FXML
    private void sell() {
        this.order(false);
    }

    private void order(boolean buy) {
        if (this.checkHedge.isSelected()) {
            this.model.setHedgeType("2");
        } else if (this.checkArbitrage.isSelected()) {
            this.model.setHedgeType("4");
        } else {
            this.model.setHedgeType("1");
        }
        this.model.setEnableSplit(this.checkSplit.isSelected());
        if (this.model.isEnableSplit()) {
            if (this.spnSplitCount.getEditor().getText().isEmpty()) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u62c6\u5355\u6570\u91cf");
                return;
            }
            this.model.setSplitCount(Integer.valueOf(this.spnSplitCount.getEditor().getText()));
        }
        if (this.valid() && this.orderConfirm(buy)) {
            this.submitOrder();
        }
    }

    private void submitOrder() {
        try {
            ObservableList<Boolean> listCont = this.doAction();
            if (listCont.filtered(each -> each == false).size() > 0) {
                this.alert.check(!this.setTips.getOrderTips(), Alert.AlertType.ERROR, String.valueOf(this.confirmSymbol) + "\u63d0\u4ea4\u6210\u529f" + listCont.filtered(each -> each).size() + "\u7b14" + " " + "\u5931\u8d25" + listCont.filtered(each -> each == false).size() + "\u7b14");
            }
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
        this.clearCountCheck();
    }

    private ObservableList<Boolean> doAction() throws Exception, MException {
        return this.model.submit();
    }

    private void clearCountCheck() {
        block7: {
            if (!this.preModel.isClearAfterOrder()) break block7;
            switch (this.model.getCountStg().getRaw()) {
                case "1": {
                    this.model.setCount(0L);
                }
            }
        }
    }

    private boolean valid() {
        if (this.checkHedge.isSelected() && this.checkArbitrage.isSelected()) {
            this.alert.alert(Alert.AlertType.WARNING, "\u4e0d\u53ef\u540c\u65f6\u52fe\u9009\u4fdd\u503c\u548c\u5957\u5229, \u53ef\u4ee5\u90fd\u4e0d\u52fe\u9009\u6216\u5355\u9009");
            return false;
        }
        if (StringUtils.isEmpty((String)this.txtCode.getText())) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u4ee3\u7801");
            return false;
        }
        if (this.model.getPrice() <= 0.0) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u4ef7\u683c");
            return false;
        }
        if (this.model.getCount() <= 0L) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u6570\u91cf");
            return false;
        }
        if (this.txtCode.getText().startsWith("TS")) {
            if (this.model.getCount() > 1000L) {
                this.alert.alert(Alert.AlertType.WARNING, "TS\u4e0a\u9650\u6570\u91cf\u4e3a1000, \u8bf7\u91cd\u65b0\u8f93\u5165");
                return false;
            }
        } else if (this.model.getCount() > 500L) {
            this.alert.alert(Alert.AlertType.WARNING, "T/TF\u4e0a\u9650\u6570\u91cf\u4e3a500, \u8bf7\u91cd\u65b0\u8f93\u5165");
            return false;
        }
        if (this.checkSplit.isSelected()) {
            if (this.spnSplitCount.getEditor().getText().isEmpty()) {
                this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u8f93\u5165\u62c6\u5355\u6570\u91cf");
                return false;
            }
            int count = Integer.valueOf(this.spnSplitCount.getEditor().getText());
            if (count > 39) {
                this.alert.alert(Alert.AlertType.WARNING, "\u62c6\u5355\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e39");
                return false;
            }
            if (count < 1) {
                this.alert.alert(Alert.AlertType.WARNING, "\u62c6\u5355\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e1");
                return false;
            }
        }
        if (StringUtils.isEmpty((String)((String)this.cmbAcct.getSelectionModel().getSelectedItem()))) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8bf7\u9009\u62e9\u8d26\u53f7");
            return false;
        }
        if (!this.model.accMng.getFundAccList().contains(this.cmbAcct.getValue())) {
            this.alert.alert(Alert.AlertType.WARNING, "\u8d26\u53f7\u9519\u8bef");
            return false;
        }
        return true;
    }

    private boolean orderConfirm(boolean buy) {
        block5: {
            try {
                List<FutureSingleEntrust> orderList = this.model.getMarketPreOrderList(buy, this.orderType, (String)this.cmbAcct.getValue());
                if (this.preModel.isPopBeforeOrder()) {
                    FuturesEntrustConfirmDialog obj = (FuturesEntrustConfirmDialog)((Object)this.of.create(FuturesEntrustConfirmDialog.class));
                    obj.setPriceTypeLimitedStg(this.model.getPriceTypeLimitedStg());
                    obj.setExecution(true);
                    obj.setInstructionType("0");
                    obj.setRefItem(this.mktItem.getRefItem());
                    obj.setPriceStg(this.model.getPriceStg());
                    obj.setPriceTypeBidAskStg(this.model.getPriceTypeBidAskStg());
                    obj.setList(orderList);
                    obj.setBuySymbol(this.buySymbol);
                    obj.setSellSymbol(this.sellSymbol);
                    MxDialog dialog = this.df.create((DialogObj)obj, StringUtils.isEmpty((String)this.confirmSymbol) ? "\u4e0b\u5355\u786e\u8ba4" : String.valueOf(this.confirmSymbol) + "\u786e\u8ba4");
                    if (dialog.launch() == ButtonType.OK) {
                        return true;
                    }
                    break block5;
                }
                return true;
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
            catch (MException e) {
                logger.error(e.getMessage(), (Throwable)e);
                this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
            }
        }
        return false;
    }

    private void priceFocus() {
        this.priceSpn.requestFocus();
        this.preModel.selectTwoOrAllPriceDecimal();
    }

    private void codeKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (this.model.isLimitPrice()) {
                this.priceFocus();
            } else {
                this.countSpn.requestFocus();
                this.countSpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void priceKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            if (((MxNode)this.countStg.getValue()).getRaw().equals("1")) {
                this.countSpn.requestFocus();
                this.countSpn.getEditor().selectAll();
            }
            key.consume();
        }
    }

    private void quantityKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode() || KeyCode.ENTER == key.getCode()) {
            this.btnBuy.requestFocus();
            key.consume();
        }
    }

    private void orderBuyKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.btnSell.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order(true);
            this.priceFocus();
            key.consume();
        }
    }

    private void orderSellKeyPress(KeyEvent key) {
        if (KeyCode.TAB == key.getCode()) {
            this.txtCode.requestFocus();
            key.consume();
        } else if (KeyCode.ENTER == key.getCode()) {
            this.order(false);
            this.priceFocus();
            key.consume();
        }
    }

    private void onRefChange() {
        TradeBindings.ctpPriceBinding((Property)this.lbNowPrice.textProperty(), (ObservableNumberValue)this.mktItem.nowPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbUpLimit.textProperty(), (ObservableNumberValue)this.mktItem.upLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        TradeBindings.ctpPriceBinding((Property)this.lbDownLimit.textProperty(), (ObservableNumberValue)this.mktItem.downLimitPriceProperty(), (ObservableNumberValue)this.mktItem.getRefItem().scaleProperty());
        if (this.mktItem.getRefItem() != null && !this.mktItem.getRefItem().getName().equals("")) {
            this.checkPriceType();
        }
        this.ctrlPrice.getVF().setUnit(this.mktItem.getRefItem().getPriceUnit());
        this.ctrlPrice.setScale(this.mktItem.getRefItem().getScale());
    }

    private void createMarketTable() {
        this.lbNowPrice.setOnMouseClicked(event -> this.setPrice(this.mktItem.getNowPrice()));
        this.lbUpLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getUpLimitPrice()));
        this.lbDownLimit.setOnMouseClicked(event -> this.setPrice(this.mktItem.getDownLimitPrice()));
        MxBindings.bindVisible((Control)this.lbNowPrice, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbRate, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbUpLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        MxBindings.bindVisible((Control)this.lbDownLimit, (ObservableBooleanValue)this.mktItem.clearProperty().not());
        CssUtils.makeRise((Control)this.lbUpLimit);
        CssUtils.makeFall((Control)this.lbDownLimit);
        MxBindings.percentBinding((Property)this.lbRate.textProperty(), (ObservableNumberValue)this.mktItem.pctProperty(), (int)2);
        this.mktItem.pctProperty().addListener(obs -> {
            CssUtils.checkPrice((Control)this.lbNowPrice, (double)this.mktItem.getPreSettlementPrice(), (double)this.mktItem.getNowPrice());
            CssUtils.checkPct((Control)this.lbRate, (double)this.mktItem.pctProperty().getValue());
        });
        this.colBuyIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u4e70").append(StringUtils.numToChinese((int)(this.tableBuy.getItems().indexOf(p.getValue()) + 1))))));
        this.colSellIndex.setCellValueFactory(p -> new ReadOnlyStringWrapper(String.valueOf(new StringBuilder("\u5356").append(StringUtils.numToChinese((int)(this.tableSell.getItems().size() - this.tableSell.getItems().indexOf(p.getValue())))))));
        this.colSellPrice.setCellFactory(data -> new FuturePriceCell(this.mktItem));
        this.colSellCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colSellCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colSellPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colBuyPrice.setCellFactory(data -> new FuturePriceCell(this.mktItem));
        this.colBuyCount.setCellFactory(data -> new HandicapCountCell(this.mktItem));
        this.colBuyCount.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).countProperty());
        this.colBuyPrice.setCellValueFactory(data -> ((HandicapInfo)data.getValue()).priceStrProperty());
        this.colSellOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colBuyOrder.setCellFactory(cell -> new HandicapOrderCell(this.mktItem));
        this.colSellOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.colBuyOrder.setCellValueFactory(cell -> ((HandicapInfo)cell.getValue()).orderProperty());
        this.tableBuy.setItems(this.mktItem.getListBuyHandicap());
        this.tableSell.setItems((ObservableList)this.mktItem.getListSellHandicap().sorted((h1, h2) -> h1.getIndex() > h2.getIndex() ? -1 : 1));
        this.tableBuy.setPlaceholder((Node)new Label());
        this.tableSell.setPlaceholder((Node)new Label());
        this.tableBuy.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
        this.tableSell.getSelectionModel().selectedItemProperty().addListener((ob, old, now) -> this.onItemSelected((HandicapInfo)now));
    }

    private void onItemSelected(HandicapInfo now) {
        if (now != null) {
            this.setPrice(now.getPrice());
            Platform.runLater(() -> this.clearSelection());
        }
    }

    private void clearSelection() {
        this.tableBuy.getSelectionModel().clearSelection();
        this.tableSell.getSelectionModel().clearSelection();
    }

    private void pricelLoseFocus(Boolean flag) {
        if (!flag.booleanValue()) {
            this.priceSpn.getValueFactory().setValue((Object)this.model.getPrice());
        }
    }

    private void loseFocus(Boolean flag) {
        if (!flag.booleanValue() && this.txtCode.getText().length() > 0) {
            this.check();
        } else if (flag.booleanValue()) {
            Platform.runLater(() -> this.txtCode.selectAll());
        }
    }

    private void check() {
        RefItem ref = this.mktItem.getRefItem();
        if (ref == null || ref.getName().equals("") || this.mktItem.getStop().getValue().booleanValue()) {
            this.lbName.setText("\u65e0\u6548\u4ee3\u7801");
        }
    }

    public void setPrice(double price) {
        if (this.model.isLimitPrice() && price > 0.0) {
            this.priceSpn.getValueFactory().setValue((Object)price);
            this.model.setPrice(price);
        } else {
            if (this.model.isBidAskPrice()) {
                return;
            }
            this.priceSpn.getEditor().setText("");
        }
    }

    private void checkPriceType() {
        this.priceSpn.getEditor().clear();
        if (((MxNode)this.cmbPriceType.getValue()).is("50")) {
            this.cmbPriceTypeLimited.setVisible(true);
            this.cmbPriceTypeBidAsk.setVisible(false);
        } else {
            this.cmbPriceTypeBidAsk.setVisible(true);
            this.cmbPriceTypeLimited.setVisible(false);
        }
    }

    private void onPriceTypeLimitedChange(MxNode newV) {
        if (newV == null) {
            return;
        }
        if (newV.getNode("3") == null) {
            return;
        }
        if (newV.is("3")) {
            this.priceSpn.getEditor().clear();
        }
    }

    private void priceVisibleBind() {
        this.priceSpn.getEditor().visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> {
            if (!((MxNode)this.cmbPriceType.getValue()).is("50") && !((MxNode)this.cmbPriceType.getValue()).is("0")) {
                return false;
            }
            return true;
        }, (Observable[])new Observable[]{this.cmbPriceType.valueProperty()}));
    }

    private void priceDisableBind() {
        this.priceSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.model.isBidAskPrice(), (Observable[])new Observable[]{this.model.priceStgProperty(), this.model.priceTypeLimitedStgProperty()}));
    }

    private void countDisableBind() {
        this.countSpn.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> !this.model.getCountStg().is("1"), (Observable[])new Observable[]{this.model.countStgProperty()}));
    }

    private void createMarketTab() {
        this.code.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getRefItem().codeProperty());
        this.lastPrice.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().nowPriceProperty());
        this.lastPrice.setCellFactory(cell -> new NowPriceCell());
        this.priceBuy.setCellValueFactory(data -> ((HandicapInfo)((FutureMarket)data.getValue()).getMarketItem().getListBuyHandicap().get(0)).priceStrProperty());
        this.priceBuy.setCellFactory(cell -> new PriceCell());
        this.priceSell.setCellValueFactory(data -> ((HandicapInfo)((FutureMarket)data.getValue()).getMarketItem().getListSellHandicap().get(0)).priceStrProperty());
        this.priceSell.setCellFactory(cell -> new PriceCell());
        this.qtyBuy.setCellValueFactory(data -> ((HandicapInfo)((FutureMarket)data.getValue()).getMarketItem().getListBuyHandicap().get(0)).countProperty());
        this.qtyBuy.setCellFactory(cell -> new QtyCell());
        this.qtySell.setCellValueFactory(data -> ((HandicapInfo)((FutureMarket)data.getValue()).getMarketItem().getListSellHandicap().get(0)).countProperty());
        this.qtySell.setCellFactory(cell -> new QtyCell());
        this.totalDealQty.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().totalDealQtyProperty());
        this.totalPositionQty.setCellValueFactory(data -> ((FutureMarket)data.getValue()).getMarketItem().totalPositionQtyProperty());
        this.mlist.update(this.marketListModel.getList());
        this.tableMarketList.setPlaceholder((Node)new Label());
        this.tableMarketList.setItems(this.mlist.getList());
        this.tableMarketList.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            this.market = (FutureMarket)this.tableMarketList.getSelectionModel().getSelectedItem();
            Platform.runLater(() -> {
                if (this.market != null) {
                    this.txtCode.requestFocus();
                    if (this.txtCode.isFocused()) {
                        this.txtCode.setText(this.market.getRefItem().getCode());
                    }
                }
            });
        });
    }

    public void initUserPre() {
        this.preModel.setPart(this);
        this.preModel.setType("5", "200005002");
        this.model.setCloseToday("1".equals(this.preModel.getClose()));
        try {
            this.preModel.doSet();
        }
        catch (MException mException) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, "\u67e5\u8be2\u7528\u6237\u8bbe\u7f6e\u5931\u8d25"));
        }
    }

    private void setOrderType(String type) {
        this.orderType = type;
    }

    public MarketItem getMarketItem() {
        return this.mktItem;
    }

    public RefItem getValidRef() {
        return this.model.getValidRef();
    }

    public String getConfirmSymbol() {
        return this.confirmSymbol;
    }

    public void setConfirmSymbol(String confirmSymbol) {
        this.confirmSymbol = confirmSymbol;
    }

    public void setCount(Long buyQuantity) {
        this.model.setCount(buyQuantity);
    }

    public Label getLbCountOne() {
        return this.lbCountOne;
    }

    public Label getLbCountTwo() {
        return this.lbCountTwo;
    }

    public Label getLbCountThree() {
        return this.lbCountThree;
    }

    public Label getLbCountFour() {
        return this.lbCountFour;
    }

    public Spinner<Double> getPriceSpn() {
        return this.priceSpn;
    }

    public class MainContractCell
    extends TableCell<FutureMarket, Number> {
        public void updateItem(Number item, boolean empty) {
            if (!empty) {
                if (item.longValue() == 1L) {
                    this.setText("\u662f");
                } else {
                    this.setText("\u5426");
                }
                return;
            }
            this.setText(null);
        }
    }

    public class NowPriceCell
    extends TableCell<FutureMarket, Number> {
        private int scale = 0;

        public void updateItem(Number value, boolean empty) {
            if (empty || value.doubleValue() == 0.0) {
                this.setText(null);
                return;
            }
            FutureMarket item = (FutureMarket)FutureMarket.class.cast(this.getTableRow().getItem());
            if (item == null) {
                this.setText(null);
                return;
            }
            this.scale = item.getMarketItem().getRefItem() != null ? item.getMarketItem().getRefItem().getScale() : 2;
            String text = StringUtils.toPriceStr((double)value.doubleValue(), (int)this.scale);
            this.setText(text);
        }
    }

    public class PriceCell
    extends TableCell<FutureMarket, String> {
        public void updateItem(String item, boolean empty) {
            double price;
            if (!empty && !item.isEmpty() && (price = Double.parseDouble(item)) > 0.0) {
                this.setText(item);
                return;
            }
            this.setText(null);
        }
    }

    public class PriceSellCell
    extends TableCell<FutureMarket, String> {
        private Label label = new Label();

        private PriceSellCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(String item, boolean empty) {
            if (!empty && !StringUtils.isEmpty((String)item)) {
                this.label.setText(item);
                CssUtils.makeFall((Control)this.label);
                this.label.addEventHandler(MouseEvent.MOUSE_CLICKED, event -> {
                    FuturesTradeMarketPart.this.selectPrice = Double.parseDouble(item);
                    FuturesTradeMarketPart.this.selectFlag = true;
                });
            }
            this.setGraphic((Node)this.label);
        }
    }

    public class QtyCell
    extends TableCell<FutureMarket, Number> {
        private static final int INVALID_COUNT = -1;

        public void updateItem(Number item, boolean empty) {
            if (!empty && item.longValue() != -1L) {
                this.setText(String.valueOf(item));
            }
            this.setText(null);
        }
    }

    public class QtySellCell
    extends TableCell<FutureMarket, Number> {
        private static final int INVALID_COUNT = -1;
        private Label label = new Label();

        private QtySellCell() {
            this.label.getStyleClass().add((Object)"priceTag");
        }

        public void updateItem(Number item, boolean empty) {
            if (!empty && item.longValue() != -1L) {
                this.label.setText(String.valueOf(item));
                CssUtils.makeFall((Control)this.label);
            }
            this.setGraphic((Node)this.label);
        }
    }
}

