/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.models;

import cms.tmx.control.spinner.SpinnerUtils;
import cms.tmx.control.utils.TextFieldUtils;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.web.settings.BaseSettings;
import cms.tmx.entity.web.settings.CtpTradeSettings;
import cms.tmx.futures.views.PreciousMetalsTradeBasePart;
import cms.tmx.trade.utils.TradeBindings;
import cms.tmx.web.service.IUserSettingsService;
import java.math.BigDecimal;
import javafx.application.Platform;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class UserPreCtrlPreMetals {
    @Inject
    protected MEventService es;
    @Inject
    private IUserSettingsService usMng;
    private String funcPanelType;
    private String menuId;
    private PreciousMetalsTradeBasePart part;
    private static final int DEF_NUM = 4;
    private static int scale = 3;
    private boolean clearAfterOrder = true;
    private boolean popBeforeOrder = true;
    private boolean popBeforeCancel = true;
    private boolean unfinishedAfterOrder = false;
    private int priceChoose;
    private String priceGear = "-1";
    private double priceFloat = 0.0;
    private String priceUnit = "1";
    private DoubleProperty upDownPriceFloat = new SimpleDoubleProperty(0.0);
    private DoubleProperty leftRightPriceFloat = new SimpleDoubleProperty(0.0);
    private long defQuantity;
    private IntegerProperty[] commonQuantity = new SimpleIntegerProperty[4];
    private String keyStyle = "";
    private String close;
    private static final Logger logger = LogManager.getLogger(UserPreCtrlPreMetals.class);

    @PostConstruct
    public void init() {
        this.es.subscribe("settingsRefresh", event -> this.reload());
        this.initSet();
    }

    @PreDestroy
    private void close() {
        this.es.unSubscribe("settingsRefresh", event -> this.reload());
    }

    private void reload() {
        if (this.funcPanelType == null || this.menuId == null) {
            this.initControls();
            return;
        }
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CtpTradeSettings) {
                this.getUserSetting((CtpTradeSettings)CtpTradeSettings.class.cast(settings));
                this.initControls();
            }
        }
        catch (MException e) {
            logger.error("\u52a0\u8f7d\u7528\u6237\u8bbe\u7f6e\u6570\u636e\u5931\u8d25", (Throwable)e);
        }
    }

    public void doSet() throws MException {
        if (this.funcPanelType == null || this.menuId == null) {
            this.initControls();
            return;
        }
        try {
            BaseSettings settings = this.usMng.getSettingsDetail(this.funcPanelType, this.menuId);
            if (settings instanceof CtpTradeSettings) {
                this.getUserSetting((CtpTradeSettings)CtpTradeSettings.class.cast(settings));
            }
        }
        finally {
            this.initControls();
        }
    }

    public void initControls() {
        this.setPriceSpinner();
        if (this.part == null) {
            return;
        }
        SpinnerUtils.addDoubleArrowKeyHandler(this.part.getPriceSpn(), (ObservableNumberValue)this.upDownPriceFloatProperty(), (ObservableNumberValue)this.leftRightPriceFloatProperty());
        Platform.runLater(() -> {
            TradeBindings.bindBigNumToInt((StringProperty)this.part.getLbCountOne().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[0]);
            TradeBindings.bindBigNumToInt((StringProperty)this.part.getLbCountTwo().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[1]);
            TradeBindings.bindBigNumToInt((StringProperty)this.part.getLbCountThree().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[2]);
            TradeBindings.bindBigNumToInt((StringProperty)this.part.getLbCountFour().textProperty(), (ObservableNumberValue)this.getCommonQuantity()[3]);
            this.part.getLbCountOne().setOnMouseClicked(event -> this.part.setCount(this.getCommonQuantity()[0].longValue()));
            this.part.getLbCountTwo().setOnMouseClicked(event -> this.part.setCount(this.getCommonQuantity()[1].longValue()));
            this.part.getLbCountThree().setOnMouseClicked(event -> this.part.setCount(this.getCommonQuantity()[2].longValue()));
            this.part.getLbCountFour().setOnMouseClicked(event -> this.part.setCount(this.getCommonQuantity()[3].longValue()));
            Font font = new Font("Arial", 14.0);
            Tooltip countTip1 = new Tooltip(Integer.toString(this.getCommonQuantity()[0].getValue()));
            countTip1.setFont(font);
            this.part.getLbCountOne().setTooltip(countTip1);
            Tooltip countTip2 = new Tooltip(Integer.toString(this.getCommonQuantity()[1].getValue()));
            countTip2.setFont(font);
            this.part.getLbCountTwo().setTooltip(countTip2);
            Tooltip countTip3 = new Tooltip(Integer.toString(this.getCommonQuantity()[2].getValue()));
            countTip3.setFont(font);
            this.part.getLbCountThree().setTooltip(countTip3);
            Tooltip countTip4 = new Tooltip(Integer.toString(this.getCommonQuantity()[3].getValue()));
            countTip4.setFont(font);
            this.part.getLbCountFour().setTooltip(countTip4);
        });
        if (this.part.isApprove()) {
            this.part.getPane1sty().setVisible(true);
            this.part.getPane2sty().setVisible(false);
            this.part.getPane4sty().setVisible(false);
        } else {
            if ("1".equals(this.getKeyStyle())) {
                this.part.getPane2sty().setVisible(true);
                this.part.getPane4sty().setVisible(false);
            } else {
                this.part.getPane2sty().setVisible(false);
                this.part.getPane4sty().setVisible(true);
            }
            this.part.getPane1sty().setVisible(false);
        }
    }

    public void selectTwoOrAllPriceDecimal() {
        TextFieldUtils.selectTwoOrNoPriceDecimal((int)this.getPriceChoose(), (TextField)this.part.getPriceSpn().getEditor());
    }

    public void onSecurityChange() {
        this.setUserPreCount();
        this.setPriceSpinner();
    }

    private void setPriceSpinner() {
        if (this.part == null) {
            return;
        }
        RefItem refItem = this.part.getValidRef();
        if (refItem != null && this.getUpDownPriceFloat() < refItem.getPriceUnit()) {
            this.setUpDownPriceFloat(refItem.getPriceUnit());
        }
        if (refItem != null && this.getLeftRightPriceFloat() < refItem.getPriceUnit()) {
            this.setLeftRightPriceFloat(refItem.getPriceUnit());
        }
    }

    private void setUserPreCount() {
        if (this.part.getValidRef() == null) {
            this.part.setCount(0L);
            return;
        }
        this.part.setCount(this.getDefQuantity());
    }

    public double getDefPrice() {
        double value = 0.0;
        int gear = 0;
        double adjust = 0.0;
        gear = this.getPriceGear() == null ? -1 : Integer.parseInt(this.getPriceGear());
        double price = this.getPrice(gear);
        if (price <= 0.0) {
            return value;
        }
        adjust = this.getPriceFloat() == null ? 0.0 : this.getPriceFloat();
        double priceTick = ((CtpRefItem)this.part.getValidRef()).getPriceTick();
        if (this.getPriceUnit().equals("2")) {
            adjust = price * (adjust / 100.0);
        }
        BigDecimal b1 = new BigDecimal(Double.toString(adjust));
        BigDecimal b2 = new BigDecimal(Double.toString(priceTick));
        BigDecimal b4 = new BigDecimal(Double.toString(priceTick / 2.0));
        BigDecimal b3 = new BigDecimal(0);
        if (priceTick != 0.0) {
            b3 = b1.divideAndRemainder(b2)[1];
        }
        adjust = b3.doubleValue() - b4.doubleValue() > 0.0 ? adjust - b3.doubleValue() + priceTick : adjust - b3.doubleValue();
        value = price + adjust;
        return Double.valueOf(String.format("%1$." + this.part.getValidRef().getScale() + "f", value));
    }

    public double getPrice(int gear) {
        switch (gear) {
            case 0: {
                return this.part.getMarketItem().getNowPrice();
            }
            case 100: {
                return this.part.getMarketItem().getUpLimitPrice();
            }
            case -100: {
                return this.part.getMarketItem().getDownLimitPrice();
            }
        }
        if (this.part != null) {
            return this.getFitablePrice(gear);
        }
        return 0.0;
    }

    private double getFitablePrice(int raw) {
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.part.getMarketItem().getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 10) {
                price = this.part.getMarketItem().getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.part.getMarketItem().getNowPrice() == 0.0 ? this.part.getMarketItem().getClosePrice() : this.part.getMarketItem().getNowPrice();
        }
        return price;
    }

    private void initSet() {
        this.setClearAfterOrder(true);
        this.setPopBeforeOrder(true);
        this.setPopBeforeCancel(true);
        this.setPriceChoose(1);
        this.setUpDownPriceFloat(2.0);
        this.setLeftRightPriceFloat(1.0);
        this.setPriceGear(Integer.toString(1));
        this.setPriceFloat(0.0);
        this.setPriceUnit("2");
        this.setDefQuantity(0L);
        this.setKeyStyle("2");
        this.setClose("2");
        int i = 0;
        while (i < 4) {
            this.commonQuantity[i] = new SimpleIntegerProperty();
            ++i;
        }
        this.commonQuantity[0].set(10);
        this.commonQuantity[1].set(5);
        this.commonQuantity[2].set(2);
        this.commonQuantity[3].set(1);
    }

    private void getUserSetting(CtpTradeSettings settings) {
        this.setClearAfterOrder(settings.getClearAfterOrder().equals("1"));
        this.setPopBeforeOrder(settings.getPopBeforeOrder().equals("1"));
        this.setPopBeforeCancel(settings.getPopBeforeCancel().equals("1"));
        this.setUnfinishedAfterOrder(settings.getUnfinishedAfterOrder().equals("1"));
        this.setPriceChoose(settings.getPriceChoose());
        this.setPriceGear(settings.getPriceGear());
        this.setPriceFloat(settings.getPriceFloat());
        this.setPriceUnit(settings.getPriceUnit());
        this.setDefQuantity(settings.getQuantity());
        this.setKeyStyle(settings.getKeyStyle());
        this.setClose(settings.getClosePositionPriority());
        Platform.runLater(() -> {
            int i = 0;
            while (i < 4) {
                this.commonQuantity[i].set(((Integer)settings.getCommonQuantity().get(i)).intValue());
                ++i;
            }
        });
    }

    public void setType(String funcPanelType, String menuId) {
        this.funcPanelType = funcPanelType;
        this.menuId = menuId;
    }

    public void setPart(PreciousMetalsTradeBasePart part) {
        this.part = part;
    }

    public final DoubleProperty upDownPriceFloatProperty() {
        return this.upDownPriceFloat;
    }

    public final double getUpDownPriceFloat() {
        return this.upDownPriceFloatProperty().get();
    }

    public final void setUpDownPriceFloat(double upDownPriceFloat) {
        this.upDownPriceFloatProperty().set(upDownPriceFloat);
    }

    public final DoubleProperty leftRightPriceFloatProperty() {
        return this.leftRightPriceFloat;
    }

    public final double getLeftRightPriceFloat() {
        return this.leftRightPriceFloatProperty().get();
    }

    public final void setLeftRightPriceFloat(double leftRightPriceFloat) {
        this.leftRightPriceFloatProperty().set(leftRightPriceFloat);
    }

    public boolean isPopBeforeOrder() {
        return this.popBeforeOrder;
    }

    public void setPopBeforeOrder(boolean popBeforeOrder) {
        this.popBeforeOrder = popBeforeOrder;
    }

    public boolean isPopBeforeCancel() {
        return this.popBeforeCancel;
    }

    public void setPopBeforeCancel(boolean popBeforeCancel) {
        this.popBeforeCancel = popBeforeCancel;
    }

    public String getPriceGear() {
        return this.priceGear;
    }

    public void setPriceGear(String priceGear) {
        this.priceGear = priceGear;
    }

    public Double getPriceFloat() {
        return this.priceFloat;
    }

    public void setPriceFloat(Double priceFloat) {
        this.priceFloat = priceFloat;
    }

    public String getPriceUnit() {
        return this.priceUnit;
    }

    public void setPriceUnit(String priceUnit) {
        this.priceUnit = priceUnit;
    }

    public Long getDefQuantity() {
        return this.defQuantity;
    }

    public void setDefQuantity(Long defQuantity) {
        this.defQuantity = defQuantity;
    }

    public IntegerProperty[] getCommonQuantity() {
        return this.commonQuantity;
    }

    public void setCommonQuantity(IntegerProperty[] commonQuantity) {
        this.commonQuantity = commonQuantity;
    }

    public String getFuncPanelType() {
        return this.funcPanelType;
    }

    public void setFuncPanelType(String funcPanelType) {
        this.funcPanelType = funcPanelType;
    }

    public int getPriceChoose() {
        return this.priceChoose;
    }

    public void setPriceChoose(int priceChoose) {
        this.priceChoose = priceChoose;
    }

    public String getKeyStyle() {
        return this.keyStyle;
    }

    public void setKeyStyle(String keyStyle) {
        this.keyStyle = keyStyle;
    }

    public boolean isClearAfterOrder() {
        return this.clearAfterOrder;
    }

    public void setClearAfterOrder(boolean clearAfterOrder) {
        this.clearAfterOrder = clearAfterOrder;
    }

    public String getClose() {
        return this.close;
    }

    public void setClose(String close) {
        this.close = close;
    }

    public boolean isUnfinishedAfterOrder() {
        return this.unfinishedAfterOrder;
    }

    public void setUnfinishedAfterOrder(boolean unfinishedAfterOrder) {
        this.unfinishedAfterOrder = unfinishedAfterOrder;
    }
}

