/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.data.websocket.MarketDataModel;
import cms.tmx.define.MxDict;
import cms.tmx.entity.AccntStepAttribute;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.AccntSecInfo;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.InstructionSubmitResult;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.entity.trade.instruction.Resource;
import cms.tmx.futures.entrust.EntrustFactory;
import cms.tmx.futures.instructions.models.PreciousMetalsAccountDistributionModel;
import cms.tmx.futures.instructions.models.UserPreCtrlPreMetals;
import cms.tmx.futures.models.CtpAccountDistribution;
import cms.tmx.futures.models.CtpEntrustSplitModel;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Instrument;
import cms.tmx.http.api.strategy.api.TradeServiceApi;
import cms.tmx.http.api.strategy.dto.NewOrderSingle;
import cms.tmx.http.api.strategy.dto.OrdType;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.http.query.TimeInForce;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.query.current.models.ResourceModel;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.trade.message.MessagePromptMng;
import cms.tmx.utils.MarketUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PreciousMetalsBaseModel {
    private StringProperty security = new SimpleStringProperty("");
    private ObjectProperty<MarketItem> item = new SimpleObjectProperty();
    private StringProperty name = new SimpleStringProperty("");
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> ocFlag = new SimpleObjectProperty();
    private ObjectProperty<Instruction> instruction = new SimpleObjectProperty((Object)new Instruction());
    private ObjectProperty<MxNode> priceTypeLimitedStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeBidAskStg = new SimpleObjectProperty();
    private MarketItem mktItem;
    @Inject
    private PreciousMetalsAccountDistributionModel accModel;
    @Inject
    private MarketDataModel mktMng;
    @Inject
    private EntrustFactory ef;
    private UserPreCtrlPreMetals preModel;
    private boolean closeToday;
    @Inject
    protected CtpEntrustSplitModel entrustSplit;
    @Inject
    private ResourceModel resModel;
    @Inject
    private MessagePromptMng messageMng;
    @Inject
    protected IAccountService accountService;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    private InstructionModel instructionModel;
    @Inject
    private MObjFactory of;
    private List<FutureSingleEntrust> orderList;
    @Inject
    private HttpBaseApi baseApi;
    @Inject
    private TradeServiceApi api;

    @PostConstruct
    public void init() {
        this.mktItem = this.mktMng.createItem(5);
        this.accModel.securityProperty().bind((ObservableValue)this.security);
        this.accModel.priceProperty().bind((ObservableValue)this.price);
        MxNode node = MxNodeFactory.createNew((String)"cstr_price_type", (String)"50");
        this.initPriceType(node);
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node.clear();
        node = MxNodeFactory.createNew((String)"cstr_price_type_limited", (String)"2");
        this.initPriceTypeLimit(node);
        this.setPriceTypeLimitedStg(node);
        node.clear();
        node = MxNodeFactory.createNew((String)"sge_market_str", (String)"48");
        this.initPriceTypeGear(node);
        this.setPriceTypeBidAskStg(node);
        this.priceTypeBidAskStg.addListener(ob -> this.onPriceStgChange());
        node.clear();
        node = MxNodeFactory.createNew((String)"position_effect", (String)"70");
        this.ocFlag(node);
        this.setOcFlag(node);
        node = MxNodeFactory.createNew((String)"futures_count_stg", (String)"1");
        this.setCountStg(node);
        node = MxNodeFactory.createNew((String)"acc_dist_mode", (String)"1");
        this.distStg.addListener(ob -> this.onDistStgChange());
        this.distStg(node);
        this.setDistStg(node);
        this.accModel.permissionProperty().addListener((ob, old, newV) -> this.onPermissionChange((boolean)newV));
        this.getAccDis().countProperty().bind((ObservableValue)this.countProperty());
    }

    public void onSecChange() {
        this.mktItem.setRefItem((RefItem)this.getValidRef());
        this.getAccDis().setRefItem(this.getValidRef());
        this.mktMng.dye(this.mktItem);
        this.setName(this.isValidRef() ? this.getValidRef().getName() : "");
        this.accModel.filterAcc();
    }

    public void create(String instructType) {
        this.getAccDis().setInstructPanelType(instructType);
        try {
            this.getAccDis().create();
        }
        catch (MException e) {
            e.printStackTrace();
        }
    }

    public void setPstAcct(String secAcc, String mkt) {
        this.getAccDis().clearSelect();
        this.getAccDis().selectSecAcc(secAcc, mkt);
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    public StringProperty securityProperty() {
        return this.security;
    }

    public String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public ObjectProperty<MarketItem> itemProperty() {
        return this.item;
    }

    public MarketItem getItem() {
        return (MarketItem)this.itemProperty().get();
    }

    public void setItem(MarketItem item) {
        this.itemProperty().set((Object)item);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public void execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, "");
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public PreciousMetalsAccountDistributionModel getAccDis() {
        return this.accModel;
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("49");
        node.addNode("50");
    }

    private void initPriceTypeLimit(MxNode node) {
        this.removeOthers(node, "2");
    }

    private void initPriceTypeGear(MxNode node) {
        this.removeOthers(node, "48");
        node.addNode("51");
        node.addNode("52");
    }

    public boolean isBidAskPrice() {
        return this.getPriceStg().is("0");
    }

    private void onPriceStgChange() {
        this.setPrice(0.0);
    }

    public void setBidAskPrice() {
        if (!this.isBidAskPrice()) {
            return;
        }
        int raw = Integer.parseInt(this.getPriceTypeBidAskStg().getRaw());
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 5) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 5) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        this.setPrice(price);
    }

    public boolean isLimitPrice() {
        return this.getPriceStg().is(Integer.toString(50));
    }

    public boolean isUnlimited() {
        if (this.getPriceTypeLimitedStg() == null || !this.isLimitPrice()) {
            return false;
        }
        return this.getPriceTypeLimitedStg().is("3");
    }

    private void distStg(MxNode node) {
        node.removeNode("3");
    }

    private void ocFlag(MxNode node) {
        node.removeOthersAndAddThis("70");
        node.addNode("79");
        node.addNode("67");
    }

    public synchronized ObservableList<Boolean> submit() throws Exception {
        ObservableList returnList = FxUtils.newList();
        for (FutureSingleEntrust en : this.orderList) {
            try {
                if (this.instruction.get() != null) {
                    en.setInstructionId(((Instruction)this.instruction.get()).getId());
                    if (!((Instruction)this.instruction.get()).getId().isEmpty()) {
                        Resource resource = this.resModel.getResource((Instruction)this.instruction.get());
                        if (resource == null) {
                            returnList.add((Object)false);
                            continue;
                        }
                        en.setResourceId(resource.getId());
                        en.setOrdQuantityCapacity(((Instruction)this.instruction.get()).getOrderAdvice().getOrderQty());
                    }
                }
                this.orderSubmit(en);
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    private void orderSubmit(FutureSingleEntrust en) {
        NewOrderSingle order = new NewOrderSingle();
        order.setOpUser(this.baseApi.getHttpOpUser());
        Instrument security = new Instrument();
        if (this.mktItem.getRefItem() != null) {
            security.setSecurityId(this.mktItem.getRefItem().getCode());
            security.setSymbol(this.mktItem.getRefItem().getName());
            security.setMarket(this.mktItem.getRefItem().getMarket());
            security.setMarketGroup("SGE");
            security.setSecurityType(this.mktItem.getRefItem().getType());
            security.setMarketIndicator(this.mktItem.getRefItem().isDelayedDelivery() ? "Deferred" : "Spot");
        }
        order.setInstrument(security);
        order.setAccount(en.getAcc());
        order.setExtCashAccntId(en.getExtCashAccntId());
        order.setExtSecAccntId(en.getSecAcc());
        order.setOrdType(OrdType.get((String)this.getPriceStg().getRaw()));
        order.setSide(Side.get((String)String.valueOf(en.getSide())));
        order.setOrderQty((double)en.getQuantity().longValue());
        if ("49".equals(this.getPriceStg().getRaw())) {
            order.setTif(TimeInForce.getValue((int)Integer.valueOf(this.getPriceTypeBidAskStg().getRaw())));
            order.setPrice(this.mktItem.getNowPrice());
        } else {
            order.setPrice(this.getPrice());
        }
        if (this.mktItem.getRefItem().isDelayedDelivery()) {
            order.setPositionEffect(en.getOffsetFlag().getRaw());
        }
        order.setPurpose(1);
        try {
            this.api.newSgeOrderSingle(order, "sge");
        }
        catch (MException e) {
            e.printStackTrace();
        }
    }

    public synchronized ObservableList<Boolean> submitAdvice(String type) throws MException {
        ObservableList returnList = FxUtils.newList();
        for (OrderAdvice oa : this.getOrderAdvices(type)) {
            try {
                InstructionSubmitResult submitResult = oa.submit();
                this.messageMng.regularInst(oa, this.getAccDis().getInstructType(), (Object)submitResult.getInstructionId(), submitResult.getReason());
                returnList.add((Object)true);
            }
            catch (MException e) {
                this.messageMng.regularInst(oa, this.getAccDis().getInstructType(), (Object)e, "");
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public ObservableList<Boolean> submitApprove(Instruction instruction, String type) throws MException {
        ObservableList returnList = FxUtils.newList();
        Iterator<OrderAdvice> iterator = this.getOrderAdvices(type).iterator();
        while (iterator.hasNext()) {
            iterator.next();
            try {
                this.instructionModel.approve(instruction, MxDict.WORKFLOW_APPROVE, "");
                returnList.add((Object)true);
            }
            catch (MException mException) {
                returnList.add((Object)false);
            }
        }
        return returnList;
    }

    public List<FutureSingleEntrust> getPreOrderList(Instruction instruction, String type) throws Exception {
        LinkedList<FutureSingleEntrust> enList = new LinkedList<FutureSingleEntrust>();
        this.orderList = enList;
        for (CtpAccountDistribution accDis : this.accModel.getAccList().filtered(each -> each.isSelected() && each.getCount() > 0L)) {
            FutureSingleEntrust en;
            SecAccnt secAcc;
            block24: {
                secAcc = this.accModel.getSecAcc(accDis.getCtpAcc(), "SGEX");
                if (secAcc == null) {
                    throw new Exception("\u65e0\u8bc1\u5238\u8d26\u53f7");
                }
                en = this.ef.createSingle(accDis.getCtpAcc().getExtAccntId(), secAcc.getSecAccntId());
                en.setQuantity(accDis.getCount());
                en.setCanCloseLong(accDis.getCanCloseLong());
                en.setCanCloseShort(accDis.getCanCloseShort());
                en.setCanOpenLong(accDis.getLongCount());
                en.setCanOpenShort(accDis.getShortCount());
                en.setCanCloseYdLong(accDis.getCanCloseYdLong());
                en.setCanCloseTdLong(accDis.getCanCloseTdLong());
                en.setCanCloseYdShort(accDis.getCanCloseYdShort());
                en.setCanCloseTdShort(accDis.getCanCloseTdShort());
                en.setMarket("SGEX");
                en.setMarketGrp(MarketUtils.getMarketGroup((String)en.getMarket()));
                en.setSecType("FUT");
                if ("50".equals(this.getPriceStg().getRaw())) {
                    en.setOrderType(50);
                    en.setPrice(this.getPrice());
                } else if ("49".equals(this.getPriceStg().getRaw())) {
                    en.setOrderType(49);
                    en.setPrice(this.mktItem.getNowPrice());
                } else {
                    en.setPrice(this.getPrice());
                }
                if ("0".equals(this.getAccDis().getInstructType()) || "4".equals(this.getAccDis().getInstructType()) || !"3".equals(this.getPriceTypeLimitedStg().getRaw()) || !this.isValidRef()) break block24;
                switch (type) {
                    case "order_open_buy": 
                    case "order_close_buy": 
                    case "order_buy": {
                        en.setPrice(this.mktItem.getUpLimitPrice());
                        break;
                    }
                    case "order_open_sell": 
                    case "order_sell": 
                    case "order_close_sell": {
                        en.setPrice(this.mktItem.getDownLimitPrice());
                        break;
                    }
                }
            }
            en.setSec(this.mktItem.getRefItem().getCode());
            en.setSecName(this.mktItem.getRefItem().getName());
            en.setBrokerId(accDis.getCtpAcc().getBrokerId());
            en.setInvestorId(secAcc.getInvestorId());
            en.setInvestorSecId(secAcc.getInvestorSecId());
            SecAccount acc = (SecAccount)this.of.create(SecAccount.class);
            acc.update((Object)secAcc);
            en.setSecAccount(acc);
            en.setFundAccount((FundAccount)accDis.getCtpAcc());
            en.setExtCashAccntId(accDis.getCtpAcc().getNewCashAccntId());
            this.entrustSplit.setRefItem(this.getValidRef());
            this.entrustSplit.setToday(this.closeToday);
            this.entrustSplit.setInstructionType(this.getAccDis().getInstructType());
            this.entrustSplit.setAccDis(accDis);
            List<FutureSingleEntrust> splitList = this.entrustSplit.split(en, type, instruction);
            enList.addAll(splitList);
        }
        return enList;
    }

    public List<OrderAdvice> getOrderAdvices(String type) throws MException {
        LinkedList<OrderAdvice> adviceList = new LinkedList<OrderAdvice>();
        for (FutureSingleEntrust en : this.orderList) {
            OrderAdvice oa;
            block45: {
                block41: {
                    block44: {
                        block42: {
                            oa = (OrderAdvice)this.of.create(OrderAdvice.class);
                            oa.setInstructionPanelType(this.getAccDis().getInstructType());
                            oa.setSide(en.getSide());
                            oa.setOcFlag(Integer.parseInt(en.getOffsetFlag().getRaw()));
                            oa.setAccntLevel(0);
                            oa.setMarket(this.mktItem.getRefItem().getMarket());
                            oa.setSec(this.mktItem.getRefItem().getCode());
                            oa.setSecType(this.mktItem.getRefItem().getType());
                            oa.setSecName(this.mktItem.getRefItem().getName());
                            oa.setProductId(this.accountService.getAccountFromCache(en.getFundAccount().getParentId()).getProductId());
                            List stepList = this.instrAccModel.getWorkflow(en.getFundAccount().getParentId()).getSteps();
                            if (stepList != null && !stepList.isEmpty()) {
                                for (AccntStepAttribute step : stepList) {
                                    if (1 != step.getStepId()) continue;
                                    oa.setFlowAttriId(step.getFlowAttriId());
                                    oa.setStepAttrId(step.getStepAttriId());
                                    break;
                                }
                            }
                            oa.setInstructionType(64);
                            if (!"50".equals(this.getPriceStg().getRaw())) break block41;
                            oa.setOrdType(50);
                            if (!"5".equals(this.getPriceTypeLimitedStg().getRaw())) break block42;
                            switch (type) {
                                case "order_open_buy": 
                                case "order_close_buy": 
                                case "order_buy": {
                                    oa.setPriceLimit(1);
                                    break;
                                }
                                case "order_open_sell": 
                                case "order_sell": 
                                case "order_close_sell": {
                                    oa.setPriceLimit(4);
                                    break;
                                }
                            }
                            break block44;
                        }
                        oa.setPriceLimit(Integer.valueOf(this.getPriceTypeLimitedStg().getRaw()).intValue());
                    }
                    oa.setPrice(this.getPrice());
                    if (!"3".equals(this.getPriceTypeLimitedStg().getRaw()) || !this.isValidRef()) break block45;
                    switch (type) {
                        case "order_open_buy": 
                        case "order_close_buy": 
                        case "order_buy": {
                            oa.setPrice(this.mktItem.getUpLimitPrice());
                            break;
                        }
                        case "order_open_sell": 
                        case "order_sell": 
                        case "order_close_sell": {
                            oa.setPrice(this.mktItem.getDownLimitPrice());
                            break;
                        }
                    }
                    break block45;
                }
                if ("0".equals(this.getPriceStg().getRaw())) {
                    oa.setOrdType(0);
                    oa.setPriceTypeBidAsk(Integer.valueOf(this.getPriceTypeBidAskStg().getRaw()).intValue());
                    oa.setPrice(this.getPrice());
                }
            }
            ArrayList<AccntSecInfo> accntSecList = new ArrayList<AccntSecInfo>();
            long orderQty = 0L;
            if (en.getQuantity() != 0L) {
                AccntSecInfo accntSec = new AccntSecInfo();
                accntSec.setAccntId(en.getFundAccount().getExtAccntId());
                accntSec.setInvestorId(en.getFundAccount().getInvestId());
                accntSec.setSecAccntId(en.getSecAccount().getExtSecAccntId());
                accntSec.setParentId(en.getFundAccount().getParentId());
                accntSec.setMarket(this.mktItem.getRefItem().getMarket());
                accntSec.setOrderQty(en.getQuantity().longValue());
                orderQty = en.getQuantity();
                accntSecList.add(accntSec);
            }
            oa.setAccSecInfoList(accntSecList);
            oa.setOrderQty(orderQty);
            oa.setAmount(en.getAmt());
            if (accntSecList.isEmpty()) continue;
            adviceList.add(oa);
        }
        return adviceList;
    }

    private void onPermissionChange(boolean isPermit) {
        if (!isPermit) {
            this.setName("\u8d26\u53f7\u65e0\u6743\u9650");
        } else {
            this.setName(this.isValidRef() ? this.getValidRef().getName() : "");
        }
    }

    public Boolean isXSGE() {
        if (!this.isValidRef()) {
            return false;
        }
        if ("XINE".equals(this.mktItem.getRefItem().getMarket()) || this.mktItem.getRefItem().getMarket().equals("XSGE")) {
            return true;
        }
        return false;
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return this.mktItem.getRefItem().getType().equals("FUT");
    }

    private void onDistStgChange() {
        this.getAccDis().setDistStg(this.getDistStg().getRaw());
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public CtpRefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item != null && item instanceof CtpRefItem && item.getType().equals("FUT")) {
            return (CtpRefItem)CtpRefItem.class.cast(item);
        }
        return null;
    }

    public UserPreCtrlPreMetals getPreModel() {
        return this.preModel;
    }

    public void setPreModel(UserPreCtrlPreMetals preModel) {
        this.preModel = preModel;
    }

    public boolean isCloseToday() {
        return this.closeToday;
    }

    public void setCloseToday(boolean closeToday) {
        this.closeToday = closeToday;
    }

    public final ObjectProperty<MxNode> priceTypeLimitedStgProperty() {
        return this.priceTypeLimitedStg;
    }

    public final MxNode getPriceTypeLimitedStg() {
        return (MxNode)this.priceTypeLimitedStgProperty().get();
    }

    public final void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStgProperty().set((Object)priceTypeLimitedStg);
    }

    public final ObjectProperty<MxNode> priceTypeBidAskStgProperty() {
        return this.priceTypeBidAskStg;
    }

    public final MxNode getPriceTypeBidAskStg() {
        return (MxNode)this.priceTypeBidAskStgProperty().get();
    }

    public final void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStgProperty().set((Object)priceTypeBidAskStg);
    }

    public final ObjectProperty<Instruction> instructionProperty() {
        return this.instruction;
    }

    public final Instruction getInstruction() {
        return (Instruction)this.instructionProperty().get();
    }

    public final void setInstruction(Instruction instruction) {
        this.instructionProperty().set((Object)instruction);
    }

    public InstructionModel getInstructionModel() {
        return this.instructionModel;
    }

    public void setInstructionModel(InstructionModel instructionModel) {
        this.instructionModel = instructionModel;
    }

    public final ObjectProperty<MxNode> ocFlagProperty() {
        return this.ocFlag;
    }

    public final MxNode getOcFlag() {
        return (MxNode)this.ocFlagProperty().get();
    }

    public final void setOcFlag(MxNode ocFlag) {
        this.ocFlagProperty().set((Object)ocFlag);
    }
}

