/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.factory.FundAccountFactory;
import cms.tmx.futures.models.CtpAccountDistribution;
import cms.tmx.http.fundaccnt.dto.CashAccnt;
import cms.tmx.http.query.sge.ObSgeCash;
import cms.tmx.http.query.sge.ObSgePosition;
import cms.tmx.http.query.sge.SgePosition;
import cms.tmx.http.secaccnt.dto.SecAccnt;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.current.models.SgeAccountMap;
import cms.tmx.query.current.models.sge.SgeCashModel;
import cms.tmx.query.current.models.sge.SgePositionModel;
import cms.tmx.utils.MathUtils;
import cmx.tmx.data.IContractService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javafx.beans.InvalidationListener;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class PreciousMetalsAccountDistributionModel
extends MxModel {
    @Inject
    private MObjFactory of;
    @Inject
    private SgeAccountMap sgeMap;
    @Inject
    protected SgePositionModel sgeModel;
    @Inject
    private IContractService contractService;
    @Inject
    private IFundAccountService fundAccMng;
    @Inject
    private ExecutorService exe;
    @Inject
    private FundAccountFactory fAcc;
    @Inject
    private SgeCashModel cashModel;
    @Inject
    protected MScheduler sdFullQuery;
    private static final int FULL_QUERY_INTERVAL = 3000;
    private Map<CashAccnt, List<SecAccnt>> accountMap;
    private List<CtpAccountDistribution> accList = new LinkedList<CtpAccountDistribution>();
    private MxList<CtpAccountDistribution> accMxList = new MxList();
    private CtpRefItem ctpRefItem;
    private StringProperty security = new SimpleStringProperty("");
    private BooleanProperty multiAccount = new SimpleBooleanProperty(true);
    private StringProperty countStg = new SimpleStringProperty("");
    private StringProperty distStg = new SimpleStringProperty("");
    private DoubleProperty percent = new SimpleDoubleProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private DoubleProperty price = new SimpleDoubleProperty();
    private IntegerProperty unit = new SimpleIntegerProperty(1);
    private StringProperty hedgeType = new SimpleStringProperty("");
    private BooleanProperty permission = new SimpleBooleanProperty(true);
    private IntegerProperty count = new SimpleIntegerProperty(0);
    private StringProperty instructType = new SimpleStringProperty("");
    private boolean selected = false;
    MxList<SgePosition> sgePosiList = new MxList();
    protected InvalidationListener lstnPosition = ob -> this.filterAcc();
    private InvalidationListener fundListLst = ob -> {
        try {
            this.onFundChange();
        }
        catch (Exception e) {
            this.logger.error("\u4ea4\u6613\u9762\u677f\u4e2d\u671f\u8d27\u8d26\u53f7\u5237\u65b0\u51fa\u9519", (Throwable)e);
        }
    };

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.price.addListener(ob -> this.onPriceChange());
        this.hedgeType.addListener(ob -> this.onHedgeChange());
        this.fundAccMng.changedProperty().addListener(this.fundListLst);
        this.sgeModel.changedProperty().addListener(this.lstnPosition);
        this.queryPostition();
        this.count.addListener(ob -> this.calCount());
        this.distStgProperty().addListener(ob -> this.calCount());
        this.accMxList.getList().forEach(acc -> this.updateFund(acc.getCtpAcc()));
        this.calCash();
    }

    @PreDestroy
    private void close() {
        this.fundAccMng.changedProperty().removeListener(this.fundListLst);
        this.sgeModel.changedProperty().removeListener(this.lstnPosition);
    }

    private void queryPostition() {
        this.exe.execute(() -> {
            this.sgePosiList.addAll((List)this.sgeModel.getSgeList().getList());
            this.sgeModel.query();
        });
    }

    public void onFundChange() {
        this.accMxList.getList().forEach(acc -> this.updateFund(acc.getCtpAcc()));
        this.calCanOpen();
    }

    public void updateFund(CtpFundAccount praAcc) {
        this.accList.forEach(each -> {
            if (each.getCtpAcc().getExtAccntId().equals(praAcc.getExtAccntId())) {
                FundAccount acc = new FundAccount();
                CashAccnt cashAccnt = this.sgeMap.getCashAccnt(praAcc.getExtAccntId(), "SGE");
                if (cashAccnt == null) {
                    return;
                }
                acc.updateCash(cashAccnt);
                if (acc instanceof CtpFundAccount) {
                    each.getCtpAcc().update(CtpFundAccount.class.cast(acc));
                }
            }
        });
    }

    public void onPriceChange() {
        this.calCanOpen();
    }

    private void onHedgeChange() {
        this.filterAcc();
    }

    public synchronized void create() throws MException {
        this.createTableList();
    }

    private void createTableList() throws MException {
        this.accountMap = this.sgeMap.getAccountMap();
        this.accMxList.clear();
        this.accList.clear();
        if (this.accountMap == null) {
            return;
        }
        for (CashAccnt acc : this.accountMap.keySet()) {
            CtpFundAccount fund = (CtpFundAccount)this.fAcc.createFundAccount("SGE");
            fund.updateCash(acc);
            CtpFundAccount fundAcc = (CtpFundAccount)CtpFundAccount.class.cast(fund);
            fundAcc.update((Object)fund);
            CtpAccountDistribution accDst = (CtpAccountDistribution)((Object)this.of.create(CtpAccountDistribution.class));
            accDst.setCtpAcc(fundAcc);
            accDst.setSelected(this.isSelected());
            accDst.selectedProperty().addListener(ob -> this.onAccSelectChange());
            accDst.weightProperty().addListener(ob -> this.calCount());
            this.accList.add(accDst);
        }
        this.accMxList.update(this.accList);
        this.filterAcc();
        this.selectedOne();
    }

    public void filterAcc() {
        this.clearLongShort();
        this.clearCount();
        LinkedList<CtpAccountDistribution> newList = new LinkedList<CtpAccountDistribution>();
        newList.addAll(this.accList);
        newList.forEach(each -> this.calPosition((CtpAccountDistribution)((Object)each)));
        this.accMxList.update(newList);
        this.setPermission(newList.size() != 0);
        this.calCash();
        this.calCanOpen();
        this.calCount();
    }

    private void selectedOne() {
        if (!this.accList.isEmpty()) {
            if (this.accList.size() == 1) {
                this.accList.get(0).setSelected(true);
            } else {
                this.accList.get(0).setSelected(false);
            }
        }
    }

    private void calCash() {
        Map mapList = this.cashModel.getMapList();
        if (this.cashModel.getList().isEmpty() || mapList.isEmpty()) {
            return;
        }
        for (CtpAccountDistribution acc : this.accList) {
            ObSgeCash sgeCash = (ObSgeCash)mapList.get(acc.getCtpAcc().getNewCashAccntId());
            acc.getCtpAcc().setAvailable(sgeCash.getAvailable());
        }
    }

    private void calCanOpen() {
        this.clearCanOpen();
        if (this.sgeModel.getList().isEmpty() || this.ctpRefItem == null) {
            return;
        }
        Map<String, List<ObSgePosition>> posiMap = this.getPosiMap();
        for (CtpAccountDistribution acc : this.accList) {
            String key = this.getKey(acc);
            List<ObSgePosition> list = posiMap.get(key);
            for (ObSgePosition each : list) {
                if (!this.ctpRefItem.getCode().equals(each.getInstrument().getSecId())) continue;
                if (each.getDirection() == 1) {
                    acc.setCanCloseLong((long)each.getAvailable());
                    acc.setCanCloseTdLong(each.getCanCloseTdLong());
                    acc.setCanCloseYdLong(each.getCanCloseYdLong());
                    continue;
                }
                if (each.getDirection() != 2) continue;
                acc.setCanCloseShort((long)each.getAvailable());
                acc.setCanCloseTdShort(each.getCanCloseTdShort());
                acc.setCanCloseYdShort(each.getCanCloseYdShort());
            }
            acc.setLongCount(this.getPrice() == 0.0 ? 0L : (long)(acc.getCtpAcc().getAvailable() / this.getPrice()));
            acc.setShortCount(this.getPrice() == 0.0 ? 0L : (long)(acc.getCtpAcc().getAvailable() / this.getPrice()));
        }
    }

    private String getKey(CtpAccountDistribution acc) {
        return acc.getCtpAcc().getExtAccntId();
    }

    private Map<String, List<ObSgePosition>> getPosiMap() {
        HashMap<String, List<ObSgePosition>> posiMap = new HashMap<String, List<ObSgePosition>>();
        ObservableList list = this.sgeModel.getList();
        for (ObSgePosition data : list) {
            ArrayList<ObSgePosition> list2 = (ArrayList<ObSgePosition>)posiMap.get(data.getAccntId());
            if (list2 == null) {
                list2 = new ArrayList<ObSgePosition>();
                posiMap.put(data.getAccntId(), list2);
            }
            list2.add(data);
        }
        return posiMap;
    }

    private void clearCanOpen() {
        for (CtpAccountDistribution acc : this.accList) {
            acc.setLongCount(0L);
            acc.setLongCount(0L);
        }
    }

    private void calPosition(CtpAccountDistribution accDis) {
        if (this.ctpRefItem == null) {
            return;
        }
        ObservableList positionList = this.sgeModel.getSgeList().getList();
        positionList.forEach(each -> {});
    }

    public SecAccnt getSecAcc(CtpFundAccount fundAcc, String market) {
        Set<CashAccnt> keySet = this.accountMap.keySet();
        if (keySet.isEmpty()) {
            return null;
        }
        for (CashAccnt acc : keySet) {
            if (!fundAcc.getExtAccntId().equals(acc.getAccntId())) continue;
            for (SecAccnt secAcc : this.accountMap.get(acc)) {
                if (!secAcc.getMarket().equals(market)) continue;
                return secAcc;
            }
        }
        return null;
    }

    public void refreshAll() {
        this.clearLongShort();
        this.refreshFunds();
        this.calCanOpen();
        this.refreshPosition();
    }

    public void refreshFunds() {
        this.sgeMap.getAccountMap();
        this.accList.forEach(each -> this.updateFund(each.getCtpAcc()));
    }

    private void refreshPosition() {
        this.sgeModel.query();
        this.accMxList.getList().forEach(each -> this.calPosition((CtpAccountDistribution)((Object)each)));
    }

    private void clearLongShort() {
        for (CtpAccountDistribution acc : this.accList) {
            acc.setCanCloseLong(0L);
            acc.setCanCloseShort(0L);
            acc.setLongCount(0L);
            acc.setLongCount(0L);
        }
    }

    public void clearSelect() {
        if (this.accMxList != null) {
            this.accMxList.getList().forEach(each -> each.setSelected(false));
        }
    }

    public void selectSecAcc(String secAcc, String mkt) {
        if (this.accountMap == null) {
            return;
        }
        this.accountMap.forEach((each, secAccnts) -> {
            for (SecAccnt sub : secAccnts) {
                if (!sub.getSecAccntId().equals(secAcc) || !sub.getMarket().equals(mkt)) continue;
                this.accMxList.getList().forEach(accEach -> {
                    if (accEach.getCtpAcc().getNewCashAccntId().equals(each.getCashAccntId())) {
                        accEach.setSelected(true);
                    }
                });
                break;
            }
        });
    }

    private void onAccSelectChange() {
        this.calCount();
    }

    private void calCount() {
        this.calByCount(this.getCount());
    }

    private long calByCount(long totalCount) {
        totalCount = this.doQuantityAllocate(totalCount);
        return totalCount;
    }

    private long doQuantityAllocate(long pTotal) {
        this.clearCount();
        int totalWeight = 0;
        long totalCount = pTotal;
        int countAcc = this.accMxList.getList().filtered(ad -> ad.isSelected()).size();
        for (CtpAccountDistribution ad2 : this.accMxList.getList().filtered(ad -> ad.isSelected())) {
            totalWeight += 100 * ad2.getWeight();
        }
        long assigned = 0L;
        Iterator it = this.accMxList.getList().filtered(ad -> ad.isSelected()).iterator();
        while (it.hasNext()) {
            CtpAccountDistribution ad3 = (CtpAccountDistribution)((Object)it.next());
            if (!it.hasNext()) {
                long count = MathUtils.calCount((long)(totalCount - assigned), (int)1);
                ad3.setCount(count);
                assigned += count;
                break;
            }
            long target = 0L;
            if (this.getDistStg().equals("1")) {
                target = totalCount / (long)countAcc;
            } else if (this.getDistStg().equals("2")) {
                target = totalCount * (long)ad3.getWeight() * 100L / (long)totalWeight;
            }
            long count = MathUtils.calCount((long)target, (int)this.getUnit());
            assigned += count;
            ad3.setCount(count);
        }
        return assigned;
    }

    public void clearCount() {
        for (CtpAccountDistribution acc : this.getAccList()) {
            acc.setCount(0L);
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public final IntegerProperty countProperty() {
        return this.count;
    }

    public final int getCount() {
        return this.countProperty().get();
    }

    public final void setCount(int count) {
        this.countProperty().set(count);
    }

    public ObservableList<CtpAccountDistribution> getAccList() {
        return this.accMxListProperty().getList();
    }

    public void setAccList(List<CtpAccountDistribution> accList) {
        this.accList = accList;
    }

    public final MxList<CtpAccountDistribution> accMxListProperty() {
        return this.accMxList;
    }

    public MxList<CtpAccountDistribution> getAccMxList() {
        return this.accMxList;
    }

    public void setAccMxList(MxList<CtpAccountDistribution> accMxList) {
        this.accMxList = accMxList;
    }

    public final StringProperty securityProperty() {
        return this.security;
    }

    public final String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public final void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public final BooleanProperty multiAccountProperty() {
        return this.multiAccount;
    }

    public final boolean isMultiAccount() {
        return this.multiAccountProperty().get();
    }

    public final void setMultiAccount(boolean multiAccount) {
        this.multiAccountProperty().set(multiAccount);
    }

    public final StringProperty countStgProperty() {
        return this.countStg;
    }

    public final String getCountStg() {
        return (String)this.countStgProperty().get();
    }

    public final void setCountStg(String countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public final StringProperty distStgProperty() {
        return this.distStg;
    }

    public final String getDistStg() {
        return (String)this.distStgProperty().get();
    }

    public final void setDistStg(String distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public final DoubleProperty percentProperty() {
        return this.percent;
    }

    public final double getPercent() {
        return this.percentProperty().get();
    }

    public final void setPercent(double percent) {
        this.percentProperty().set(percent);
    }

    public final DoubleProperty moneyProperty() {
        return this.money;
    }

    public final double getMoney() {
        return this.moneyProperty().get();
    }

    public final void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    public final DoubleProperty priceProperty() {
        return this.price;
    }

    public final double getPrice() {
        return this.priceProperty().get();
    }

    public final void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public final IntegerProperty unitProperty() {
        return this.unit;
    }

    public final int getUnit() {
        return this.unitProperty().get();
    }

    public final void setUnit(int unit) {
        this.unitProperty().set(unit);
    }

    public final StringProperty hedgeTypeProperty() {
        return this.hedgeType;
    }

    public final String getHedgeType() {
        return (String)this.hedgeTypeProperty().get();
    }

    public final void setHedgeType(String hedgeType) {
        this.hedgeTypeProperty().set((Object)hedgeType);
    }

    public final BooleanProperty permissionProperty() {
        return this.permission;
    }

    public final boolean isPermission() {
        return this.permissionProperty().get();
    }

    public final void setPermission(boolean permission) {
        this.permissionProperty().set(permission);
    }

    public void setRefItem(CtpRefItem item) {
        this.ctpRefItem = item;
    }

    public final StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public final String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public final void setInstructPanelType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }
}

