/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.models;

import cms.tmx.core.MException;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.entity.trade.instruction.OrderAdvice;
import cms.tmx.futures.models.CtpAccountDistributionModel;
import cms.tmx.query.current.models.InstructionAccountModel;
import java.util.List;
import java.util.Map;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class InstrFuturesAccountDistributionModel
extends CtpAccountDistributionModel {
    private Instruction instruction;
    private OrderAdvice advice;
    private BooleanProperty active = new SimpleBooleanProperty(true);
    private StringProperty instructType = new SimpleStringProperty("");
    @Inject
    private InstructionAccountModel instructionAccModel;

    @Override
    public Map<CtpFundAccount, List<SecAccount>> getAccountMap() throws MException {
        if (this.isActive()) {
            return this.instructionAccModel.getCtpActiveAccMap(this.getInstructType());
        }
        return this.instructionAccModel.getCtpPassiveAccMap(this.instruction);
    }

    public void fillAccount(Instruction instruction) {
        this.setInstruction(instruction);
        this.setAdvice(instruction.getOrderAdvice());
        this.setActive(false);
        this.setSelected(true);
        try {
            this.createTableList();
        }
        catch (MException e) {
            this.logger.error("\u67e5\u8be2\u8d44\u91d1\u8d26\u53f7\u5931\u8d25" + (Object)((Object)e));
        }
    }

    public StringProperty instructTypeProperty() {
        return this.instructType;
    }

    public String getInstructType() {
        return (String)this.instructTypeProperty().get();
    }

    public void setInstructPanelType(String instructType) {
        this.instructTypeProperty().set((Object)instructType);
    }

    public BooleanProperty activeProperty() {
        return this.active;
    }

    public boolean isActive() {
        return this.activeProperty().get();
    }

    public void setActive(boolean active) {
        this.activeProperty().set(active);
    }

    public Instruction getInstruction() {
        return this.instruction;
    }

    public void setInstruction(Instruction instruction) {
        this.instruction = instruction;
    }

    public OrderAdvice getAdvice() {
        return this.advice;
    }

    public void setAdvice(OrderAdvice advice) {
        this.advice = advice;
    }
}

