/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures.instructions.models;

import cms.tmx.core.MException;
import cms.tmx.define.MxDict;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.CtpSecAccount;
import cms.tmx.entity.FundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.CtpContract;
import cms.tmx.entity.data.CtpRefItem;
import cms.tmx.entity.data.MarketItem;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.instruction.Instruction;
import cms.tmx.futures.entrust.EntrustFactory;
import cms.tmx.futures.instructions.models.UserPreCtrlFutures;
import cms.tmx.futures.models.CtpEntrustSplitModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IAccountService;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.current.models.InstructionAccountModel;
import cms.tmx.query.current.models.InstructionModel;
import cms.tmx.trade.entrust.FutureSingleEntrust;
import cms.tmx.utils.MarketUtils;
import cmx.tmx.data.IContractService;
import cmx.tmx.data.IMarketDataMng;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class FuturesTradeMarketModel {
    private StringProperty fundAcct = new SimpleStringProperty("");
    private StringProperty security = new SimpleStringProperty("");
    private ObjectProperty<MarketItem> item = new SimpleObjectProperty();
    private StringProperty name = new SimpleStringProperty("");
    private DoubleProperty price = new SimpleDoubleProperty();
    private LongProperty count = new SimpleLongProperty();
    private DoubleProperty money = new SimpleDoubleProperty();
    private ObjectProperty<MxNode> priceStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> countStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> distStg = new SimpleObjectProperty();
    private String hedgeType = "1";
    private ObjectProperty<MxNode> ocFlag = new SimpleObjectProperty();
    private int splitCount = 39;
    private boolean enableSplit = true;
    private ObjectProperty<MxNode> priceTypeLimitedStg = new SimpleObjectProperty();
    private ObjectProperty<MxNode> priceTypeBidAskStg = new SimpleObjectProperty();
    private MarketItem mktItem;
    @Inject
    private IMarketDataMng mktMng;
    @Inject
    private EntrustFactory ef;
    private UserPreCtrlFutures preModel;
    private boolean closeToday;
    @Inject
    protected CtpEntrustSplitModel entrustSplit;
    @Inject
    protected IAccountService accountService;
    @Inject
    protected InstructionAccountModel instrAccModel;
    @Inject
    private InstructionModel instructionModel;
    private List<FutureSingleEntrust> orderList;
    @Inject
    public CtpAccountMap accMng;
    @Inject
    private ExecutorService exe;
    @Inject
    private IContractService contractService;
    private CtpContract con;

    @PostConstruct
    public void init() {
        this.mktItem = this.mktMng.createItem(5);
        MxNode node = MxNodeFactory.create((String)"cstr_price_type", (String)"50");
        this.initPriceType(node);
        this.setPriceStg(node);
        this.priceStg.addListener(ob -> this.onPriceStgChange());
        node = MxNodeFactory.createNew((String)"cstr_price_type_limited", (String)"2");
        this.initPriceTypeLimit(node);
        this.setPriceTypeLimitedStg(node);
        node = MxNodeFactory.create((String)"instr_handicap", (String)"-1");
        this.initPriceTypeGear(node);
        this.setPriceTypeBidAskStg(node);
        this.priceTypeBidAskStg.addListener(ob -> this.onPriceStgChange());
        node = MxNodeFactory.createNew((String)"position_effect", (String)"70");
        this.ocFlag(node);
        this.setOcFlag(node);
        node = MxNodeFactory.create((String)"futures_count_stg", (String)"1");
        this.setCountStg(node);
    }

    public void onSecChange() {
        this.mktItem.setRefItem((RefItem)this.getValidRef());
        this.mktMng.dye(this.mktItem);
        this.setName(this.isValidRef() ? this.getValidRef().getName() : "");
    }

    public final MarketItem getMI() {
        return this.mktItem;
    }

    public StringProperty securityProperty() {
        return this.security;
    }

    public String getSecurity() {
        return (String)this.securityProperty().get();
    }

    public void setSecurity(String security) {
        this.securityProperty().set((Object)security);
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public String getName() {
        return (String)this.nameProperty().get();
    }

    public void setName(String name) {
        this.nameProperty().set((Object)name);
    }

    public ObjectProperty<MarketItem> itemProperty() {
        return this.item;
    }

    public MarketItem getItem() {
        return (MarketItem)this.itemProperty().get();
    }

    public void setItem(MarketItem item) {
        this.itemProperty().set((Object)item);
    }

    public DoubleProperty priceProperty() {
        return this.price;
    }

    public double getPrice() {
        return this.priceProperty().get();
    }

    public void setPrice(double price) {
        this.priceProperty().set(price);
    }

    public void execute(Instruction instruction) throws MException {
        this.instructionModel.execute(instruction, MxDict.WORKFLOW_EXECUTE, "");
    }

    public LongProperty countProperty() {
        return this.count;
    }

    public long getCount() {
        return this.countProperty().get();
    }

    public void setCount(long count) {
        this.countProperty().set(count);
    }

    public ObjectProperty<MxNode> priceStgProperty() {
        return this.priceStg;
    }

    public MxNode getPriceStg() {
        return (MxNode)this.priceStgProperty().get();
    }

    public void setPriceStg(MxNode priceStg) {
        this.priceStgProperty().set((Object)priceStg);
    }

    public ObjectProperty<MxNode> countStgProperty() {
        return this.countStg;
    }

    public MxNode getCountStg() {
        return (MxNode)this.countStgProperty().get();
    }

    public void setCountStg(MxNode countStg) {
        this.countStgProperty().set((Object)countStg);
    }

    public ObjectProperty<MxNode> distStgProperty() {
        return this.distStg;
    }

    public MxNode getDistStg() {
        return (MxNode)this.distStgProperty().get();
    }

    public void setDistStg(MxNode distStg) {
        this.distStgProperty().set((Object)distStg);
    }

    public String getHedgeType() {
        return this.hedgeType;
    }

    public void setHedgeType(String hedgeType) {
        this.hedgeType = hedgeType;
    }

    public DoubleProperty moneyProperty() {
        return this.money;
    }

    public double getMoney() {
        return this.moneyProperty().get();
    }

    public void setMoney(double money) {
        this.moneyProperty().set(money);
    }

    private void initPriceType(MxNode node) {
        this.removeOthers(node, "50");
        node.addNode("0");
    }

    private void initPriceTypeLimit(MxNode node) {
        this.removeOthers(node, "2");
        node.addNode("3");
        node.addNode("5");
    }

    private void initPriceTypeGear(MxNode node) {
        node.removeOthers("-5");
        node.addNode("-4");
        node.addNode("-3");
        node.addNode("-2");
        node.addNode("-1");
        node.addNode("0");
        node.addNode("1");
        node.addNode("2");
        node.addNode("3");
        node.addNode("4");
        node.addNode("5");
    }

    public boolean isBidAskPrice() {
        return this.getPriceStg().is("0");
    }

    private void onPriceStgChange() {
        this.setPrice(this.getHandicapPrice());
    }

    public double getHandicapPrice() {
        if (!this.isBidAskPrice()) {
            return 0.0;
        }
        int raw = Integer.parseInt(this.getPriceTypeBidAskStg().getRaw());
        double price = 0.0;
        if (raw > 0) {
            while (price <= 0.0 && raw > 0 && raw <= 5) {
                price = this.mktItem.getBuyPrice(raw - 1);
                --raw;
            }
        }
        if (raw < 0) {
            raw = Math.abs(raw);
            while (price <= 0.0 && raw > 0 && raw <= 5) {
                price = this.mktItem.getSellPrice(raw - 1);
                --raw;
            }
        }
        if (price <= 0.0) {
            price = this.mktItem.getNowPrice() == 0.0 ? this.mktItem.getClosePrice() : this.mktItem.getNowPrice();
        }
        return price;
    }

    public boolean isLimitPrice() {
        return this.getPriceStg().is(Integer.toString(50));
    }

    private void ocFlag(MxNode node) {
        node.removeOthersAndAddThis("70");
        node.addNode("79");
        node.addNode("67");
    }

    public synchronized ObservableList<Boolean> submit() throws Exception {
        ObservableList returnList = FxUtils.newList();
        CountDownLatch latch = new CountDownLatch(this.orderList.size());
        for (FutureSingleEntrust en : this.orderList) {
            this.exe.execute(() -> {
                try {
                    try {
                        en.submit();
                        returnList.add((Object)true);
                    }
                    catch (MException mException) {
                        returnList.add((Object)false);
                        latch.countDown();
                    }
                }
                finally {
                    latch.countDown();
                }
            });
        }
        latch.await();
        return returnList;
    }

    public SecAccount getExtSecAcc(String fundAcct, String hedgeFlag, String market) throws Exception, MException {
        CtpSecAccount secAcct = null;
        CtpFundAccount fund = this.accMng.getFundAcc(fundAcct);
        List listSec = (List)this.accMng.getAccountMap().get(fund);
        for (SecAccount sec : listSec) {
            CtpSecAccount acc = (CtpSecAccount)sec;
            if (!hedgeFlag.equals(String.valueOf(acc.getHedgeFlag())) || !acc.getExchange().getRaw().equals(market)) continue;
            secAcct = acc;
            break;
        }
        if (secAcct == null) {
            throw new Exception("\u6839\u636e\u8d44\u91d1\u8d26\u53f7\u548c\u6295\u4fdd\u6807\u8bc6\u672a\u80fd\u627e\u5230\u8bc1\u5238\u8d26\u53f7");
        }
        return secAcct;
    }

    public List<FutureSingleEntrust> getMarketPreOrderList(boolean buy, String type, String investorId) throws Exception, MException {
        LinkedList<FutureSingleEntrust> enList = new LinkedList<FutureSingleEntrust>();
        this.orderList = enList;
        long count = this.getCount();
        do {
            long quantity = 0L;
            if (this.isEnableSplit() && count > (long)this.splitCount) {
                quantity = this.splitCount;
                count -= (long)this.splitCount;
            } else {
                quantity = count;
                count = 0L;
            }
            CtpFundAccount fund = this.accMng.getFundAcc(this.getFundAcct());
            CtpSecAccount secAcct = (CtpSecAccount)this.getExtSecAcc(this.getFundAcct(), this.getHedgeType(), this.getMI().getRefItem().getMarket());
            FutureSingleEntrust en = this.ef.createSingle(fund.getExtAccntId(), secAcct.getExtSecAccntId());
            en.setQuantity(quantity);
            en.setMarket(this.mktItem.getRefItem().getMarket());
            en.setMarketGrp(MarketUtils.getMarketGroup((String)en.getMarket()));
            en.setSecType("FUT");
            if ("50".equals(this.getPriceStg().getRaw())) {
                en.setOrderType(50);
            } else if ("0".equals(this.getPriceStg().getRaw())) {
                en.setOrderType(0);
            }
            en.setPrice(this.getPrice());
            en.setSec(this.mktItem.getRefItem().getCode());
            en.setSecName(this.mktItem.getRefItem().getName());
            en.setHedgeFlag(Integer.parseInt(this.getHedgeType()));
            en.setBrokerId(fund.getBrokerId());
            en.setInvestorId(fund.getInvestId());
            en.setInvestorSecId(secAcct.getInverstorSecId());
            en.setSecAccount((SecAccount)secAcct);
            en.setFundAccount((FundAccount)fund);
            en.setSide(buy ? 49 : 50);
            en.setOffsetFlag(this.getOcFlag());
            this.con = this.contractService.getContract("FUTURES", en.getMarket(), en.getSec(), en.getBrokerId(), en.getInvestorId());
            en.setAmt(this.getAmt(this.getOcFlag(), this.getPrice(), this.getCount()));
            en.setShowCloseTip(false);
            enList.add(en);
        } while (count > 0L);
        return enList;
    }

    private double getAmt(MxNode ocFlag, double price, long quantity) {
        if (this.con == null) {
            return 0.0;
        }
        String offsetFlag = ocFlag.getRaw();
        if ("79".equals(offsetFlag)) {
            BigDecimal amt = new BigDecimal(price).multiply(new BigDecimal(quantity)).multiply(new BigDecimal(this.con.getUnderlyingMultiple())).multiply(new BigDecimal(this.con.getLongMarginRatio())).multiply(new BigDecimal(this.con.getVolumeMultiple())).setScale(this.getValidRef().getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        if ("67".equals(offsetFlag) || "84".equals(offsetFlag)) {
            BigDecimal amt = new BigDecimal(price).multiply(new BigDecimal(quantity)).multiply(new BigDecimal(this.con.getUnderlyingMultiple())).multiply(new BigDecimal(this.con.getShortMarginRatio())).multiply(new BigDecimal(this.con.getVolumeMultiple())).setScale(this.getValidRef().getScale(), RoundingMode.HALF_UP);
            return amt.doubleValue();
        }
        return 0.0;
    }

    public boolean isValidRef() {
        if (this.mktItem.getRefItem() == null) {
            return false;
        }
        return this.mktItem.getRefItem().getType().equals("FUT");
    }

    public void removeOthers(MxNode rowNode, String raw) {
        Iterator it = rowNode.getNodes().iterator();
        while (it.hasNext()) {
            MxNode node = (MxNode)it.next();
            if (node.getRaw().equals(raw)) continue;
            it.remove();
        }
    }

    public CtpRefItem getValidRef() {
        RefItem item = this.mktItem.getRefItem();
        if (item != null && item instanceof CtpRefItem && item.getType().equals("FUT")) {
            return (CtpRefItem)CtpRefItem.class.cast(item);
        }
        return null;
    }

    public UserPreCtrlFutures getPreModel() {
        return this.preModel;
    }

    public void setPreModel(UserPreCtrlFutures preModel) {
        this.preModel = preModel;
    }

    public boolean isCloseToday() {
        return this.closeToday;
    }

    public void setCloseToday(boolean closeToday) {
        this.closeToday = closeToday;
    }

    public final ObjectProperty<MxNode> priceTypeLimitedStgProperty() {
        return this.priceTypeLimitedStg;
    }

    public final MxNode getPriceTypeLimitedStg() {
        return (MxNode)this.priceTypeLimitedStgProperty().get();
    }

    public final void setPriceTypeLimitedStg(MxNode priceTypeLimitedStg) {
        this.priceTypeLimitedStgProperty().set((Object)priceTypeLimitedStg);
    }

    public final ObjectProperty<MxNode> priceTypeBidAskStgProperty() {
        return this.priceTypeBidAskStg;
    }

    public final MxNode getPriceTypeBidAskStg() {
        return (MxNode)this.priceTypeBidAskStgProperty().get();
    }

    public final void setPriceTypeBidAskStg(MxNode priceTypeBidAskStg) {
        this.priceTypeBidAskStgProperty().set((Object)priceTypeBidAskStg);
    }

    public InstructionModel getInstructionModel() {
        return this.instructionModel;
    }

    public void setInstructionModel(InstructionModel instructionModel) {
        this.instructionModel = instructionModel;
    }

    public final ObjectProperty<MxNode> ocFlagProperty() {
        return this.ocFlag;
    }

    public final MxNode getOcFlag() {
        return (MxNode)this.ocFlagProperty().get();
    }

    public final void setOcFlag(MxNode ocFlag) {
        this.ocFlagProperty().set((Object)ocFlag);
    }

    public final StringProperty fundAcctProperty() {
        return this.fundAcct;
    }

    public final String getFundAcct() {
        return (String)this.fundAcctProperty().get();
    }

    public final void setFundAcct(String fundAcct) {
        this.fundAcctProperty().set((Object)fundAcct);
    }

    public int getSplitCount() {
        return this.splitCount;
    }

    public void setSplitCount(int splitCount) {
        this.splitCount = splitCount;
    }

    public boolean isEnableSplit() {
        return this.enableSplit;
    }

    public void setEnableSplit(boolean enableSplit) {
        this.enableSplit = enableSplit;
    }
}

