/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.futures;

import cms.tmx.api.mng.ICommApi;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.javafx.MxModel;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class HeartBeatMng
extends MxModel {
    private static final int MIN_SERVER_HEART_BEAT_INTERVAL = 1000;
    private static final int DEFAULT_SERVER_HEART_BEAT_INTERVAL = 10000;
    private BooleanProperty connected = new SimpleBooleanProperty(true);
    @Inject
    private ICommApi apiComm;
    @Inject
    private MEventService es;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private MConfService cs;
    private ScheduledFuture<?> futureHB;
    private int interval;

    @PostConstruct
    public void init() {
        this.interval = this.cs.getValueAsInt("server.hb.interval", 10000);
        if (this.interval < 1000) {
            this.interval = 1000;
        }
        this.es.subscribe("stage.after.login", event -> this.afterLogin(event));
        this.es.subscribe("ctp.heartbeat", event -> this.heartBeat());
    }

    @PreDestroy
    private void close() {
        if (this.futureHB != null) {
            this.futureHB.cancel(true);
        }
    }

    private void afterLogin(MEvent event) {
        this.es.subscribe("server.connected", eComm -> this.onServerConnected(eComm, true));
        this.es.subscribe("server.disconnected", eComm -> this.onServerConnected(eComm, false));
    }

    private synchronized void onServerConnected(MEvent event, boolean connected) {
        String serverType = event.getStr("server_type");
        if (!serverType.equals("marketmaking")) {
            return;
        }
        this.heartBeat();
    }

    private synchronized void heartBeat() {
        boolean bRet = this.doHeartBeat();
        if (bRet) {
            this.logger.debug("[HB Strategy] hb ok");
            if (!this.isConnected()) {
                this.es.postEvent("strategy.hb.reconnected", null);
            }
            this.setConnected(true);
        } else {
            this.logger.error("[HB Strategy] hb fail");
            if (this.isConnected()) {
                this.es.postEvent("strategy.hb.disconnected", null);
            }
            this.setConnected(false);
        }
    }

    private boolean doHeartBeat() {
        return this.apiComm.strategyHeartbeatReq();
    }

    public final BooleanProperty connectedProperty() {
        return this.connected;
    }

    public final boolean isConnected() {
        return this.connectedProperty().get();
    }

    public final void setConnected(boolean connected) {
        this.connectedProperty().set(connected);
    }
}

