/*
 * Decompiled with CFR 0.152.
 */
package OrsClientApi;

import OrsClientApi.OrsClientApiCallbackInterface;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OrsClientApiCallback
implements OrsClientApiCallbackInterface {
    private static final Logger logger = LogManager.getLogger(OrsClientApiCallback.class);
    @Inject
    protected MEventService es;

    @Override
    public void OnShowRunInfo(int logLevel, String msg) {
        logger.info("logLevel:" + logLevel + ", msg: " + msg + "\n");
    }

    @Override
    public void OnConnectEvent(int eventId, String msg) {
        logger.info("eventId: " + eventId + ", msg: " + msg + "\n");
    }

    @Override
    public void OnInsertAlgoOrder(String engineName, String algoType, int reqId, String rspInfo) {
        MEvent event = new MEvent();
        event.put((Object)"rspInfo", (Object)rspInfo);
        this.es.postEvent("OnInsertAlgoOrder", event);
    }

    @Override
    public void OnCancelAlgoOrder(String engineName, String algoOrderId, int reqId, String rspInfo) {
        MEvent event = new MEvent();
        event.put((Object)"rspInfo", (Object)rspInfo);
        this.es.postEvent("OnCancelAlgoOrder", event);
        this.ShowInfo("OnCancelAlgoOrder", engineName, algoOrderId, reqId, rspInfo);
    }

    @Override
    public void OnModifyAlgoOrder(String engineName, String algoOrderId, int reqId, String rspInfo) {
        this.ShowInfo("OnModifyAlgoOrder", engineName, algoOrderId, reqId, rspInfo);
    }

    @Override
    public void OnPauseAlgoOrder(String engineName, String algoOrderId, int reqId, String rspInfo) {
        this.ShowInfo("OnPauseAlgoOrder", engineName, algoOrderId, reqId, rspInfo);
    }

    @Override
    public void OnQueryAlgoOrder(String engineName, String algoOrderId, int reqId, String rspInfo) {
        MEvent event = new MEvent();
        event.put((Object)"rspInfo", (Object)rspInfo);
        this.es.postEvent("OnQueryAlgoOrder", event);
        this.ShowInfo("OnQueryAlgoOrder", engineName, algoOrderId, reqId, rspInfo);
    }

    @Override
    public void OnQueryEntrust(String engineName, String algoOrderId, int reqId, String rspInfo) {
        this.ShowInfo("OnQueryEntrust", engineName, algoOrderId, reqId, rspInfo);
    }

    @Override
    public void OnQueryRealdone(String engineName, String algoOrderId, int reqId, String rspInfo) {
        this.ShowInfo("OnQueryRealdone", engineName, algoOrderId, reqId, rspInfo);
    }

    private void ShowInfo(String func, String engineName, String algoOrderId, int reqId, String rspInfo) {
        logger.info(String.valueOf(func) + "  engineName:  " + engineName + " algoOrderId: " + algoOrderId + "  reqId: " + reqId + "  rspInfo: " + rspInfo);
    }
}

