/*
 * Decompiled with CFR 0.152.
 */
package OrsClientApi;

import OrsClientApi.OrsClientApiCallback;
import OrsClientApi.OrsClientApiService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class CallBackInit {
    private static final Logger logger = LogManager.getLogger(CallBackInit.class);
    @Inject
    private OrsClientApiCallback cb;

    @PostConstruct
    public void init() {
        try {
            long b = System.currentTimeMillis();
            FutureTask<Boolean> loadApi = new FutureTask<Boolean>(() -> {
                OrsClientApiService.getInstance();
                if (!OrsClientApiService.getInstance().CreateApi("log\\algo\\OrsClientApi.log")) {
                    logger.error("failed to create API!");
                    return true;
                }
                OrsClientApiService.getInstance().RegisterSpi(this.cb);
                if (OrsClientApiService.getInstance().Init(1000) != 0) {
                    logger.error("Init API failed");
                    OrsClientApiService.getInstance().ReleaseApi();
                }
                logger.info("\u52a0\u8f7d\u7b97\u6cd5\u7ec4\u5408\u5957\u5229\u8017\u65f6" + (System.currentTimeMillis() - b));
                return true;
            });
            new Thread(loadApi).start();
            loadApi.get(10000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            logger.error("\u7ec4\u5408\u5957\u5229\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }
}

