/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base.addons;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MGenericTile;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MArea;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.workbench.UIEvents;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.core.ThreadSynchronize;
import org.eclipse.fx.core.log.LoggerCreator;
import org.osgi.service.event.Event;

public class CleanUpAddon {
    @Inject
    ThreadSynchronize synchronize;
    @Inject
    EModelService modelService;

    @PostConstruct
    void init(IEventBroker broker) {
        broker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this::handleChildrenModified);
        broker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this::handleRenderingChanged);
    }

    private void handleChildrenModified(Event event) {
        Object changedObj = event.getProperty("ChangedElement");
        if (UIEvents.isREMOVE((Event)event)) {
            MElementContainer container = (MElementContainer)changedObj;
            MElementContainer containerParent = container.getParent();
            if (container instanceof MCompositePart || container instanceof MApplication || container instanceof MPerspectiveStack || container instanceof MMenuElement || container instanceof MTrimBar || container instanceof MToolBar || container instanceof MArea || container.getTags().contains("NoAutoCollapse")) {
                return;
            }
            if (container instanceof MWindow && containerParent instanceof MApplication && !container.getTags().contains("secondaryMainWindow")) {
                return;
            }
            this.synchronize.scheduleExecution(200L, () -> {
                int tbrCount = this.modelService.toBeRenderedCount(container);
                boolean lastStack = this.isLastEditorStack((MUIElement)container);
                if (tbrCount == 0 && !lastStack) {
                    container.setToBeRendered(false);
                }
                if (container.getChildren().isEmpty()) {
                    container.setParent(null);
                } else if (!(container instanceof MCompositePart) && container instanceof MGenericTile && container.getChildren().size() == 1 && container.getElementId() != null) {
                    MGenericTile tile = (MGenericTile)container;
                    int idx = container.getParent().getChildren().indexOf(container);
                    String containerData = tile.getContainerData();
                    MUIElement child = (MUIElement)container.getChildren().remove(0);
                    if (child != null) {
                        child.setContainerData(containerData);
                        container.getParent().getChildren().add(idx, child);
                        container.setParent(null);
                    } else {
                        LoggerCreator.createLogger(this.getClass()).error("Container has a NULL value as a child");
                    }
                }
            });
        }
    }

    private void handleRenderingChanged(Event event) {
        block9: {
            MElementContainer container;
            block8: {
                MUIElement changedObj = (MUIElement)event.getProperty("ChangedElement");
                container = null;
                container = changedObj.getCurSharedRef() != null ? changedObj.getCurSharedRef().getParent() : changedObj.getParent();
                if (container == null) {
                    return;
                }
                MElementContainer containerElement = container;
                if (containerElement instanceof MWindow && !containerElement.getTags().contains("secondaryMainWindow") && containerElement.getParent() != null) {
                    return;
                }
                if (this.isLastEditorStack((MUIElement)containerElement) || containerElement instanceof MPerspective || containerElement instanceof MPerspectiveStack) {
                    return;
                }
                Boolean toBeRendered = (Boolean)event.getProperty("NewValue");
                if (!Boolean.TRUE.equals(toBeRendered)) break block8;
                if (!container.isToBeRendered()) {
                    container.setToBeRendered(true);
                }
                if (container.isVisible() || container.getTags().contains("Minimized")) break block9;
                container.setVisible(true);
                break block9;
            }
            if (container.getTags().contains("NoAutoCollapse")) {
                return;
            }
            int visCount = this.modelService.countRenderableChildren((MUIElement)container);
            MElementContainer theContainer = container;
            if (visCount == 0) {
                this.synchronize.scheduleExecution(200L, () -> {
                    int _visCount = this.modelService.countRenderableChildren((MUIElement)theContainer);
                    if (!this.isLastEditorStack((MUIElement)theContainer) && _visCount == 0) {
                        theContainer.setToBeRendered(false);
                    }
                });
            } else {
                boolean makeInvisible = true;
                for (MUIElement kid : container.getChildren()) {
                    if (!kid.isToBeRendered() || !kid.isVisible()) continue;
                    makeInvisible = false;
                    break;
                }
            }
        }
    }

    boolean isLastEditorStack(MUIElement element) {
        return this.modelService.isLastEditorStack(element);
    }
}

