/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.renderers;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MCompositePart;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartImpl;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.IPresentationEngine;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fx.core.bindings.FXBindings;
import org.eclipse.fx.ui.controls.tabpane.DndTabPaneFactory;
import org.eclipse.fx.ui.services.resources.GraphicsLoader;
import org.eclipse.fx.ui.workbench.fx.EMFUri;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WCallback;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMinMaxableWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WPopupMenu;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WWidget;
import org.eclipse.fx.ui.workbench.renderers.fx.DefStackRenderer;
import org.eclipse.fx.ui.workbench.renderers.fx.internal.DnDSupport;
import org.eclipse.fx.ui.workbench.renderers.fx.widget.WLayoutedWidgetImpl;
import org.eclipse.fx.ui.workbench.services.ModelService;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class MStackRenderer
extends DefStackRenderer {
    protected Class<? extends WStack<Node, Object, Node>> getWidgetClass(MPartStack stack) {
        if (stack.getTags().contains("fx_pagination") || stack.getTags().contains("fx_stackpane")) {
            return super.getWidgetClass(stack);
        }
        return StackWidgetImpl.class;
    }

    static class StackItemImpl
    implements WStack.WStackItem<Object, Node> {
        Tab tab;
        private WCallback<WStack.WStackItem<Object, Node>, Node> initCallback;
        WCallback<WStack.WStackItem<Object, Node>, Boolean> closeCallback;
        private MStackElement domElement;
        @Inject
        private GraphicsLoader graphicsLoader;
        @Inject
        private EModelService modelService;
        @Inject
        private MEventService es;
        @Inject
        private ECommandService cs;
        @Inject
        private EHandlerService hs;
        @Inject
        IPresentationEngine engine;
        private String label;
        private boolean dirty;
        private static final Logger logger = LogManager.getLogger(StackItemImpl.class);
        private ObjectProperty<org.eclipse.fx.core.URI> iconUri = new SimpleObjectProperty((Object)this, "iconUri", null);
        private static final String ITEM_TEXT_OPEN = "\u6d6e\u51fa";
        private static final String ITEM_TEXT_MUTIL = "\u591a\u5f00";
        private static final String ITEM_TEXT_COLLECT = "\u6536\u85cf";
        private static final String ITEM_TEXT_UN_COLLECT = "\u53d6\u6d88\u6536\u85cf";
        private static final String ITEM_TEXT_CLOSE_OTHERS = "\u5173\u95ed\u5176\u4ed6";
        private static final String ITEM_TEXT_CLOSE_LEFT = "\u5173\u95ed\u5de6\u4fa7";
        private static final String ITEM_TEXT_CLOSE_RIGHT = "\u5173\u95ed\u53f3\u4fa7";
        private static final String ITEM_TEXT_CLOSE_ALL = "\u5168\u90e8\u5173\u95ed";
        private ContextMenu tabMenu = new ContextMenu();
        private MenuItem itemDetach = new MenuItem("\u6d6e\u51fa");
        private MenuItem itemMutil = new MenuItem("\u591a\u5f00");
        private MenuItem itemCollect = new MenuItem("\u6536\u85cf");
        private MenuItem itemUnCollect = new MenuItem("\u53d6\u6d88\u6536\u85cf");
        private MenuItem itemCloseOthers = new MenuItem("\u5173\u95ed\u5176\u4ed6");
        private MenuItem itemCloseLeft = new MenuItem("\u5173\u95ed\u5de6\u4fa7");
        private MenuItem itemCloseRight = new MenuItem("\u5173\u95ed\u53f3\u4fa7");
        private MenuItem itemCloseAll = new MenuItem("\u5168\u90e8\u5173\u95ed");
        @Inject
        private EPartService ps;

        @Inject
        public StackItemImpl(@Named(value="localizedLabel") @Optional String label, @Named(value="dirty") @Optional boolean dirty) {
            this.label = label;
            this.dirty = dirty;
        }

        @PostConstruct
        void init() {
            this.getWidget();
            if (this.tab != null && this.tab.getTabPane() != null) {
                Platform.runLater(() -> this.tab.getTabPane().getSelectionModel().select((Object)this.tab));
            }
        }

        public void setDomElement(MStackElement domElement) {
            this.domElement = domElement;
            if (this.domElement instanceof MPart) {
                ((MPart)this.domElement).getMenus().stream().filter(m -> m instanceof MPopupMenu).filter(m -> m.getTags().contains("tabmenu")).findFirst().map(m -> (ContextMenu)((WPopupMenu)this.engine.createGui((MUIElement)m, null, this.modelService.getContainingContext((MUIElement)domElement.getParent()))).getWidget()).ifPresent(arg_0 -> ((Tab)this.getWidget()).setContextMenu(arg_0));
            } else {
                this.getWidget().setContextMenu(null);
            }
        }

        public MStackElement getDomElement() {
            return this.domElement;
        }

        protected Tab getWidget() {
            if (this.tab == null) {
                this.tab = this.createWidget();
            }
            this.tab.setUserData((Object)this);
            return this.tab;
        }

        protected Tab createWidget() {
            Tab t = new Tab();
            t.setOnCloseRequest(this::handleOnCloseRequest);
            this.itemDetach.setOnAction(event -> {
                this.ps.showPart((MPart)PartImpl.class.cast(this.domElement), EPartService.PartState.ACTIVATE);
                this.onItemDetach((ActionEvent)event);
            });
            this.itemMutil.setOnAction(event -> {
                this.ps.showPart((MPart)PartImpl.class.cast(this.domElement), EPartService.PartState.ACTIVATE);
                this.onItemMutil((ActionEvent)event);
            });
            this.itemCollect.setOnAction(event -> {
                MEvent e = new MEvent();
                e.put((Object)"part_name", (Object)((MPart)MPart.class.cast(this.domElement)).getLabel());
                e.put((Object)"menuId", (Object)this.domElement.getElementId());
                this.es.sendEvent("user.collect.menus", e);
                if (e.isOK()) {
                    this.tabMenu.getItems().add((Object)this.itemUnCollect);
                    this.tabMenu.getItems().remove((Object)this.itemCollect);
                }
            });
            this.itemCloseOthers.setOnAction(event -> {
                MEvent ev = new MEvent();
                ev.setId("others");
                ev.setObj((Object)this.domElement.getElementId());
                this.es.sendEvent("part.close", ev);
            });
            this.itemCloseLeft.setOnAction(event -> {
                MEvent ev = new MEvent();
                ev.setId("left");
                ev.setObj((Object)this.domElement.getElementId());
                this.es.sendEvent("part.close", ev);
            });
            this.itemCloseRight.setOnAction(event -> {
                MEvent ev = new MEvent();
                ev.setId("right");
                ev.setObj((Object)this.domElement.getElementId());
                this.es.sendEvent("part.close", ev);
            });
            this.itemCloseAll.setOnAction(event -> {
                MEvent ev = new MEvent();
                ev.setId("all");
                ev.setObj((Object)this.domElement.getElementId());
                this.es.sendEvent("part.close", ev);
            });
            this.itemUnCollect.setOnAction(event -> {
                MEvent e = new MEvent();
                e.put((Object)"part_name", (Object)((MPart)MPart.class.cast(this.domElement)).getLabel());
                e.put((Object)"menuId", (Object)this.domElement.getElementId());
                this.es.sendEvent("user.uncollect.menus", e);
                if (e.isOK()) {
                    this.tabMenu.getItems().add((Object)this.itemCollect);
                    this.tabMenu.getItems().remove((Object)this.itemUnCollect);
                }
            });
            this.tabMenu.getItems().addAll((Object[])new MenuItem[]{this.itemDetach});
            t.setContextMenu(this.tabMenu);
            this.tabMenu.setOnShowing(event -> {
                this.tabMenu.getItems().remove((Object)this.itemMutil);
                this.tabMenu.getItems().remove((Object)this.itemCollect);
                this.tabMenu.getItems().remove((Object)this.itemUnCollect);
                this.tabMenu.getItems().remove((Object)this.itemCloseOthers);
                this.tabMenu.getItems().remove((Object)this.itemCloseLeft);
                this.tabMenu.getItems().remove((Object)this.itemCloseRight);
                this.tabMenu.getItems().remove((Object)this.itemCloseAll);
                if (!(this.getDomElement() instanceof MCompositePart)) {
                    this.tabMenu.getItems().add((Object)this.itemMutil);
                }
                if ("cms.tmx.app.ps.right".equals(this.domElement.getParent().getElementId()) && !this.domElement.getElementId().contains("cms.tmx.metrics.part.customizePane")) {
                    this.tabMenu.getItems().add((Object)this.itemCloseOthers);
                    this.tabMenu.getItems().add((Object)this.itemCloseLeft);
                    this.tabMenu.getItems().add((Object)this.itemCloseRight);
                    this.tabMenu.getItems().add((Object)this.itemCloseAll);
                    MEvent e = new MEvent();
                    e.put((Object)"menuId", (Object)this.domElement.getElementId());
                    this.es.sendEvent("check.menus.is.collect", e);
                    if (e.isOK()) {
                        this.tabMenu.getItems().add((Object)this.itemUnCollect);
                    } else {
                        this.tabMenu.getItems().add((Object)this.itemCollect);
                    }
                }
                if ("cms.tmx.app.ps.right".equals(this.domElement.getParent().getElementId()) && ("cms.tmx.file.dbf.part.monitorFilePart".equals(this.domElement.getElementId()) || "cms.tmx.file.order.part.scanFilePart".equals(this.domElement.getElementId()) || "cms.tmx.file.order.part.monitorFilePart".equals(this.domElement.getElementId()))) {
                    this.tabMenu.getItems().remove((Object)this.itemMutil);
                }
            });
            return t;
        }

        private void onItemMutil(ActionEvent event) {
            this.handleCmd("cms.tmx.app.cmd.multiOpen");
        }

        private void handleCmd(String id) {
            Command cmd = this.cs.getCommand(id);
            if (cmd == null) {
                return;
            }
            try {
                IEclipseContext ctxt = this.modelService.getTopLevelWindowFor((MUIElement)this.domElement).getContext();
                this.hs.executeHandler(new ParameterizedCommand(cmd, null), ctxt.getActiveLeaf());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        private void onItemDetach(ActionEvent event) {
            this.handleCmd("cms.tmx.app.cmd.detachpart");
        }

        private void handleOnCloseRequest(Event event) {
            logger.info("[" + this.domElement.getElementId() + "] click close button");
            if (((Boolean)this.closeCallback.call((Object)this)).booleanValue()) {
                event.consume();
                return;
            }
            if ("cms.tmx.app.ps.right".equals(this.domElement.getParent().getElementId())) {
                MEvent mEvent = new MEvent();
                mEvent.put((Object)"close_part", (Object)this.domElement);
                this.es.sendEvent("close.part", mEvent);
            }
        }

        void handleSelection() {
            if (this.initCallback != null) {
                this.tab.setContent((Node)this.initCallback.call((Object)this));
                this.initCallback = null;
            }
            if (WLayoutedWidgetImpl.OPTIMIZED_STACK_LAYOUT) {
                if (this.tab.getContent() instanceof Parent) {
                    this.domElement.getParent().setSelectedElement((MUIElement)this.domElement);
                    ((Parent)this.tab.getContent()).requestLayout();
                } else {
                    this.tab.getTabPane().requestLayout();
                }
            }
        }

        public void setInitCallback(WCallback<WStack.WStackItem<Object, Node>, Node> initCallback) {
            this.initCallback = initCallback;
        }

        public Tab getNativeItem() {
            return this.getWidget();
        }

        @Inject
        public void setLabel(@Named(value="localizedLabel") @Optional String label) {
            this.label = label;
            this.getWidget().setText(this.dirty ? "*" + StackItemImpl.notNull(label) : StackItemImpl.notNull(label));
        }

        @Inject
        public void setTooltip(@Named(value="localizedTooltip") @Optional String tooltip) {
            if (tooltip != null && !tooltip.isEmpty()) {
                this.getWidget().setTooltip(new Tooltip(tooltip));
            } else {
                this.getWidget().setTooltip(null);
            }
        }

        @Inject
        public void setCloseable(@Named(value="closeable") @Optional boolean closeable) {
            this.getWidget().setClosable(closeable);
        }

        @Inject
        public void setIcon(@Named(value="iconURI") @Optional String iconUri) {
            if (iconUri != null && !iconUri.isEmpty()) {
                EMFUri uri = new EMFUri(URI.createURI((String)iconUri));
                this.iconUri.set((Object)uri);
                this.getWidget().setGraphic(this.graphicsLoader.getGraphicsNode((org.eclipse.fx.core.URI)uri));
            } else {
                this.iconUri.set(null);
                this.getWidget().setGraphic(null);
            }
        }

        @Inject
        public void setDirty(@Named(value="dirty") @Optional boolean dirty) {
            this.dirty = dirty;
            this.getWidget().setText(dirty ? "*" + StackItemImpl.notNull(this.label) : StackItemImpl.notNull(this.label));
        }

        public void setOnCloseCallback(WCallback<WStack.WStackItem<Object, Node>, Boolean> callback) {
            this.closeCallback = callback;
        }

        private static String notNull(String s) {
            return s == null ? "" : s;
        }

        @PreDestroy
        public void dispose() {
            ObservableList listTab;
            if (this.tab.getTabPane() != null && (listTab = this.tab.getTabPane().getTabs()) != null) {
                listTab.remove(this.tab);
                if (this.domElement != null && this.domElement instanceof MCompositePart) {
                    Platform.runLater(() -> this.domElement.setToBeRendered(false));
                }
            }
            this.initCallback = null;
            this.closeCallback = null;
            this.graphicsLoader = null;
            this.tab.setOnCloseRequest(null);
            this.tab = null;
        }
    }

    private static class StackWidgetImpl
    extends WLayoutedWidgetImpl<Node, Node, MPartStack>
    implements WStack<Node, Object, Node> {
        WCallback<WStack.WStackItem<Object, Node>, Void> mouseSelectedItemCallback;
        WCallback<WStack.WStackItem<Object, Node>, Void> keySelectedItemCallback;
        WCallback<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull WDragSourceWidget.DragData, @NonNull Boolean> dragStartCallback;
        private WCallback<WMinMaxableWidget.WMinMaxState, Void> minMaxCallback;
        boolean inKeyTraversal;
        @Inject
        @NonNull DnDFeedbackService dndFeedback;
        @Inject
        @Optional
        @Nullable DnDService dndService;
        @Inject
        @NonNull ModelService modelService;
        @Inject
        GraphicsLoader graphicsLoader;
        private final @NonNull MPartStack domainElement;
        private BorderPane pane;
        private Label titleLabel;

        @Inject
        public StackWidgetImpl(@Named(value="fx.rendering.domElement") @NonNull MPartStack domainElement) {
            this.domainElement = domainElement;
        }

        protected Pane createStaticPane() {
            return new StackPane(){

                protected void layoutChildren() {
                    super.layoutChildren();
                }
            };
        }

        public void setMouseSelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> mouseSelectedItemCallback) {
            this.mouseSelectedItemCallback = mouseSelectedItemCallback;
        }

        public void setKeySelectedItemCallback(WCallback<WStack.WStackItem<Object, Node>, Void> keySelectedItemCallback) {
            this.keySelectedItemCallback = keySelectedItemCallback;
        }

        public TabPane getWidget() {
            return (TabPane)super.getWidget();
        }

        public int indexOf(WStack.WStackItem<Object, Node> item) {
            return this.getWidget().getTabs().indexOf(item.getNativeItem());
        }

        public int getItemCount() {
            return this.getWidget().getTabs().size();
        }

        public void setMinMaxCallback(WCallback<WMinMaxableWidget.WMinMaxState, Void> minMaxCallback) {
            this.minMaxCallback = minMaxCallback;
        }

        public void setMinMaxState(WMinMaxableWidget.WMinMaxState state) {
        }

        private void onMouseClicked(TabPane p, MouseEvent e) {
            if (e.getClickCount() > 1 && e.getButton().equals((Object)MouseButton.PRIMARY) && this.minMaxCallback == null) {
                return;
            }
        }

        protected TabPane createWidget() {
            Side v;
            DnDSupport dnd = new DnDSupport(param -> this.dragStartCallback, param -> this.getDropDroppedCallback(), this.dndFeedback, this.domainElement, this.dndService, this.modelService);
            final TabPane p = DndTabPaneFactory.createDndTabPane(s -> {
                s.setStartFunction(arg_0 -> ((DnDSupport)dnd).handleDragStart(arg_0));
                s.setDropConsumer(arg_0 -> ((DnDSupport)dnd).handleDropped(arg_0));
                s.setFeedbackConsumer(arg_0 -> ((DnDSupport)dnd).handleFeedback(arg_0));
                s.setDragFinishedConsumer(arg_0 -> ((DnDSupport)dnd).handleFinished(arg_0));
                s.setClipboardDataFunction(arg_0 -> ((DnDSupport)dnd).clipboardDataFunction(arg_0));
            }, (boolean)DnDSupport.DETACHABLE_DRAG);
            p.getTabs().addListener((ListChangeListener)new ListChangeListener<Tab>(){

                public void onChanged(ListChangeListener.Change<? extends Tab> c) {
                    while (c.next()) {
                        if (c.getAddedSize() != 1) continue;
                        p.getSelectionModel().select((Object)((Tab)c.getAddedSubList().get(0)));
                    }
                }
            });
            String location = (String)this.domainElement.getPersistedState().get("fx.stack.tabslocation");
            if (location != null && (v = Side.valueOf((String)location)) != null) {
                p.setSide(v);
            }
            p.setOnMouseClicked(e -> this.onMouseClicked(p, (MouseEvent)e));
            p.setMinHeight(50.0);
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_allTabs")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
            }
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_unavailable")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
            }
            if (this.domainElement.getTags().contains("fx_tab_closing_policy_selectedTab")) {
                p.setTabClosingPolicy(TabPane.TabClosingPolicy.SELECTED_TAB);
            }
            p.addEventFilter(KeyEvent.KEY_PRESSED, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    inKeyTraversal = true;
                }
            });
            p.addEventFilter(KeyEvent.KEY_RELEASED, (EventHandler)new EventHandler<KeyEvent>(){

                public void handle(KeyEvent event) {
                    inKeyTraversal = false;
                }
            });
            p.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<Tab>(){
                boolean inUpdate;

                public void changed(ObservableValue<? extends Tab> observable, Tab oldValue, Tab newValue) {
                    if (titleLabel != null) {
                        titleLabel.textProperty().unbind();
                        titleLabel.graphicProperty().unbind();
                        titleLabel.setGraphic(null);
                        titleLabel.setText(null);
                        if (newValue != null) {
                            StackItemImpl d = (StackItemImpl)newValue.getUserData();
                            titleLabel.graphicProperty().bind((ObservableValue)FXBindings.map((ObservableValue)d.iconUri, u -> graphicsLoader.getGraphicsNode(u)));
                            titleLabel.textProperty().bind((ObservableValue)newValue.textProperty());
                        }
                    }
                    if (newValue == null || this.getWidgetState() != WWidget.WidgetState.CREATED && this.getWidgetState() != WWidget.WidgetState.IN_SETUP) {
                        return;
                    }
                    final StackItemImpl w = (StackItemImpl)newValue.getUserData();
                    w.handleSelection();
                    final WCallback<WStack.WStackItem<Object, Node>, Void> cb = !inKeyTraversal ? mouseSelectedItemCallback : keySelectedItemCallback;
                    if (cb != null && w.tab != null) {
                        if (w.tab.getContent() != null && !w.tab.getContent().isVisible()) {
                            w.tab.getContent().visibleProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                                public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                                    w.tab.getContent().visibleProperty().removeListener((ChangeListener)this);
                                    if (newValue.booleanValue()) {
                                        cb.call((Object)w);
                                    }
                                }
                            });
                        } else if (w.tab.getContent() == null || w.tab.getContent().getScene() != null) {
                            if (!this.inUpdate) {
                                this.inUpdate = true;
                                Platform.runLater((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        cb.call((Object)w);
                                        inUpdate = false;
                                    }
                                });
                            } else {
                                logger.debug("An endless activation update has been blocked!");
                            }
                        } else {
                            cb.call((Object)w);
                        }
                    }
                }
            });
            return p;
        }

        public BorderPane getWidgetNode() {
            if (this.pane == null) {
                this.pane = new BorderPane();
                if (this.domainElement.getTags().contains("showTopTrimArea")) {
                    HBox box = new HBox();
                    box.getStyleClass().add((Object)"tool-bar");
                    this.titleLabel = new Label();
                    box.getChildren().add((Object)this.titleLabel);
                    this.pane.setTop((Node)box);
                }
                this.pane.setCenter((Node)this.getWidget());
            }
            return this.pane;
        }

        public Class<? extends WStack.WStackItem<Object, Node>> getStackItemClass() {
            return StackItemImpl.class;
        }

        public void addItem(WStack.WStackItem<Object, Node> item) {
            this.addItems(Collections.singletonList(item));
        }

        public void addItems(List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            this.getWidget().getTabs().addAll(this.extractTabs(items));
        }

        public void addItems(int index, List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> items) {
            if (index >= this.getWidget().getTabs().size()) {
                this.addItems(items);
            } else {
                this.getWidget().getTabs().addAll(index, this.extractTabs(items));
            }
        }

        private final List<Tab> extractTabs(List<WStack.WStackItem<Object, Node>> items) {
            ArrayList<Tab> tabs = new ArrayList<Tab>(items.size());
            for (WStack.WStackItem<Object, Node> t : items) {
                tabs.add((Tab)t.getNativeItem());
            }
            return tabs;
        }

        public void selectItem(int idx) {
            this.getWidget().getSelectionModel().select(idx);
        }

        public List<// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull WStack.WStackItem<Object, Node>> getItems() {
            ArrayList<WStack.WStackItem> rv = new ArrayList<WStack.WStackItem>();
            for (Tab t : this.getWidget().getTabs()) {
                WStack.WStackItem i = (WStack.WStackItem)t.getUserData();
                if (i == null) continue;
                rv.add(i);
            }
            return Collections.unmodifiableList(rv);
        }

        public void removeItems(List<WStack.WStackItem<Object, Node>> items) {
            ArrayList<Object> l = new ArrayList<Object>();
            for (WStack.WStackItem<Object, Node> i : items) {
                l.add(i.getNativeItem());
            }
            this.getWidget().getTabs().removeAll(l);
            if (this.getWidget().getTabs().isEmpty() && this.minMaxCallback != null) {
                this.minMaxCallback.call((Object)WMinMaxableWidget.WMinMaxState.RESTORE);
            }
        }

        public void setDragStartCallback(@NonNull WCallback<// Could not load outer class - annotation placement on inner may be incorrect
         @NonNull WDragSourceWidget.DragData, @NonNull Boolean> dragStackCallback) {
            this.dragStartCallback = dragStackCallback;
        }
    }
}

