/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.parts;

import cms.tmx.app.func.SearchConverter;
import cms.tmx.app.func.SearchSuggest;
import cms.tmx.app.func.SearchSuggestion;
import cms.tmx.app.models.MSceneWrapper;
import cms.tmx.app.models.MWindowImp;
import cms.tmx.app.parts.SettingDialog;
import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.MxWebDialog;
import cms.tmx.control.search.AutoCompletion;
import cms.tmx.control.search.Search;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MConfService;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MProps;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.jxb.WebBrowserPart;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.awt.AWTException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.css.PseudoClass;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.ECommandService;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class TopPart
extends MxPart {
    private static final Logger logger = LogManager.getLogger(TopPart.class);
    @FXML
    private Button btnMax;
    @FXML
    private MenuButton menuSet;
    @FXML
    private MenuItem itemUpdatePwd;
    @Inject
    private ECommandService ecs;
    @Inject
    private EModelService modelService;
    @Inject
    private MApplication app;
    @Inject
    private EHandlerService ehs;
    @Inject
    private MObjFactory of;
    @Inject
    private DialogFactory df;
    @Inject
    protected MEventService es;
    @Inject
    private MSceneWrapper sw;
    @Inject
    private MConfService cs;
    @FXML
    private HBox trimTop;
    private static final PseudoClass pcMax = PseudoClass.getPseudoClass((String)"max");
    @Inject
    private HBox box;
    @FXML
    private Button btnCustomPane;
    @Inject
    private static MWindow window;
    @FXML
    private TextField txtSearch;
    private Gson gson = new Gson();
    private SearchConverter secCvt = new SearchConverter();
    protected SearchSuggestion spCode = new SearchSuggestion();
    private Map<String, SearchSuggest> map = new HashMap<String, SearchSuggest>();
    private MProps props;
    @Inject
    private Stage stage;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    @Inject
    private EPartService ps;

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.resoreTable();
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            this.box.getChildren().add((Object)this.content);
        }
        catch (IOException e) {
            logger.error((Object)e, (Throwable)e);
        }
        this.sw.setMoveControl((Node)this.content);
        this.sw.controller.max.addListener(ob -> {
            if (this.sw.controller.max.get()) {
                this.btnMax.pseudoClassStateChanged(pcMax, true);
            } else {
                this.btnMax.pseudoClassStateChanged(pcMax, false);
            }
        });
        this.props = this.cs.getUserProps();
        this.updatSkin(this.props.get("app_theme"));
        this.initClientType();
        this.es.subscribe("check", event -> {
            if (event.isOK()) {
                this.btnCustomPane.setVisible(true);
                this.btnCustomPane.setDisable(false);
            } else {
                this.btnCustomPane.setVisible(false);
                this.btnCustomPane.setDisable(true);
            }
        });
        this.initSearch();
    }

    private void initClientType() {
        int type = this.eCore.getInt("client.type");
        if (type == 0) {
            FxUtils.makePC((Node)this.trimTop, (String)"pro", (boolean)false);
        } else if (1 == type || 2 == type) {
            FxUtils.makePC((Node)this.trimTop, (String)"pro", (boolean)true);
        }
    }

    @FXML
    public void initialize() {
        this.initMenu();
    }

    private void initMenu() {
        int type = this.eCore.getInt("client.type");
        if (1 == type) {
            this.menuSet.getItems().remove((Object)this.itemUpdatePwd);
        }
    }

    @FXML
    private void updatePwd() {
        MEvent event = new MEvent();
        String methodName = "updatePwd";
        event.put((Object)"MethodName", (Object)methodName);
        this.es.sendEvent("dialogEvent", event);
    }

    @FXML
    private void version() {
        MEvent event = new MEvent();
        String methodName = "version";
        event.put((Object)"MethodName", (Object)methodName);
        this.es.sendEvent("dialogEvent", event);
    }

    @FXML
    private void feedBack() {
        MEvent event = new MEvent();
        String methodName = "feedBack";
        event.put((Object)"MethodName", (Object)methodName);
        this.es.sendEvent("dialogEvent", event);
    }

    @FXML
    private void useManual() {
        InputStream fis = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("help/help.pdf");
        try {
            ExcelUtils.saveFile((InputStream)fis, (String)"\u4ea4\u6613\u5927\u5e08\u5168\u8d44\u4ea7\u7ba1\u7406\u5e73\u53f0\u64cd\u4f5c\u624b\u518c.pdf");
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
        catch (MException mException) {
            logger.error("\u53d6\u6d88\u4e0b\u8f7d");
        }
    }

    @FXML
    private void onClose() {
        this.stage.fireEvent((Event)new WindowEvent((Window)this.stage, WindowEvent.WINDOW_CLOSE_REQUEST));
    }

    @FXML
    private void onMax() {
        this.sw.maximise();
    }

    @FXML
    private void onMin() {
        this.sw.minimise();
    }

    @FXML
    private void onSettings() {
        SettingDialog sd = (SettingDialog)((Object)this.of.create(SettingDialog.class));
        sd.setUrl("/setting-global");
        MxWebDialog dialog = this.df.createWeb((WebBrowserPart)sd, "\u7528\u6237\u8bbe\u7f6e", 680, 550);
        dialog.launch();
        dialog.disposeBrowser();
        this.es.sendEvent("settingsDialogClose", null);
    }

    @FXML
    private void lockSystem() {
        this.es.postEvent("manual.lock.system", null);
    }

    @FXML
    private void defaultTemp() throws AWTException {
        Command command = this.ecs.getCommand("cms.tmx.app.cmd.restoreper");
        if (!command.isDefined()) {
            return;
        }
        ParameterizedCommand pc = new ParameterizedCommand(command, null);
        this.ehs.executeHandler(pc);
    }

    @FXML
    private void addCustomPane() {
        String id = "cms.tmx.metrics.part.CustomPane";
        MPart findPart = this.ps.findPart(id);
        MEvent event = new MEvent();
        event.putStr("part_name", (Object)"\u81ea\u5b9a\u4e49\u9762\u677f");
        event.putStr("id", (Object)id);
        if (findPart == null) {
            return;
        }
        if (!findPart.isToBeRendered()) {
            this.es.sendEvent("ui.navigate", event);
        } else {
            this.es.sendEvent("ui.navigate.multi_open_custom", event);
        }
    }

    @FXML
    private void updateWhiteSkin() {
        this.updatSkin("white-theme");
        MEvent mEvent = new MEvent();
        mEvent.setObj((Object)"white");
        this.eCore.put((Object)"web-theme", (Object)"white");
        this.es.postEvent("change.style", mEvent);
    }

    @FXML
    private void updateBlueSkin() {
        this.updatSkin("blue-theme");
        MEvent mEvent = new MEvent();
        mEvent.setObj((Object)"blue");
        this.eCore.put((Object)"web-theme", (Object)"blue");
        this.es.postEvent("change.style", mEvent);
    }

    private void updatSkin(String theme) {
        MWindowImp cast = (MWindowImp)((Object)MWindowImp.class.cast(window.getWidget()));
        AnchorPane root = cast.getWrapper().getRoot();
        root.getStyleClass().clear();
        root.getStyleClass().add((Object)"root");
        root.getStyleClass().add((Object)(theme == null || theme.isEmpty() ? "blue-theme" : theme));
        this.props.setValue("app_theme", (Object)(theme == null || theme.isEmpty() ? "blue-theme" : theme));
        this.updateOthersWindow();
    }

    private void updateOthersWindow() {
        MPerspective initPerUser = (MPerspective)this.modelService.findElements((MUIElement)this.app, "cms.tmx.per.init." + this.eCore.getStr("user_id") + "." + this.eCore.getStr("post_id"), MPerspective.class, null).get(0);
        List list = initPerUser.getWindows();
        for (MWindow mWindow : list) {
            if ("cms.tmx.twin.main".equals(mWindow.getElementId()) || !(mWindow.getWidget() instanceof MWindowImp)) continue;
            MWindowImp cast = (MWindowImp)((Object)MWindowImp.class.cast(mWindow.getWidget()));
            Pane root = cast.getWidgetNode();
            root.getStyleClass().clear();
            root.getStyleClass().add((Object)"root");
            root.getStyleClass().add((Object)this.props.get("app_theme"));
        }
    }

    private void initSearch() {
        this.txtSearch.setVisible(true);
        this.txtSearch.setDisable(false);
        String json = this.eCore.getStr("user_func_list");
        List list = (List)this.gson.fromJson(json, new TypeToken<List<SearchSuggest>>(){}.getType());
        for (SearchSuggest func : list) {
            if (func.getParentName().isEmpty()) {
                this.map.put(func.getName(), func);
                continue;
            }
            this.map.put(String.valueOf(func.getParentName()) + " " + func.getName(), func);
        }
        this.spCode.clearSuggestions();
        this.spCode.addPossibleSuggestions(list);
        AutoCompletion bindAutoCompletion = Search.bindAutoCompletion((TextField)this.txtSearch, (Callback)this.spCode, (StringConverter)this.secCvt);
        bindAutoCompletion.setBottom(true);
        bindAutoCompletion.changedProperty().addListener((ob, oldV, newV) -> {
            SearchSuggest suggest = null;
            Object obj = this.txtSearch.getUserData();
            if (obj instanceof SearchSuggest) {
                suggest = (SearchSuggest)SearchSuggest.class.cast(obj);
            }
            if (suggest != null) {
                MPart findPart;
                MEvent event = new MEvent();
                event.put((Object)"id", (Object)suggest.getPartId());
                event.put((Object)"type", (Object)suggest.getType());
                event.put((Object)"part_name", (Object)(suggest.getParentName().isEmpty() ? suggest.getName() : suggest.getParentName()));
                this.es.sendEvent("ui.navigate", event);
                if (!suggest.getControlId().isEmpty() && (findPart = this.ps.findPart(suggest.getControlId())) != null) {
                    Platform.runLater(() -> this.ps.activate(findPart));
                }
            }
        });
    }
}

