/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.parts;

import cms.tmx.app.models.IIndexInfo;
import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.css.PseudoClass;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class BottomPart
extends MxPart {
    private static final String USER_NAME = "user_name";
    private static final String POST_NAME = "post_name";
    private static final String PARTY_NAME = "party_name";
    public static final String CSS_BREAK = "break";
    public static final String CSS_HIDE = "hide";
    private static final String CONNECT_BREAK = "\u540e\u53f0\u670d\u52a1\u8fde\u63a5\u4e2d\u65ad";
    private static final String CONNECTED = "\u540e\u53f0\u670d\u52a1\u5df2\u8fde\u63a5";
    private static final String CLOSE = "\u9690\u85cf\u83dc\u5355\u5bfc\u822a";
    private static final String SHOW = "\u663e\u793a\u83dc\u5355\u5bfc\u822a";
    private static final String INIT_MENU = "cms.tmx.app.psc.left";
    private static final String MAIN_MENU = "cms.tmx.app.psc.main.list";
    private static final String INIT_PER = "cms.tmx.per.init";
    private static final String NUM_FORMATTER = "%1$,.2f";
    @FXML
    private Label lbTip;
    @FXML
    private Label lbConn;
    @FXML
    private Label lbUser;
    @FXML
    private Label lbPost;
    @FXML
    private Label lbParty;
    @FXML
    private Label lbPriceSH;
    @FXML
    private Label lbRiseSH;
    @FXML
    private Label lbDealSH;
    @FXML
    private Label lbPriceSZ;
    @FXML
    private Label lbRiseSZ;
    @FXML
    private Label lbDealSZ;
    @FXML
    private Label lbPrice300;
    @FXML
    private Label lbRise300;
    @FXML
    private Label lbDeal300;
    @FXML
    private Label lbPriceSM;
    @FXML
    private Label lbRiseSM;
    @FXML
    private Label lbDealSM;
    @FXML
    private Label lbPriceCyb;
    @FXML
    private Label lbRiseCyb;
    @FXML
    private Label lbDealCyb;
    @FXML
    private Label lbPriceFund;
    @FXML
    private Label lbRiseFund;
    @FXML
    private Label lbDealFund;
    @FXML
    private Label lbHide;
    @FXML
    private HBox hboxSH;
    @FXML
    private HBox hboxSZ;
    @FXML
    private HBox hbox300;
    @FXML
    private HBox hboxCyb;
    @FXML
    private HBox hboxFund;
    @FXML
    private HBox hbox1;
    @FXML
    private HBox hbox2;
    @FXML
    private Label lbTime;
    @Inject
    private HBox box;
    @Inject
    private MEventService es;
    @Inject
    private ScheduledExecutorService ses;
    @Inject
    private EModelService eService;
    @Inject
    private MApplication app;
    @Inject
    private MWindow window;
    private Tooltip tip = new Tooltip();
    private Tooltip tipShow = new Tooltip();
    private Tooltip tipParty = new Tooltip();
    private Tooltip tipPost = new Tooltip();
    private Tooltip tipUser = new Tooltip();
    private boolean flag = true;
    private static final Logger logger = Logger.getLogger(BottomPart.class);
    static PseudoClass pcRise = PseudoClass.getPseudoClass((String)"rise");
    static PseudoClass pcFall = PseudoClass.getPseudoClass((String)"fall");
    private final String SHRINK = "shrink";
    private int times = 0;
    private MUIElement initElement;
    private MUIElement mainElement;
    private static final String MARKET_CLOSE = "\u6781\u901f\u4ea4\u6613\u901a\u9053\u6b63\u5728\u51c6\u5907\u4e2d\uff0c\u6682\u65f6\u65e0\u6cd5\u4e0b\u8fbe\u59d4\u6258\uff0c\u8bf7\u7a0d\u540e\uff01";
    private static final String MARKET_OPEN = "\u6781\u901f\u4ea4\u6613\u901a\u9053\u5df2\u7ecf\u51c6\u5907\u5b8c\u6210\uff0c\u53ef\u4ee5\u4e0b\u8fbe\u59d4\u6258";
    private final double animationTime = 0.5;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;

    @PostConstruct
    public void init() {
        try {
            this.loadFXML();
            this.box.getChildren().add((Object)this.content);
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
        }
        catch (IOException e) {
            logger.error((Object)e);
        }
        this.es.subscribe("server.hb.ok", event -> this.checkConn(true));
        this.es.subscribe("server.hb.fail", event -> this.checkConn(false));
        this.es.subscribe("stage.after.login", event -> this.setUser());
        this.es.subscribe("index.market", event -> this.setIndex(event));
        this.es.subscribe("shrink", event -> this.initElement());
        this.es.postEvent("sub.index.market", null);
        this.ses.scheduleWithFixedDelay(() -> Platform.runLater(() -> {
            try {
                if (this.times % 2 == 1) {
                    this.showHBox1();
                } else {
                    this.showHBox2();
                }
            }
            catch (InterruptedException interruptedException) {
                logger.error((Object)("BottomPart InterruptedException" + Thread.currentThread()));
                Thread.currentThread().interrupt();
            }
            ++this.times;
        }), 3000L, 3000L, TimeUnit.MILLISECONDS);
        this.initElement();
        this.menuNavigation();
        this.addWidthListener();
        BottomPart.hackTooltipStartTiming();
        int type = this.eCore.getInt("client.type");
        if (type == 0 || 2 == type) {
            this.lbTip.setVisible(false);
        } else if (1 == type) {
            this.lbTip.setVisible(true);
            Tooltip tooltip = new Tooltip();
            this.lbTip.setTooltip(tooltip);
            tooltip.setText(MARKET_CLOSE);
            FxUtils.makePC((Node)this.lbTip, (String)CSS_BREAK, (boolean)true);
            this.es.subscribe("marketStatus", event -> {
                boolean bool = event.getBool("market_status");
                if (bool) {
                    Platform.runLater(() -> {
                        tooltip.setText(MARKET_OPEN);
                        FxUtils.makePC((Node)this.lbTip, (String)CSS_BREAK, (boolean)false);
                    });
                } else {
                    Platform.runLater(() -> {
                        tooltip.setText(MARKET_CLOSE);
                        FxUtils.makePC((Node)this.lbTip, (String)CSS_BREAK, (boolean)true);
                    });
                }
            });
        }
    }

    private static void hackTooltipStartTiming() {
        try {
            Tooltip tooltip = new Tooltip();
            Field fieldBehavior = tooltip.getClass().getDeclaredField("BEHAVIOR");
            fieldBehavior.setAccessible(true);
            Object objBehavior = fieldBehavior.get(tooltip);
            Field fieldTimer = objBehavior.getClass().getDeclaredField("activationTimer");
            fieldTimer.setAccessible(true);
            Timeline objTimer = (Timeline)fieldTimer.get(objBehavior);
            Field fieldHideTimer = objBehavior.getClass().getDeclaredField("hideTimer");
            fieldHideTimer.setAccessible(true);
            Timeline hideTimer = (Timeline)fieldHideTimer.get(objBehavior);
            objTimer.getKeyFrames().clear();
            objTimer.getKeyFrames().add((Object)new KeyFrame(new Duration(100.0), new KeyValue[0]));
            hideTimer.getKeyFrames().clear();
            hideTimer.getKeyFrames().add((Object)new KeyFrame(new Duration(20000.0), new KeyValue[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initElement() {
        this.tipShow.setText(CLOSE);
        this.lbHide.setTooltip(this.tipShow);
        this.initElement = this.eService.find(INIT_MENU, (MUIElement)this.app);
        this.mainElement = this.eService.find(MAIN_MENU, (MUIElement)this.app);
    }

    private void menuNavigation() {
        this.lbHide.setOnMouseClicked(event -> {
            MPerspective mPerspective = this.eService.getActivePerspective(this.window);
            if (mPerspective.getElementId().contains(INIT_PER)) {
                this.initElement.setVisible(!this.initElement.isVisible());
                FxUtils.makePC((Node)this.lbHide, (String)CSS_HIDE, (!this.initElement.isVisible() ? 1 : 0) != 0);
                this.tipShow.setText(this.initElement.isVisible() ? CLOSE : SHOW);
            } else {
                this.mainElement.setVisible(!this.mainElement.isVisible());
                FxUtils.makePC((Node)this.lbHide, (String)CSS_HIDE, (!this.mainElement.isVisible() ? 1 : 0) != 0);
                this.tipShow.setText(this.mainElement.isVisible() ? CLOSE : SHOW);
            }
        });
    }

    private void showHBox1() throws InterruptedException {
        KeyValue initKeyValue = new KeyValue((WritableValue)this.hbox2.translateYProperty(), (Object)-10);
        KeyFrame initFrame = new KeyFrame(Duration.ZERO, new KeyValue[]{initKeyValue});
        KeyValue endKeyValue = new KeyValue((WritableValue)this.hbox2.translateYProperty(), (Object)this.hbox2.getHeight());
        KeyFrame endFrame = new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{endKeyValue});
        Timeline timeline1 = new Timeline(new KeyFrame[]{initFrame, endFrame});
        timeline1.setCycleCount(1);
        timeline1.play();
        KeyValue initKeyValue2 = new KeyValue((WritableValue)this.hbox1.translateYProperty(), (Object)(-1.0 * this.hbox1.getHeight() / 3.0));
        KeyFrame initFrame2 = new KeyFrame(Duration.ZERO, new KeyValue[]{initKeyValue2});
        KeyValue endKeyValue2 = new KeyValue((WritableValue)this.hbox1.translateYProperty(), (Object)10);
        KeyFrame endFrame2 = new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{endKeyValue2});
        Timeline timeline2 = new Timeline(new KeyFrame[]{initFrame2, endFrame2});
        timeline2.setCycleCount(1);
        timeline2.setDelay(Duration.seconds((double)0.2));
        timeline2.play();
    }

    private void showHBox2() throws InterruptedException {
        KeyValue initKeyValue = new KeyValue((WritableValue)this.hbox1.translateYProperty(), (Object)10);
        KeyFrame initFrame = new KeyFrame(Duration.ZERO, new KeyValue[]{initKeyValue});
        KeyValue endKeyValue = new KeyValue((WritableValue)this.hbox1.translateYProperty(), (Object)(2.0 * this.hbox1.getHeight()));
        KeyFrame endFrame = new KeyFrame(Duration.seconds((double)0.5), new KeyValue[]{endKeyValue});
        Timeline timeline1 = new Timeline(new KeyFrame[]{initFrame, endFrame});
        timeline1.setCycleCount(1);
        timeline1.play();
        this.hbox2.setVisible(true);
        KeyValue initKeyValue2 = new KeyValue((WritableValue)this.hbox2.translateYProperty(), (Object)(-1.0 * this.hbox2.getHeight()));
        KeyFrame initFrame2 = new KeyFrame(Duration.ZERO, new KeyValue[]{initKeyValue2});
        KeyValue endKeyValue2 = new KeyValue((WritableValue)this.hbox2.translateYProperty(), (Object)-10);
        KeyFrame endFrame2 = new KeyFrame(Duration.seconds((double)0.25), new KeyValue[]{endKeyValue2});
        Timeline timeline2 = new Timeline(new KeyFrame[]{initFrame2, endFrame2});
        timeline2.setCycleCount(1);
        timeline2.setDelay(Duration.seconds((double)0.2));
        timeline2.play();
    }

    private void setCSSRise(HBox hbox, double d) {
        hbox.pseudoClassStateChanged(pcRise, false);
        hbox.pseudoClassStateChanged(pcFall, false);
        if (d > 0.0) {
            hbox.pseudoClassStateChanged(pcRise, true);
        } else {
            hbox.pseudoClassStateChanged(pcFall, true);
        }
    }

    public void setIndex(MEvent event) {
        Platform.runLater(() -> {
            IIndexInfo info = (IIndexInfo)event.getObj(IIndexInfo.class);
            if (info.getCode().equals("999999")) {
                this.lbPriceSH.setText(String.format(NUM_FORMATTER, info.getPrice()));
                this.lbRiseSH.setText(String.format(NUM_FORMATTER, info.getRise()));
                this.lbDealSH.setText(String.format("%1$,.2f\u4ebf", info.getDeal()));
                this.setCSSRise(this.hboxSH, info.getRise());
            }
            if (info.getCode().equals("999990")) {
                this.lbPriceFund.setText(String.format(NUM_FORMATTER, info.getPrice()));
                this.lbRiseFund.setText(String.format(NUM_FORMATTER, info.getRise()));
                this.lbDealFund.setText(String.format("%1$,.2f\u4ebf", info.getDeal()));
                this.setCSSRise(this.hboxFund, info.getRise());
            }
            if (info.getCode().equals("000300")) {
                this.lbPrice300.setText(String.format(NUM_FORMATTER, info.getPrice()));
                this.lbRise300.setText(String.format(NUM_FORMATTER, info.getRise()));
                this.lbDeal300.setText(String.format("%1$,.2f\u4ebf", info.getDeal()));
                this.setCSSRise(this.hbox300, info.getRise());
            }
            if (info.getCode().equals("399006")) {
                this.lbPriceCyb.setText(String.format(NUM_FORMATTER, info.getPrice()));
                this.lbRiseCyb.setText(String.format(NUM_FORMATTER, info.getRise()));
                this.setCSSRise(this.hboxCyb, info.getRise());
            }
            if (info.getCode().equals("399001")) {
                this.lbPriceSZ.setText(String.format(NUM_FORMATTER, info.getPrice()));
                this.lbRiseSZ.setText(String.format(NUM_FORMATTER, info.getRise()));
                this.setCSSRise(this.hboxSZ, info.getRise());
            }
            if (info.getCode().equals("399101")) {
                this.lbDealSM.setText(String.format("%1$,.2f\u4ebf", info.getDeal()));
            }
            if (info.getCode().equals("399102")) {
                this.lbDealCyb.setText(String.format("%1$,.2f\u4ebf", info.getDeal()));
            }
            if (info.getCode().equals("399106")) {
                this.lbDealSZ.setText(String.format("%1$,.2f\u4ebf", info.getDeal()));
            }
        });
    }

    public void setUser() {
        Platform.runLater(() -> {
            this.lbUser.setText(this.eCore.getStr(USER_NAME));
            this.lbPost.setText(this.eCore.getStr(POST_NAME).toString());
            this.lbParty.setText(this.eCore.getStr(PARTY_NAME).toString());
            this.tipParty.setText(this.lbParty.getText());
            this.tipPost.setText(this.lbPost.getText());
            this.tipUser.setText(this.lbUser.getText());
            this.lbUser.setTooltip(this.tipUser);
            this.lbPost.setTooltip(this.tipPost);
            this.lbParty.setTooltip(this.tipParty);
        });
    }

    @FXML
    public void initialize() {
        this.ses.scheduleAtFixedRate(() -> Platform.runLater(() -> this.lbTime.setText(this.getDateTime())), 0L, 1000L, TimeUnit.MILLISECONDS);
        this.tip.setText(CONNECTED);
        this.lbConn.setTooltip(this.tip);
    }

    private String getDateTime() {
        LocalDateTime cdt = LocalDateTime.now();
        return cdt.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    private synchronized void checkConn(boolean bool) {
        if (this.flag != bool) {
            FxUtils.makePC((Node)this.lbConn, (String)CSS_BREAK, (boolean)this.flag);
            this.tip.setText(bool ? CONNECTED : CONNECT_BREAK);
            this.flag = bool;
        }
    }

    private void addWidthListener() {
        this.hbox1.widthProperty().addListener((oldValue, observaable, newValue) -> {
            if (newValue.intValue() > 450 && newValue.intValue() < 650) {
                this.hbox1.getChildren().remove((Object)this.hboxFund);
                if (!this.hbox1.getChildren().contains((Object)this.hboxSZ)) {
                    this.hbox1.getChildren().add((Object)this.hboxSZ);
                }
            } else if (newValue.intValue() > 200 && newValue.intValue() < 450) {
                this.hbox1.getChildren().remove((Object)this.hboxSZ);
                if (!this.hbox1.getChildren().contains((Object)this.hboxSH)) {
                    this.hbox1.getChildren().add((Object)this.hboxSH);
                }
            } else if (newValue.intValue() < 200) {
                this.hbox1.getChildren().remove((Object)this.hboxSH);
            } else if (newValue.intValue() > 650) {
                if (!this.hbox1.getChildren().contains((Object)this.hboxFund)) {
                    this.hbox1.getChildren().add((Object)this.hboxFund);
                }
                if (!this.hbox1.getChildren().contains((Object)this.hboxSH)) {
                    this.hbox1.getChildren().add((Object)this.hboxSH);
                }
                if (!this.hbox1.getChildren().contains((Object)this.hboxSZ)) {
                    this.hbox1.getChildren().add((Object)this.hboxSZ);
                }
            }
        });
        this.hbox2.widthProperty().addListener((oldValue, observaable, newValue) -> {
            if (newValue.intValue() > 450 && newValue.intValue() < 650) {
                this.hbox2.getChildren().remove((Object)this.hbox300);
                if (!this.hbox2.getChildren().contains((Object)this.hboxCyb)) {
                    this.hbox2.getChildren().add((Object)this.hboxCyb);
                }
            } else if (newValue.intValue() > 200 && newValue.intValue() < 450) {
                this.hbox2.getChildren().remove((Object)this.hboxCyb);
            } else if (newValue.intValue() > 650) {
                if (!this.hbox2.getChildren().contains((Object)this.hbox300)) {
                    this.hbox2.getChildren().add((Object)this.hbox300);
                }
                if (!this.hbox2.getChildren().contains((Object)this.hboxCyb)) {
                    this.hbox2.getChildren().add((Object)this.hboxCyb);
                }
            }
        });
    }
}

