/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.models;

import cms.tmx.app.models.MSceneWrapper;
import java.util.List;
import javafx.stage.Stage;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.ui.workbench.fx.key.KeyBindingDispatcher;
import org.eclipse.fx.ui.workbench.renderers.fx.DefWindowRenderer;
import org.eclipse.jdt.annotation.NonNull;

public class MWindowImp
extends DefWindowRenderer.WWindowImpl {
    private static final String BORDER_LESS_WINDOW = "borderless_window";
    private static final String BORDER_LESS_MAX = "borderless_max";
    private static final String MIN_SIZE = "min_size";
    private MWindow win;
    private MSceneWrapper wrapper;

    public MSceneWrapper getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(MSceneWrapper wrapper) {
        this.wrapper = wrapper;
    }

    @Inject
    public MWindowImp(@Named(value="fx.rendering.domElement") @NonNull MWindow mWindow, @Optional KeyBindingDispatcher dispatcher, MApplication application, @Log Logger logger) {
        super(mWindow, dispatcher, application, logger);
        this.win = mWindow;
    }

    protected Stage createWidget() {
        Stage stage = super.createWidget();
        if (this.win.getTags().contains(BORDER_LESS_WINDOW)) {
            this.makeBorkerLess(stage);
        }
        if (this.win.getTags().contains(MIN_SIZE)) {
            stage.setMinHeight(600.0);
            stage.setMinWidth(800.0);
        }
        return stage;
    }

    private void makeBorkerLess(Stage stage) {
        this.wrapper = new MSceneWrapper(stage);
        this.win.getContext().set(MSceneWrapper.class, (Object)this.wrapper);
    }

    @Inject
    public void setTags(@Optional @Named(value="tags") List<String> tags) {
        if (tags.contains(BORDER_LESS_WINDOW) && tags.contains(BORDER_LESS_MAX)) {
            this.wrapper.getStage().setOnShown(event -> this.wrapper.controller.maximise());
        }
    }
}

