/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.models;

import cms.tmx.app.models.Delta;
import cms.tmx.app.models.MSceneCtrl;
import java.io.IOException;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import javafx.stage.StageStyle;

public class MSceneWrapper {
    public MSceneCtrl controller;
    private AnchorPane root;
    private Stage primaryStage;
    private static final String MSCENE_ROOT = "mscene_root";

    public AnchorPane getRoot() {
        return this.root;
    }

    public void setRoot(AnchorPane root) {
        this.root = root;
    }

    public Stage getStage() {
        return this.primaryStage;
    }

    public MSceneWrapper(Stage stage) {
        FXMLLoader loader = new FXMLLoader();
        loader.setLocation(this.getClass().getResource("Borderless.fxml"));
        try {
            this.root = (AnchorPane)loader.load();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.controller = (MSceneCtrl)loader.getController();
        this.controller.setMainApp(stage);
        this.setContent(stage.getScene().getRoot());
        stage.getScene().setRoot((Parent)this.root);
        this.root.setId(MSCENE_ROOT);
        stage.initStyle(StageStyle.UNDECORATED);
        this.primaryStage = stage;
    }

    public void setContent(Parent content) {
        this.root.getChildren().remove(0);
        this.root.getChildren().add(0, (Object)content);
        AnchorPane.setLeftAnchor((Node)content, (Double)0.0);
        AnchorPane.setTopAnchor((Node)content, (Double)0.0);
        AnchorPane.setRightAnchor((Node)content, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)content, (Double)0.0);
    }

    public void setMoveControl(Node node) {
        this.controller.setMoveControl(node);
    }

    public void maximise() {
        this.controller.maximise();
    }

    public void minimise() {
        this.controller.minimise();
    }

    public void setResizable(Boolean bool) {
        this.controller.setResizable(bool);
    }

    public Boolean isMaximised() {
        return this.controller.maximised;
    }

    public Delta getWindowedSize() {
        if (this.controller.prevSize.x == null) {
            this.controller.prevSize.x = this.primaryStage.getWidth();
        }
        if (this.controller.prevSize.y == null) {
            this.controller.prevSize.y = this.primaryStage.getHeight();
        }
        return this.controller.prevSize;
    }

    public Delta getWindowedPositon() {
        if (this.controller.prevPos.x == null) {
            this.controller.prevPos.x = this.primaryStage.getX();
        }
        if (this.controller.prevPos.y == null) {
            this.controller.prevPos.y = this.primaryStage.getY();
        }
        return this.controller.prevPos;
    }
}

