/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.models;

import cms.tmx.app.models.Delta;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MSceneCtrl {
    private Stage primaryStage;
    protected Delta prevSize;
    protected Delta prevPos;
    protected boolean maximised = false;
    private boolean snapped = false;
    @FXML
    private Pane leftPane;
    @FXML
    private Pane rightPane;
    @FXML
    private Pane topPane;
    @FXML
    private Pane bottomPane;
    @FXML
    private Pane topLeftPane;
    @FXML
    private Pane topRightPane;
    @FXML
    private Pane bottomLeftPane;
    @FXML
    private Pane bottomRightPane;
    public BooleanProperty max = new SimpleBooleanProperty(false);
    private static final Logger log = LogManager.getLogger(MSceneCtrl.class);

    public MSceneCtrl() {
        this.prevSize = new Delta();
        this.prevPos = new Delta();
    }

    @FXML
    private void initialize() {
        this.setResizeControl(this.leftPane, "left");
        this.setResizeControl(this.rightPane, "right");
        this.setResizeControl(this.topPane, "top");
        this.setResizeControl(this.bottomPane, "bottom");
        this.setResizeControl(this.topLeftPane, "top-left");
        this.setResizeControl(this.topRightPane, "top-right");
        this.setResizeControl(this.bottomLeftPane, "bottom-left");
        this.setResizeControl(this.bottomRightPane, "bottom-right");
    }

    protected void setMainApp(Stage primaryStage) {
        this.primaryStage = primaryStage;
    }

    protected void maximise() {
        try {
            Rectangle2D screen = Screen.getScreensForRectangle((double)this.primaryStage.getX(), (double)this.primaryStage.getY(), (double)(this.primaryStage.getWidth() / 2.0), (double)(this.primaryStage.getHeight() / 2.0)).size() == 0 ? ((Screen)Screen.getScreensForRectangle((double)this.primaryStage.getX(), (double)this.primaryStage.getY(), (double)this.primaryStage.getWidth(), (double)this.primaryStage.getHeight()).get(0)).getVisualBounds() : ((Screen)Screen.getScreensForRectangle((double)this.primaryStage.getX(), (double)this.primaryStage.getY(), (double)(this.primaryStage.getWidth() / 2.0), (double)(this.primaryStage.getHeight() / 2.0)).get(0)).getVisualBounds();
            if (this.maximised) {
                this.primaryStage.setWidth(this.prevSize.x.doubleValue());
                this.primaryStage.setHeight(this.prevSize.y.doubleValue());
                this.primaryStage.setX(this.prevPos.x.doubleValue());
                this.primaryStage.setY(this.prevPos.y.doubleValue());
                this.isMaximised(false);
            } else {
                if (!this.snapped) {
                    this.prevSize.x = this.primaryStage.getWidth();
                    this.prevSize.y = this.primaryStage.getHeight();
                    this.prevPos.x = this.primaryStage.getX();
                    this.prevPos.y = this.primaryStage.getY();
                } else if (!screen.contains(this.prevPos.x.doubleValue(), this.prevPos.y.doubleValue())) {
                    if (this.prevSize.x > screen.getWidth()) {
                        this.prevSize.x = screen.getWidth() - 20.0;
                    }
                    if (this.prevSize.y > screen.getHeight()) {
                        this.prevSize.y = screen.getHeight() - 20.0;
                    }
                    this.prevPos.x = screen.getMinX() + (screen.getWidth() - this.prevSize.x) / 2.0;
                    this.prevPos.y = screen.getMinY() + (screen.getHeight() - this.prevSize.y) / 2.0;
                }
                this.primaryStage.setX(screen.getMinX());
                this.primaryStage.setY(screen.getMinY());
                this.primaryStage.setWidth(screen.getWidth());
                this.primaryStage.setHeight(screen.getHeight());
                this.isMaximised(true);
            }
        }
        catch (IndexOutOfBoundsException e) {
            log.error("\u663e\u793a\u5f02\u5e38 X=" + this.primaryStage.getX());
            log.error("\u663e\u793a\u5f02\u5e38 y=" + this.primaryStage.getY());
            log.error("\u663e\u793a\u5f02\u5e38 width=" + this.primaryStage.getWidth());
            log.error("\u663e\u793a\u5f02\u5e38 height=" + this.primaryStage.getHeight());
            log.error((Object)e, (Throwable)e);
            this.primaryStage.setX(0.0);
            this.primaryStage.setY(0.0);
            this.primaryStage.setWidth(1200.0);
            this.primaryStage.setHeight(625.0);
            this.maximise();
        }
    }

    protected void minimise() {
        this.primaryStage.setIconified(true);
    }

    protected void setMoveControl(final Node node) {
        final Delta delta = new Delta();
        final Delta eventSource = new Delta();
        node.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isPrimaryButtonDown()) {
                    delta.x = mouseEvent.getX();
                    delta.y = mouseEvent.getY();
                    if (MSceneCtrl.this.maximised || MSceneCtrl.this.snapped) {
                        delta.x = MSceneCtrl.this.prevSize.x * (mouseEvent.getX() / MSceneCtrl.this.primaryStage.getWidth());
                        delta.y = MSceneCtrl.this.prevSize.y * (mouseEvent.getY() / MSceneCtrl.this.primaryStage.getHeight());
                    } else {
                        MSceneCtrl.this.prevSize.x = MSceneCtrl.this.primaryStage.getWidth();
                        MSceneCtrl.this.prevSize.y = MSceneCtrl.this.primaryStage.getHeight();
                        MSceneCtrl.this.prevPos.x = MSceneCtrl.this.primaryStage.getX();
                        MSceneCtrl.this.prevPos.y = MSceneCtrl.this.primaryStage.getY();
                    }
                    eventSource.x = mouseEvent.getScreenX();
                    eventSource.y = node.prefHeight(MSceneCtrl.this.primaryStage.getHeight());
                }
            }
        });
        node.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isPrimaryButtonDown()) {
                    MSceneCtrl.this.primaryStage.setX(mouseEvent.getScreenX() - delta.x);
                    if (MSceneCtrl.this.snapped) {
                        Rectangle2D screen = ((Screen)Screen.getScreensForRectangle((double)mouseEvent.getScreenX(), (double)mouseEvent.getScreenY(), (double)1.0, (double)1.0).get(0)).getVisualBounds();
                        MSceneCtrl.this.primaryStage.setHeight(screen.getHeight());
                        if (mouseEvent.getScreenY() > eventSource.y) {
                            MSceneCtrl.this.primaryStage.setWidth(MSceneCtrl.this.prevSize.x.doubleValue());
                            MSceneCtrl.this.primaryStage.setHeight(MSceneCtrl.this.prevSize.y.doubleValue());
                            MSceneCtrl.this.snapped = false;
                        }
                    } else {
                        MSceneCtrl.this.primaryStage.setY(mouseEvent.getScreenY() - delta.y);
                    }
                    if (MSceneCtrl.this.maximised) {
                        MSceneCtrl.this.primaryStage.setWidth(MSceneCtrl.this.prevSize.x.doubleValue());
                        MSceneCtrl.this.primaryStage.setHeight(MSceneCtrl.this.prevSize.y.doubleValue());
                        MSceneCtrl.this.isMaximised(false);
                    }
                }
            }
        });
        node.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                    MSceneCtrl.this.maximise();
                }
            }
        });
        node.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getScreenX() != eventSource.x.doubleValue()) {
                    Rectangle2D screen = ((Screen)Screen.getScreensForRectangle((double)mouseEvent.getScreenX(), (double)mouseEvent.getScreenY(), (double)1.0, (double)1.0).get(0)).getVisualBounds();
                    if (mouseEvent.getScreenX() == screen.getMinX()) {
                        MSceneCtrl.this.primaryStage.setY(screen.getMinY());
                        MSceneCtrl.this.primaryStage.setHeight(screen.getHeight());
                        MSceneCtrl.this.primaryStage.setX(screen.getMinX());
                        if (screen.getWidth() / 2.0 < MSceneCtrl.this.primaryStage.getMinWidth()) {
                            MSceneCtrl.this.primaryStage.setWidth(MSceneCtrl.this.primaryStage.getMinWidth());
                        } else {
                            MSceneCtrl.this.primaryStage.setWidth(screen.getWidth() / 2.0);
                        }
                        MSceneCtrl.this.snapped = true;
                    } else if (mouseEvent.getScreenX() == screen.getMaxX() - 1.0) {
                        MSceneCtrl.this.primaryStage.setY(screen.getMinY());
                        MSceneCtrl.this.primaryStage.setHeight(screen.getHeight());
                        if (screen.getWidth() / 2.0 < MSceneCtrl.this.primaryStage.getMinWidth()) {
                            MSceneCtrl.this.primaryStage.setWidth(MSceneCtrl.this.primaryStage.getMinWidth());
                        } else {
                            MSceneCtrl.this.primaryStage.setWidth(screen.getWidth() / 2.0);
                        }
                        MSceneCtrl.this.primaryStage.setX(screen.getMaxX() - MSceneCtrl.this.primaryStage.getWidth());
                        MSceneCtrl.this.snapped = true;
                    } else if (mouseEvent.getScreenY() == screen.getMinY()) {
                        if (!screen.contains(MSceneCtrl.this.prevPos.x.doubleValue(), MSceneCtrl.this.prevPos.y.doubleValue())) {
                            if (MSceneCtrl.this.prevSize.x > screen.getWidth()) {
                                MSceneCtrl.this.prevSize.x = screen.getWidth() - 20.0;
                            }
                            if (MSceneCtrl.this.prevSize.y > screen.getHeight()) {
                                MSceneCtrl.this.prevSize.y = screen.getHeight() - 20.0;
                            }
                            MSceneCtrl.this.prevPos.x = screen.getMinX() + (screen.getWidth() - MSceneCtrl.this.prevSize.x) / 2.0;
                            MSceneCtrl.this.prevPos.y = screen.getMinY() + (screen.getHeight() - MSceneCtrl.this.prevSize.y) / 2.0;
                        }
                        MSceneCtrl.this.primaryStage.setX(screen.getMinX());
                        MSceneCtrl.this.primaryStage.setY(screen.getMinY());
                        MSceneCtrl.this.primaryStage.setWidth(screen.getWidth());
                        MSceneCtrl.this.primaryStage.setHeight(screen.getHeight());
                        MSceneCtrl.this.isMaximised(true);
                    }
                }
            }
        });
    }

    private void setResizeControl(Pane pane, final String direction) {
        pane.setOnMouseDragged((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isPrimaryButtonDown()) {
                    double width = MSceneCtrl.this.primaryStage.getWidth();
                    double height = MSceneCtrl.this.primaryStage.getHeight();
                    if (direction.endsWith("left")) {
                        if (width > MSceneCtrl.this.primaryStage.getMinWidth() || mouseEvent.getX() < 0.0) {
                            MSceneCtrl.this.primaryStage.setWidth(width - mouseEvent.getScreenX() + MSceneCtrl.this.primaryStage.getX());
                            MSceneCtrl.this.primaryStage.setX(mouseEvent.getScreenX());
                        }
                    } else if (direction.endsWith("right") && (width > MSceneCtrl.this.primaryStage.getMinWidth() || mouseEvent.getX() > 0.0)) {
                        MSceneCtrl.this.primaryStage.setWidth(width + mouseEvent.getX());
                    }
                    if (direction.startsWith("top")) {
                        if (MSceneCtrl.this.snapped) {
                            MSceneCtrl.this.primaryStage.setHeight(MSceneCtrl.this.prevSize.y.doubleValue());
                            MSceneCtrl.this.snapped = false;
                        } else if (height > MSceneCtrl.this.primaryStage.getMinHeight() || mouseEvent.getY() < 0.0) {
                            MSceneCtrl.this.primaryStage.setHeight(height - mouseEvent.getScreenY() + MSceneCtrl.this.primaryStage.getY());
                            MSceneCtrl.this.primaryStage.setY(mouseEvent.getScreenY());
                        }
                    } else if (direction.startsWith("bottom")) {
                        if (MSceneCtrl.this.snapped) {
                            MSceneCtrl.this.primaryStage.setY(MSceneCtrl.this.prevPos.y.doubleValue());
                            MSceneCtrl.this.snapped = false;
                        } else if (height > MSceneCtrl.this.primaryStage.getMinHeight() || mouseEvent.getY() > 0.0) {
                            MSceneCtrl.this.primaryStage.setHeight(height + mouseEvent.getY());
                        }
                    }
                }
            }
        });
        pane.setOnMousePressed((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.isPrimaryButtonDown() && !MSceneCtrl.this.snapped) {
                    MSceneCtrl.this.prevSize.y = MSceneCtrl.this.primaryStage.getHeight();
                    MSceneCtrl.this.prevPos.y = MSceneCtrl.this.primaryStage.getY();
                }
            }
        });
        pane.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && !MSceneCtrl.this.snapped) {
                    Rectangle2D screen = ((Screen)Screen.getScreensForRectangle((double)mouseEvent.getScreenX(), (double)mouseEvent.getScreenY(), (double)1.0, (double)1.0).get(0)).getVisualBounds();
                    if (MSceneCtrl.this.primaryStage.getY() <= screen.getMinY() && direction.startsWith("top")) {
                        MSceneCtrl.this.primaryStage.setHeight(screen.getHeight());
                        MSceneCtrl.this.primaryStage.setY(screen.getMinY());
                        MSceneCtrl.this.snapped = true;
                    }
                    if (mouseEvent.getScreenY() >= screen.getMaxY() && direction.startsWith("bottom")) {
                        MSceneCtrl.this.primaryStage.setHeight(screen.getHeight());
                        MSceneCtrl.this.primaryStage.setY(screen.getMinY());
                        MSceneCtrl.this.snapped = true;
                    }
                }
            }
        });
        pane.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                if (mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2 && (direction.equals("top") || direction.equals("bottom"))) {
                    Rectangle2D screen = ((Screen)Screen.getScreensForRectangle((double)MSceneCtrl.this.primaryStage.getX(), (double)MSceneCtrl.this.primaryStage.getY(), (double)(MSceneCtrl.this.primaryStage.getWidth() / 2.0), (double)(MSceneCtrl.this.primaryStage.getHeight() / 2.0)).get(0)).getVisualBounds();
                    if (MSceneCtrl.this.snapped) {
                        MSceneCtrl.this.primaryStage.setHeight(MSceneCtrl.this.prevSize.y.doubleValue());
                        MSceneCtrl.this.primaryStage.setY(MSceneCtrl.this.prevPos.y.doubleValue());
                        MSceneCtrl.this.snapped = false;
                    } else {
                        MSceneCtrl.this.prevSize.y = MSceneCtrl.this.primaryStage.getHeight();
                        MSceneCtrl.this.prevPos.y = MSceneCtrl.this.primaryStage.getY();
                        MSceneCtrl.this.primaryStage.setHeight(screen.getHeight());
                        MSceneCtrl.this.primaryStage.setY(screen.getMinY());
                        MSceneCtrl.this.snapped = true;
                    }
                }
            }
        });
    }

    protected void isMaximised(Boolean maximised) {
        this.maximised = maximised;
        this.setResizable(maximised == false);
        this.max.set(maximised.booleanValue());
    }

    protected void setResizable(Boolean bool) {
        this.leftPane.setDisable(bool == false);
        this.rightPane.setDisable(bool == false);
        this.topPane.setDisable(bool == false);
        this.bottomPane.setDisable(bool == false);
        this.topLeftPane.setDisable(bool == false);
        this.topRightPane.setDisable(bool == false);
        this.bottomLeftPane.setDisable(bool == false);
        this.bottomRightPane.setDisable(bool == false);
    }
}

