/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.handlers;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MSnippetContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspective;
import org.eclipse.e4.ui.model.application.ui.advanced.MPerspectiveStack;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.model.application.ui.basic.impl.PartStackImpl;
import org.eclipse.e4.ui.workbench.modeling.EModelService;

public class RestorePerspectiveHandler {
    @Inject
    private MEventService es;
    @Inject
    @Named(value="core_event")
    private MEvent eCore;
    private final String SHRINK = "shrink";
    private static final Logger logger = LogManager.getLogger(RestorePerspectiveHandler.class);

    @Execute
    public void execute(EModelService ms, MApplication app, MWindow window) {
        try {
            MPerspectiveStack pstack = (MPerspectiveStack)ms.findElements((MUIElement)app, "cms.tmx.perstack.main", MPerspectiveStack.class, null).get(0);
            MPerspective initPer = (MPerspective)ms.cloneSnippet((MSnippetContainer)app, "cms.tmx.per.init", window);
            MPerspective initPerUser = (MPerspective)ms.findElements((MUIElement)app, "cms.tmx.per.init." + this.eCore.getStr("user_id") + "." + this.eCore.getStr("post_id"), MPerspective.class, null).get(0);
            List list = initPerUser.getWindows();
            for (MWindow mWindow : list) {
                if ("cms.tmx.twin.main".equals(mWindow.getElementId())) continue;
                mWindow.setVisible(false);
                mWindow.setToBeRendered(false);
            }
            List findElements = ms.findElements((MUIElement)app, "cms.tmx.app.ps.right", MPartStack.class, null);
            MStackElement now = null;
            if (!findElements.isEmpty() && findElements.get(1) instanceof PartStackImpl) {
                PartStackImpl stack = (PartStackImpl)PartStackImpl.class.cast(findElements.get(1));
                List children = stack.getChildren();
                if (!children.isEmpty()) {
                    for (MStackElement item : children) {
                        if (item instanceof MPart && item.isToBeRendered() && item.isOnTop()) {
                            now = item;
                            continue;
                        }
                        this.closePart(item);
                    }
                    if (now != null) {
                        this.closePart(now);
                    }
                }
                stack.setSelectedElement(null);
            }
            if (initPer != null) {
                pstack.getChildren().remove(initPerUser);
                initPer.setElementId("cms.tmx.per.init." + this.eCore.getStr("user_id") + "." + this.eCore.getStr("post_id"));
                pstack.getChildren().add(1, initPer);
                pstack.setSelectedElement((MUIElement)initPer);
                initPer.setToBeRendered(true);
            }
            this.es.sendEvent("check.rights", null);
            this.es.postEvent("shrink", null);
        }
        catch (Exception e) {
            logger.error("\u9ed8\u8ba4\u6a21\u677f\u5f02\u5e38", (Throwable)e);
        }
    }

    private void closePart(MStackElement item) {
        long begin = System.currentTimeMillis();
        logger.info("default template start ,id : " + item.getElementId());
        item.setToBeRendered(false);
        logger.info("default template done ,id : " + item.getElementId() + ", takes :" + (System.currentTimeMillis() - begin));
    }
}

