/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.handlers;

import java.util.UUID;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class MultiOpenHandler {
    @Execute
    public void execute(EModelService ms, EPartService ps, MApplication app, MPart part) {
        MPart newPart = ps.createPart(part.getElementId());
        if (newPart == null) {
            this.createDesc(ms, app, part, "cms.tmx.app.ps.right".equals(part.getParent().getElementId()));
            newPart = ps.createPart(part.getElementId());
        }
        if (newPart != null) {
            newPart.setElementId(String.valueOf(part.getElementId()) + ":" + UUID.randomUUID());
            part.getParent().getChildren().add(newPart);
            newPart.setToBeRendered(true);
            newPart.setVisible(true);
            ps.showPart(newPart, EPartService.PartState.ACTIVATE);
        }
    }

    @CanExecute
    public boolean canExecute() {
        return true;
    }

    public void createDesc(EModelService ms, MApplication app, MPart part, boolean closeable) {
        MPartDescriptor desc = (MPartDescriptor)ms.createModelElement(MPartDescriptor.class);
        desc.setElementId(part.getElementId());
        desc.setContributorURI(part.getContributorURI());
        desc.setContributionURI(part.getContributionURI());
        desc.setLabel(part.getLabel());
        desc.setCloseable(closeable);
        desc.setIconURI(part.getIconURI());
        desc.setTooltip(part.getTooltip());
        desc.getTags().addAll(part.getTags());
        desc.getVariables().addAll(part.getVariables());
        desc.getProperties().putAll(part.getProperties());
        desc.getPersistedState().putAll(part.getPersistedState());
        desc.getBindingContexts().addAll(part.getBindingContexts());
        app.getDescriptors().add(desc);
    }
}

