/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.app.addons;

import cms.tmx.app.models.MWindowImp;
import cms.tmx.app.models.PartCloseHandler;
import cms.tmx.core.MConfService;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import javax.inject.Inject;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.MContext;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MPartStack;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimmedWindow;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.fx.ui.workbench.renderers.base.services.MaximizationService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WMinMaxableWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WStack;
import org.eclipse.jdt.annotation.NonNull;
import org.osgi.service.event.Event;

public class MinMaxAddon {
    static String MINIMIZED = "Minimized";
    static String MAXIMIZED = "Maximized";
    private final EModelService modelService;
    @Inject
    private MConfService cs;
    @Inject
    private PartCloseHandler pch;

    @Inject
    MinMaxAddon(IEventBroker eventBroker, EModelService modelService) {
        this.modelService = modelService;
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/children/*", this::handleChildrenChanged);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/ElementContainer/selectedElement/*", this::handleSelectedChildren);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/widget/*", this::handleWidget);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/renderer/*", this::handleMWindowRender);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/toBeRendered/*", this::handleVisibleChildrenChanged);
        eventBroker.subscribe("org/eclipse/e4/ui/model/ui/UIElement/visible/*", this::handleVisibleChildrenChanged);
    }

    void handleChildrenChanged(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (changedElement instanceof MElementContainer && !(changedElement instanceof MApplication) && this.modelService.toBeRenderedCount((MElementContainer)changedElement) == 0) {
            this.handleMinMaxCallback(WMinMaxableWidget.WMinMaxState.RESTORE, changedElement);
        }
    }

    void handleSelectedChildren(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        this.handleTabClosable(changedElement);
    }

    void handleWidget(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        this.handleTabClosable(changedElement);
        if (changedElement != null) {
            WMinMaxableWidget widget;
            if (changedElement.getElementId() == null && changedElement.getWidget() instanceof MWindowImp) {
                MWindowImp cast = (MWindowImp)((Object)MWindowImp.class.cast(changedElement.getWidget()));
                Pane root = cast.getWidgetNode();
                root.getStyleClass().clear();
                root.getStyleClass().add((Object)"root");
                root.getStyleClass().add((Object)(this.cs.getUserProps().get("app_theme") == null ? "blue-theme" : this.cs.getUserProps().get("app_theme")));
            }
            if ((widget = this.getTargetWidget(changedElement)) != null) {
                widget.setMinMaxCallback(s -> this.handleMinMaxCallback((WMinMaxableWidget.WMinMaxState)s, changedElement));
            }
        }
    }

    void handleMWindowRender(Event event) {
        MWindow mWindow;
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        if (changedElement instanceof MWindow && (mWindow = (MWindow)changedElement).getIconURI() == null) {
            mWindow.setLabel("\u5168\u8d44\u4ea7\u6295\u8d44\u7ba1\u7406\u5e73\u53f0");
            mWindow.setIconURI("platform:/plugin/cms.tmx.app/res/32X32.png");
            mWindow.setWidth(1155);
        }
    }

    void handleVisibleChildrenChanged(Event event) {
        MUIElement changedElement = (MUIElement)event.getProperty("ChangedElement");
        this.handleTabClosable(changedElement);
        if (!changedElement.isToBeRendered() || !changedElement.isVisible()) {
            this.handleMinMaxCallback(WMinMaxableWidget.WMinMaxState.RESTORE, changedElement);
        }
        if (changedElement.getParent() != null && this.modelService.toBeRenderedCount(changedElement.getParent()) == 0) {
            this.handleMinMaxCallback(WMinMaxableWidget.WMinMaxState.RESTORE, (MUIElement)changedElement.getParent());
        }
    }

    Void handleMinMaxCallback(WMinMaxableWidget.WMinMaxState state, @NonNull MUIElement changedElement) {
        IEclipseContext context = changedElement instanceof MContext ? ((MContext)changedElement).getContext() : this.modelService.getContainingContext(changedElement);
        if (context == null) {
            return null;
        }
        MaximizationService maximizationService = (MaximizationService)context.get(MaximizationService.class);
        if (maximizationService == null) {
            return null;
        }
        if (state == WMinMaxableWidget.WMinMaxState.TOGGLE) {
            if (maximizationService.isMaximized(changedElement)) {
                maximizationService.restore();
            } else {
                maximizationService.maximize(changedElement);
            }
        } else if (state == WMinMaxableWidget.WMinMaxState.MAXIMIZE) {
            if (!maximizationService.isMaximized(changedElement)) {
                maximizationService.maximize(changedElement);
            }
        } else if (maximizationService.isMaximized(changedElement)) {
            maximizationService.restore();
        }
        MElementContainer container = changedElement.getParent();
        if (container != null && container instanceof MTrimmedWindow) {
            MTrimmedWindow window = (MTrimmedWindow)container;
            window.setVisible(!maximizationService.isMaximized(changedElement));
        }
        return null;
    }

    private WMinMaxableWidget getTargetWidget(MUIElement changedElement) {
        if (changedElement instanceof MPlaceholder) {
            return this.getTargetWidget(((MPlaceholder)changedElement).getRef());
        }
        if (changedElement.getWidget() instanceof WMinMaxableWidget) {
            return (WMinMaxableWidget)changedElement.getWidget();
        }
        return null;
    }

    private void handleTabClosable(MUIElement changedElement) {
        try {
            Object object;
            WStack stack = null;
            if (changedElement instanceof MPartStack && changedElement.getWidget() instanceof WStack) {
                stack = (WStack)changedElement.getWidget();
            } else if (changedElement instanceof MPart && changedElement.getParent() != null && changedElement.getParent().getWidget() instanceof WStack) {
                stack = (WStack)changedElement.getParent().getWidget();
            }
            if (stack != null && ("cms.tmx.app.ps.right".equals(stack.getDomElement().getElementId()) || stack.getDomElement().getElementId() == null) && (object = stack.getWidget()) instanceof TabPane) {
                TabPane pane = (TabPane)TabPane.class.cast(object);
                Tab tab = (Tab)pane.getSelectionModel().getSelectedItem();
                if (tab != null && pane.getTabs().size() < 2) {
                    tab.setClosable(false);
                } else if (tab != null) {
                    tab.setClosable(true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

