/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.utils;

import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.utils.StringUtils;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SideCell<T>
extends TableCell<T, MxNode> {
    private static final Logger logger = LogManager.getLogger(SideCell.class);
    private Label label = new Label();

    public SideCell() {
        this.label.getStyleClass().add((Object)"priceTag");
    }

    public void updateItem(MxNode value, boolean empty) {
        try {
            if (value == null || empty) {
                this.setGraphic(null);
                return;
            }
            if (value.getRaw() == null || value.getRaw().trim().isEmpty()) {
                return;
            }
            int side = StringUtils.parseInt((String)value.getRaw());
            this.label.setText(value.getValue());
            switch (side) {
                case 49: 
                case 71: 
                case 80: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
    }
}

