/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.utils;

import cms.tmx.javafx.MxNode;
import cms.tmx.utils.MarketUtils;
import javafx.scene.control.TableColumn;

public class QueryUtils {
    private static final int PAR_VALUE = 100;

    public static String findMarketGrp(String market) {
        return MarketUtils.getMarketGroup((String)market);
    }

    public static String getUnit(String secType, String market) {
        if ("STOCK".equals(secType) || "OIS".equals(secType)) {
            return "\u80a1";
        }
        if ("BOND".equals(secType) && "XSHG".equals(market) || "STD_BOND".equals(secType) && "XSHG".equals(market) || "REPO".equals(secType) && "XSHG".equals(market) || "PLEDGE".equals(secType) && "XSHG".equals(market)) {
            return "\u624b";
        }
        if ("BOND".equals(secType) && "XSHE".equals(market) || "STD_BOND".equals(secType) && "XSHE".equals(market) || "REPO".equals(secType) && "XSHE".equals(market) || "PLEDGE".equals(secType) && "XSHE".equals(market)) {
            return "\u5f20";
        }
        if ("FUND".equals(secType)) {
            return "\u4efd";
        }
        return "";
    }

    public static int compareString(TableColumn<?, ?> column, Object s1, Object s2) {
        String sort1 = (String)s1;
        String sort2 = (String)s2;
        if (column.getSortType() == TableColumn.SortType.ASCENDING) {
            if (sort1.length() == sort2.length()) {
                return sort1.compareTo(sort2);
            }
            if (sort1.length() > sort2.length()) {
                return 1;
            }
            return -1;
        }
        if (sort1.length() == sort2.length()) {
            return sort2.compareTo(sort1);
        }
        if (sort2.length() > sort1.length()) {
            return 1;
        }
        return -1;
    }

    public static int compareMxNode(TableColumn<?, ?> column, Object s1, Object s2) {
        MxNode m1 = (MxNode)MxNode.class.cast(s1);
        MxNode m2 = (MxNode)MxNode.class.cast(s2);
        if (column.getSortType() == TableColumn.SortType.ASCENDING) {
            return m1.getValue().compareTo(m2.getValue());
        }
        return m2.getValue().compareTo(m1.getValue());
    }

    public static int compareNumber(TableColumn<?, ?> column, Object s1, Object s2) {
        Number n1 = (Number)Number.class.cast(s1);
        Number n2 = (Number)Number.class.cast(s2);
        if (column.getSortType() == TableColumn.SortType.ASCENDING) {
            return Double.compare(n1.doubleValue(), n2.doubleValue());
        }
        return Double.compare(n2.doubleValue(), n1.doubleValue());
    }

    public static double calAmountByMarketAndSecType(String market, String secType, double qty, double price) {
        double amount = 0.0;
        switch (secType) {
            case "STD_BOND": {
                amount = qty * (double)("XSHG".equals(market) ? 1000 : 100);
                break;
            }
            case "BOND": {
                amount = qty * price * (double)("XSHG".equals(market) ? 10 : 1);
                break;
            }
            default: {
                amount = qty * price;
            }
        }
        return amount;
    }
}

