/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.utils;

import cms.tmx.datatype.message.PInstruction;
import cms.tmx.entity.CcsFundAccount;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.CtpFundAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.entity.data.RefItem;
import cms.tmx.entity.trade.AlgoBaseOrder;
import cms.tmx.entity.trade.BlockDeal;
import cms.tmx.entity.trade.BlockOrder;
import cms.tmx.entity.trade.CcsDeal;
import cms.tmx.entity.trade.CcsOrder;
import cms.tmx.entity.trade.CcsPortfPosition;
import cms.tmx.entity.trade.CcsPosition;
import cms.tmx.entity.trade.CcsRepoPortfPosition;
import cms.tmx.entity.trade.Condition;
import cms.tmx.entity.trade.ConvertibleBond;
import cms.tmx.entity.trade.CrossOrder;
import cms.tmx.entity.trade.CtpDeal;
import cms.tmx.entity.trade.CtpOrder;
import cms.tmx.entity.trade.CtpPosition;
import cms.tmx.entity.trade.Deal;
import cms.tmx.entity.trade.Instrument;
import cms.tmx.entity.trade.Order;
import cms.tmx.entity.trade.Position;
import cms.tmx.entity.trade.SubResult;
import cms.tmx.entity.trade.TradeRecord;
import cms.tmx.entity.trade.basket.BasketAlgoItem;
import cms.tmx.entity.trade.basket.BasketCcsOrder;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.CcsAccountMap;
import cms.tmx.query.current.models.CtpAccountMap;
import cms.tmx.query.current.models.PortfolioAccountModel;
import cms.tmx.query.utils.FundAccName;
import cms.tmx.query.utils.QueryUtils;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.math.BigDecimal;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class QueryModel
extends MxModel {
    @Inject
    protected CcsAccountMap ccsAccSecMap;
    @Inject
    protected CtpAccountMap ctpAccountMap;
    @Inject
    private PortfolioAccountModel portAccModel;
    @Inject
    private PortfolioAccountModel subAccMng;
    @Inject
    private IUserService userService;
    @Inject
    private IRefDataMng refMng;
    private int scale = 3;
    @Inject
    private FundAccName fundAccName;

    public String getInvestId(String extAccntId) {
        return this.ccsAccSecMap.getAllCcsInvestId(extAccntId);
    }

    public String getExtAccntName(String investorid) {
        return this.ccsAccSecMap.getCcsExtAccntName(investorid);
    }

    public String getInverstorSecId(String extSecAccntId) {
        return this.ccsAccSecMap.getAllCcsInverstorSecId(extSecAccntId);
    }

    public String getCtpInvestId(String extAccntId) {
        CtpFundAccount account = this.ctpAccountMap.getCtpAccountMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getInvestId();
        }
        return extAccntId;
    }

    public String getCtpBrokerId(String extAccntId) {
        CtpFundAccount account = this.ctpAccountMap.getCtpAccountMap().get(extAccntId);
        if (account != null && !account.getInvestId().isEmpty()) {
            return account.getBrokerId();
        }
        return "";
    }

    public String getCtpInverstorSecId(String extSecAccntId) {
        SecAccount account = this.ctpAccountMap.getCtpSecAccountMap().get(extSecAccntId);
        if (account != null && !account.getInverstorSecId().isEmpty()) {
            return account.getInverstorSecId();
        }
        return extSecAccntId;
    }

    public String getSubInvestId(String extAccntId, String portfolioId) {
        CcsFundAccount account = this.ccsAccSecMap.getAllCcsAccountMap().get(extAccntId);
        if (account != null) {
            return account.getInvestId();
        }
        account = this.portAccModel.getSubFundAccountByExtIdAndPortId(extAccntId, portfolioId);
        if (account != null) {
            return account.getInvestId();
        }
        return extAccntId;
    }

    public String getSubInverstorSecId(String extSecId, String market, String portfolioId) {
        SecAccount account = this.ccsAccSecMap.getAllCcsSecAccountMap().get(extSecId);
        if (account != null) {
            return account.getInverstorSecId();
        }
        account = this.portAccModel.getSubSecAccountByExtIdAndMarketAndPortId(extSecId, market, portfolioId);
        if (account != null) {
            return account.getInverstorSecId();
        }
        return extSecId;
    }

    public String getSubInvestIdBySub(String extAccntId, String subAccntId) {
        CcsSubFundAccount account = this.portAccModel.getSubFundAccountById(subAccntId);
        if (account != null) {
            return account.getInvestId();
        }
        if (account == null && extAccntId != null && extAccntId.contains("_CNY")) {
            return extAccntId.replace("_CNY", "");
        }
        return extAccntId;
    }

    public String getSubInverstorSecIdBySub(String extSecId, String subSecId, String market) {
        CcsSubSecAccount account = this.portAccModel.getSubSecAccountByIdAndMarket(subSecId, market);
        if (account != null) {
            return account.getInverstorSecId();
        }
        return extSecId;
    }

    public String getUnit(Instrument inst) {
        RefItem refItem;
        String type = inst.getSecType();
        if (inst.getSecType().equals("OIS") && (refItem = this.refMng.getItem(inst.getSecType(), inst.getMarket().getRaw(), inst.getSecId())) instanceof ConvertibleBond) {
            ConvertibleBond bond = (ConvertibleBond)refItem;
            type = "\u65b0\u80a1\u7533\u8d2d".equals(bond.getSubType()) ? "STOCK" : ("\u53ef\u8f6c\u503a\u7533\u8d2d".equals(bond.getSubType()) ? "BOND" : "FUND");
        }
        String market = inst.getMarket().getRaw();
        String unit = QueryUtils.getUnit(type, market);
        return unit;
    }

    public void afterUpdate(CcsOrder order) {
        order.setUnit(this.getUnit(order.getInstrument()));
        String portId = order.getPortfolioId();
        if (!portId.isEmpty()) {
            String name = this.portAccModel.getPortfolioNameById(portId);
            String market = order.getInstrument().getMarket().getRaw();
            order.setPortfolioName(name);
            order.setInvestorId(this.getSubInvestId(order.getExtAccntId(), order.getPortfolioId()));
            order.setInverstorSecId(this.getSubInverstorSecId(order.getExtSecAccntId(), market, order.getPortfolioId()));
            order.setAccName(this.fundAccName.getFundName(order.getInvestorId()));
            order.setCounterName(this.fundAccName.getCounterName(order.getInvestorId()));
        } else {
            order.setInvestorId(this.getInvestId(order.getExtAccntId()));
            order.setInverstorSecId(this.getInverstorSecId(order.getExtSecAccntId()));
            order.setAccName(this.fundAccName.getFundName(order.getInvestorId()));
            order.setCounterName(this.fundAccName.getCounterName(order.getInvestorId()));
        }
        order.setUserName(this.userService.getUserName(order.getUserId()).getValue());
    }

    public void afterUpdate(CtpOrder order) {
        order.setUnit(this.getUnit(order.getInstrument()));
        order.setInvestorId(this.getCtpInvestId(order.getExtAccntId()));
        order.setBrokerId(this.getCtpBrokerId(order.getExtAccntId()));
        order.setInverstorSecId(this.getCtpInverstorSecId(order.getExtSecAccntId()));
        order.setUserName(this.userService.getUserName(order.getUserId()).getValue());
        order.setAccName(this.fundAccName.getFundName(order.getInvestorId()));
    }

    public void afterUpdate(CcsDeal deal) {
        deal.setUnit(this.getUnit(deal.getInstrument()));
        String portId = deal.getPortfolioId();
        if (!portId.isEmpty()) {
            String name = this.portAccModel.getPortfolioNameById(portId);
            String market = deal.getInstrument().getMarket().getRaw();
            deal.setPortfolioName(name);
            deal.setInvestorId(this.getSubInvestId(deal.getExtAccntId(), deal.getPortfolioId()));
            deal.setInverstorSecId(this.getSubInverstorSecId(deal.getExtSecAccntId(), market, deal.getPortfolioId()));
            deal.setCounterName(this.fundAccName.getCounterName(deal.getInvestorId()));
        } else {
            deal.setInvestorId(this.getInvestId(deal.getExtAccntId()));
            deal.setInverstorSecId(this.getInverstorSecId(deal.getExtSecAccntId()));
            deal.setCounterName(this.fundAccName.getCounterName(deal.getInvestorId()));
        }
        deal.setUserName(this.userService.getUserName(deal.getUserId()).getValue());
        deal.setInvestorName(this.fundAccName.getFundName(deal.getInvestorId()));
    }

    public void afterUpdate(CtpDeal deal) {
        deal.setUnit(this.getUnit(deal.getInstrument()));
        deal.setInvestorId(this.getCtpInvestId(deal.getExtAccntId()));
        deal.setInverstorSecId(this.getCtpInverstorSecId(deal.getExtSecAccntId()));
        deal.setInvestorName(this.fundAccName.getFundName(deal.getInvestorId()));
    }

    public void afterUpdateSum(CcsDeal deal) {
        deal.setUnit(this.getUnit(deal.getInstrument()));
        deal.setInvestorId(this.getInvestId(deal.getExtAccntId()));
        deal.setInverstorSecId(this.getInverstorSecId(deal.getExtSecAccntId()));
        String subAcct = deal.getExtSecAccntId();
        if (!subAcct.isEmpty()) {
            deal.setPortfolioName(this.subAccMng.getPortfolioNameById(subAcct));
        }
        deal.setInvestorName(this.fundAccName.getFundName(deal.getInvestorId()));
    }

    public void afterUpdate(CrossOrder croos) {
        croos.setInvestorId(this.getInvestId(croos.getAccntId()));
        croos.setInverstorSecId(this.getInverstorSecId(croos.getSecAccntId()));
    }

    public void afterUpdate(Position posi) {
        String type = posi.getSecType();
        String market = posi.getMarket().getRaw();
        String unit = QueryUtils.getUnit(type, market);
        posi.setUnit(unit);
        if (posi instanceof CtpPosition) {
            posi.setInvestorId(this.getCtpInvestId(posi.getExtAccId()));
            posi.setInverstorSecId(this.getCtpInverstorSecId(posi.getExtSecAccId()));
            posi.setBrokerId(this.getCtpBrokerId(posi.getExtAccId()));
        } else if (posi instanceof CcsRepoPortfPosition) {
            CcsRepoPortfPosition portPosi = (CcsRepoPortfPosition)posi;
            CcsSubFundAccount fund = this.portAccModel.getSubFundAccountById(portPosi.getSubAccntId());
            portPosi.setPortfolioId(fund.getPortfolioId());
            portPosi.setPortfolioName(fund.getPortfolioName());
            portPosi.setInvestorId(this.getSubInvestIdBySub(portPosi.getExtAccId(), portPosi.getSubAccntId()));
            portPosi.setInverstorSecId(this.getSubInverstorSecIdBySub(portPosi.getExtSecAccId(), portPosi.getSubSecAccntId(), market));
        } else if (posi instanceof CcsPortfPosition) {
            CcsPortfPosition portPosi = (CcsPortfPosition)posi;
            CcsSubFundAccount fund = this.portAccModel.getSubFundAccountById(portPosi.getSubAccntId());
            if (fund != null) {
                portPosi.setPortfolioId(fund.getPortfolioId());
                portPosi.setPortfolioName(fund.getPortfolioName());
            }
            portPosi.setInvestorId(this.getSubInvestIdBySub(portPosi.getExtAccId(), portPosi.getSubAccntId()));
            portPosi.setInverstorSecId(this.getSubInverstorSecIdBySub(portPosi.getExtSecAccId(), portPosi.getSubSecAccntId(), market));
            portPosi.setCounterName(this.fundAccName.getCounterName(portPosi.getInvestorId()));
        } else {
            posi.setInvestorId(this.getInvestId(posi.getExtAccId()));
            posi.setInverstorSecId(this.getInverstorSecId(posi.getExtSecAccId()));
            posi.setExtAccntName(this.getExtAccntName(posi.getInvestorId()));
            posi.setCounterName(this.fundAccName.getCounterName(posi.getInvestorId()));
        }
        posi.setInvestorName(this.fundAccName.getFundName(posi.getInvestorId()));
    }

    public void afterUpdateAcc(BasketCcsOrder order) {
        String subExtId = order.getSubAccntId();
        if (!subExtId.isEmpty()) {
            order.setInvestorId(this.getSubInvestIdBySub(order.getExtAccntId(), subExtId));
        } else {
            order.setInvestorId(this.getInvestId(order.getExtAccntId()));
        }
    }

    public void afterUpdateSec(BasketCcsOrder order) {
        this.afterUpdateAcc(order);
        String subSecId = order.getSubSecAccntId();
        if (!subSecId.isEmpty()) {
            String market = order.getInstrument().getMarket().getRaw();
            order.setInverstorSecId(this.getSubInverstorSecIdBySub(order.getExtSecAccntId(), subSecId, market));
        } else {
            order.setInverstorSecId(this.getInverstorSecId(order.getExtSecAccntId()));
        }
    }

    public void afterUpdatePort(BasketCcsOrder order) {
        String portId = order.getPortfolioId();
        if (!portId.isEmpty()) {
            String name = this.portAccModel.getPortfolioNameById(portId);
            order.setPortfolioName(name);
        }
    }

    public void afterUpdate(SubResult result) {
        result.setInvestorId(this.getInvestId(result.getFundAcct()));
        result.setInverstorSecId(this.getInverstorSecId(result.getSecAcct()));
        String portId = result.getPortfolioId();
        if (!StringUtils.isEmpty((String)portId)) {
            String market = result.getMarket().getRaw();
            result.setInvestorId(this.getSubInvestId(result.getFundAcct(), result.getPortfolioId()));
            result.setInverstorSecId(this.getSubInverstorSecId(result.getSecAcct(), market, result.getPortfolioId()));
        }
    }

    public void afterUpdate(TradeRecord result) {
        result.setInvestorId(this.ccsAccSecMap.getAllCcsInvestId(result.getExtAccntId()));
        result.setInverstorSecId(this.ccsAccSecMap.getAllCcsInverstorSecId(result.getExtSecAccntId()));
    }

    public void getPositionPrice(CcsPosition posi) {
        if (posi instanceof CcsPosition) {
            RefItem refItem = this.refMng.getItem(posi.getSecType(), posi.getMarket().getRaw(), posi.getSecId());
            if (refItem != null) {
                this.scale = refItem.getScale() + 1;
            }
            posi.setCost(BigDecimal.valueOf(posi.getCost()).setScale(this.scale, 4).doubleValue());
            posi.setCostAmt(BigDecimal.valueOf(posi.getCostAmt()).setScale(this.scale, 4).doubleValue());
            posi.setCapitalization(BigDecimal.valueOf(posi.getCapitalization()).setScale(this.scale, 4).doubleValue());
            posi.setCarryBuyCost(BigDecimal.valueOf(posi.getCarryBuyCost()).setScale(this.scale, 4).doubleValue());
            posi.setCarryBuyCostAmt(BigDecimal.valueOf(posi.getCarryBuyCostAmt()).setScale(this.scale, 4).doubleValue());
        }
    }

    public void getOrderPrice(Order order) {
        if (order instanceof CcsOrder) {
            RefItem refItem = this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
            if (refItem != null) {
                this.scale = refItem.getScale();
            }
            order.setPrice(BigDecimal.valueOf(order.getPrice()).setScale(this.scale, 4).doubleValue());
            order.setFrozenMargin(BigDecimal.valueOf(order.getFrozenMargin()).setScale(this.scale, 4).doubleValue());
            order.setOrderAmt(BigDecimal.valueOf(order.getOrderAmt()).setScale(this.scale, 4).doubleValue());
            order.setAvgPx(BigDecimal.valueOf(order.getAvgPx()).setScale(this.scale + 1, 4).doubleValue());
        }
    }

    public void getDealPrice(Deal deal) {
        if (deal instanceof CcsDeal) {
            RefItem refItem = this.refMng.getItem(deal.getInstrument().getSecType(), deal.getInstrument().getMarket().getRaw(), deal.getInstrument().getSecId());
            if (refItem != null) {
                this.scale = refItem.getScale();
            }
            deal.setLastPx(BigDecimal.valueOf(deal.getLastPx()).setScale(this.scale, 4).doubleValue());
            deal.setLastAmount(BigDecimal.valueOf(deal.getLastAmount()).setScale(this.scale, 4).doubleValue());
        }
    }

    public void getBasketPrice(BasketCcsOrder order) {
        if (order instanceof BasketCcsOrder) {
            RefItem refItem = this.refMng.getItem(order.getInstrument().getSecType(), order.getInstrument().getMarket().getRaw(), order.getInstrument().getSecId());
            if (refItem != null) {
                this.scale = refItem.getScale();
            }
            order.setPrice(BigDecimal.valueOf(order.getPrice()).setScale(this.scale, 4).doubleValue());
            order.setTradeAmount(BigDecimal.valueOf(order.getTradeAmount()).setScale(this.scale, 4).doubleValue());
            order.setCxlAmount(BigDecimal.valueOf(order.getCxlAmount()).setScale(this.scale, 4).doubleValue());
            order.setOrderAmount(BigDecimal.valueOf(order.getOrderAmount()).setScale(this.scale, 4).doubleValue());
        }
    }

    public void afterUpdate(BasketAlgoItem item, PInstruction.AdjustPosSecInst inst) {
        MxNode node = MxNodeFactory.create((String)"market_code", (String)inst.getMarket());
        item.setMarket(node);
        String unit = QueryUtils.getUnit(item.getType(), item.getMarket().getRaw());
        item.setUnit(unit);
        item.setInvestorId(this.getInvestId(item.getExtAccntId()));
        item.setInvestorSecId(this.getInverstorSecId(item.getExtSecAccntId()));
    }

    public void setTradeRecordPrice(TradeRecord item) {
        RefItem refItem = this.refMng.getItem(item.getInstrument().getSecType(), item.getInstrument().getMarket().getRaw(), item.getInstrument().getSecId());
        if (refItem != null) {
            this.scale = refItem.getScale();
        }
        if (item.isShowAmt()) {
            item.setBeginAmt(StringUtils.toPriceStr((double)StringUtils.parseDouble((String)item.getBeginAmt()), (int)2));
            item.setOccurAmt(StringUtils.toPriceStr((double)StringUtils.parseDouble((String)item.getOccurAmt()), (int)2));
            item.setBalance(StringUtils.toPriceStr((double)StringUtils.parseDouble((String)item.getBalance()), (int)2));
            item.setAvail(StringUtils.toPriceStr((double)StringUtils.parseDouble((String)item.getAvail()), (int)2));
            item.setAdvisable(StringUtils.toPriceStr((double)StringUtils.parseDouble((String)item.getAdvisable()), (int)2));
        }
        item.setPrice(BigDecimal.valueOf(item.getPrice()).setScale(this.scale, 4).doubleValue());
        item.setAmount(BigDecimal.valueOf(item.getAmount()).setScale(this.scale, 4).doubleValue());
    }

    public void afterUpdate(BlockOrder order) {
        order.setInvestorId(this.getInvestId(order.getExtAccntId()));
        order.setInverstorSecId(this.getInverstorSecId(order.getSecAccntId()));
        String type = order.getInstrument().getSecType();
        String market = order.getInstrument().getMarket().getRaw();
        String unit = QueryUtils.getUnit(type, market);
        order.setInvestorName(this.fundAccName.getFundName(order.getInvestorId()));
        order.setUnit(unit);
    }

    public void afterUpdate(BlockDeal deal) {
        deal.setInvestorId(this.getInvestId(deal.getExtAccntId()));
        deal.setInverstorSecId(this.getInverstorSecId(deal.getSecAccntId()));
        String type = deal.getInstrument().getSecType();
        String market = deal.getInstrument().getMarket().getRaw();
        String unit = QueryUtils.getUnit(type, market);
        deal.setUnit(unit);
        deal.setInvestorName(this.fundAccName.getFundName(deal.getInvestorId()));
    }

    public void afterUpdate(AlgoBaseOrder algo) {
        String portId = algo.getPortfolioId();
        if (!portId.isEmpty() && algo.getPortfolioName().isEmpty()) {
            String name = this.portAccModel.getPortfolioNameById(portId);
            algo.setPortfolioName(name);
        }
    }

    public void afterUpdate(Condition cond) {
        cond.setInvestorId(this.getInvestId(cond.getExtAccntId()));
        cond.setInvestorSecId(this.getInverstorSecId(cond.getExtSecAccntId()));
        cond.setUnit(QueryUtils.getUnit(cond.getSecType(), cond.getMarket()));
    }
}

