/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.utils;

import cms.tmx.api.trade.info.IPageInTurn;
import cms.tmx.core.MException;
import cms.tmx.entity.PageInTurn;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.query.utils.IQueryByPage;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class QueryByPage<KEY, PARAM, RESULT>
extends MxObject {
    private static final Logger logger = LogManager.getLogger(QueryByPage.class);
    @Inject
    @Named(value="fixed.query.pool")
    protected ExecutorService service;

    public void queryByPage(IQueryByPage<KEY, PARAM, RESULT> query) throws MException {
        ArrayList<PageInTurn> pageList = new ArrayList<PageInTurn>();
        PageInTurn page = new PageInTurn();
        page.setPageSize(150);
        page.setStartRow(1);
        query.query((IPageInTurn<KEY, PARAM, RESULT>)page);
        if (page.hasNext()) {
            pageList.add(page.next());
        }
        int i = 0;
        while (i < pageList.size()) {
            PageInTurn pi = (PageInTurn)pageList.get(i);
            ++i;
            if (!pi.hasNext()) continue;
            pageList.add(pi.next());
        }
        CountDownLatch cdl = new CountDownLatch(pageList.size());
        for (PageInTurn opi : pageList) {
            this.service.execute(() -> {
                try {
                    try {
                        query.query((IPageInTurn)opi);
                    }
                    catch (MException | Exception e) {
                        logger.error("query by page error: ", e);
                        cdl.countDown();
                    }
                }
                finally {
                    cdl.countDown();
                }
            });
        }
        try {
            cdl.await(180L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            logger.error("\u591a\u7ebf\u7a0b\u67e5\u8be2\u8d85\u65f6", (Throwable)e);
        }
    }
}

