/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.utils;

import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.utils.CssUtils;
import cms.tmx.query.utils.SideCell;
import cms.tmx.utils.StringUtils;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ObSideCell<T>
extends TableCell<T, Side> {
    private static final Logger logger = LogManager.getLogger(SideCell.class);
    private Label label = new Label();

    public ObSideCell() {
        this.label.getStyleClass().add((Object)"priceTag");
    }

    public void updateItem(Side sid, boolean empty) {
        try {
            if (sid == null) {
                this.setGraphic(null);
                return;
            }
            if ("".equals(sid) || "".equals(sid.getValue())) {
                return;
            }
            int side = StringUtils.parseInt((String)sid.getValue());
            this.label.setText(sid.getSideName());
            switch (side) {
                case 49: 
                case 71: 
                case 80: 
                case 83: 
                case 201: {
                    CssUtils.makeRise((Control)this.label);
                    break;
                }
                default: {
                    CssUtils.makeFall((Control)this.label);
                }
            }
            this.setGraphic((Node)this.label);
        }
        catch (Exception e) {
            logger.info(e.getMessage(), (Throwable)e);
        }
    }
}

