/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.utils;

import cms.tmx.manage.models.FundAccountMngServiceImpl;
import cms.tmx.query.current.models.PortfolioAccountModel;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.e4.core.di.annotations.Creatable;

@Singleton
@Creatable
public class FundAccName {
    @Inject
    private FundAccountMngServiceImpl accountMngServiceImpl;
    @Inject
    private PortfolioAccountModel portfolioAccModel;

    public String getFundName(String investorId) {
        Map accNameMap = this.accountMngServiceImpl.accNameMap;
        if ("".equals(investorId) || investorId == null) {
            return "";
        }
        return (String)accNameMap.get(investorId);
    }

    public String getCounterName(String investorId) {
        Map accCounterMap = this.accountMngServiceImpl.investorIdCounterMap;
        if ("".equals(investorId) || investorId == null) {
            return "";
        }
        if (accCounterMap.get(investorId) == null && this.portfolioAccModel.getInvestorIdCounterMap().get(investorId) != null) {
            return this.portfolioAccModel.getInvestorIdCounterMap().get(investorId);
        }
        return accCounterMap.get(investorId) == null ? "" : (String)accCounterMap.get(investorId);
    }
}

