/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.otc.models.OtcMarketPositionModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleGroup;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public class OtcMarketPositionPart
extends MxPart {
    @FXML
    protected TableView<ObPosition> tablePositionSum;
    @FXML
    private TableColumn<ObPosition, String> colSumPortfolioId;
    @FXML
    private TableColumn<ObPosition, String> colSumPortfolioName;
    @FXML
    private TableColumn<ObPosition, String> colSumSecId;
    @FXML
    private TableColumn<ObPosition, String> colSumSecName;
    @FXML
    private TableColumn<ObPosition, SecSubType> colSumSecSubType;
    @FXML
    private TableColumn<ObPosition, Number> colSumCostPrice;
    @FXML
    private TableColumn<ObPosition, Number> colSumPosition;
    @FXML
    private TableColumn<ObPosition, Number> colSumAvailable;
    @FXML
    private TableColumn<ObPosition, Number> colSumCost;
    @FXML
    private TableColumn<ObPosition, Number> colSumNet;
    @FXML
    private TableColumn<ObPosition, String> colSumNetDate;
    @FXML
    private TableColumn<ObPosition, Number> colSumCapital;
    @FXML
    private TableColumn<ObPosition, Number> colSumFloatProfit;
    @FXML
    private TableColumn<ObPosition, Number> colSumRealProfit;
    @FXML
    private TableColumn<ObPosition, Number> colSumProfit;
    @FXML
    private TableColumn<ObPosition, Number> colSumScope;
    @FXML
    private TableColumn<ObPosition, String> colSumAcc;
    @FXML
    private TableColumn<ObPosition, String> colSumSecAcc;
    @FXML
    protected TextField searchText;
    @FXML
    private CheckBox cbFilterZeroPos;
    @FXML
    protected Label lbPosition;
    @FXML
    protected Label lbCost;
    @FXML
    protected Label lbCapital;
    @FXML
    protected Label lbFloatProfit;
    @FXML
    protected Label lbRealProfit;
    @Inject
    private EPartService eps;
    @Inject
    protected OtcMarketPositionModel model;
    protected ToggleGroup group = new ToggleGroup();
    protected MxList<ObPosition> mxSumList = new MxList();
    private static final Logger logger = LogManager.getLogger(OtcMarketPositionPart.class);
    @Inject
    private MxAlert alert;
    protected Predicate<ObPosition> pdSum = deal -> {
        if (this.cbFilterZeroPos.isSelected() && deal.getSecBalance() == 0.0) {
            return false;
        }
        String text = this.searchText.getText().trim();
        if (deal.getSecurityId().contains(text)) {
            return true;
        }
        return deal.getSecurityName().contains(text);
    };
    protected InvalidationListener lstnModel = ob -> {
        List<ObPosition> sumList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObPosition> observableList = this.model.getSumList();
        synchronized (observableList) {
            sumList.addAll((Collection<ObPosition>)this.model.getSumList());
        }
        Platform.runLater(() -> {
            this.mxSumList.update(sumList, this.pdSum);
            this.mxSumList.filter(this.model.getSumList(), this.pdSum);
            this.tablePositionSum.sort();
            this.lstnExtendOperation();
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<ObPosition> observableList = this.model.getSumList();
        synchronized (observableList) {
            this.mxSumList.filter(this.model.getSumList(), this.pdSum);
            this.lstnExtendOperation();
        }
    };

    @FXML
    public void initialize() {
        this.listener();
        this.createSumTable();
        this.refresh();
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.cbFilterZeroPos.setSelected(true);
        this.cbFilterZeroPos.selectedProperty().addListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copySum() {
        TableUtils.copyContentWithHead(this.tablePositionSum);
    }

    @FXML
    public void exportExcelSum() {
        try {
            ExcelUtils.writeExcel(this.tablePositionSum, (String)"\u6301\u4ed3\u67e5\u8be2\u4e00\u6237\u901a");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    public void lstnExtendOperation() {
        ObservableList list = this.mxSumList.getList();
        double position = 0.0;
        double cost = 0.0;
        double capital = 0.0;
        double floatProfit = 0.0;
        double realProfit = 0.0;
        for (ObPosition pos : list) {
            position += pos.getSecBalance();
            cost += pos.getBuyCostAmt();
            capital += pos.getMarketValue();
            floatProfit += pos.getFloatPnl();
            realProfit += pos.getRealPnl();
        }
        this.lbPosition.setText(StringUtils.toThousands((Number)position, (int)2));
        this.lbCost.setText(StringUtils.toThousands((Number)cost, (int)2));
        this.lbCapital.setText(StringUtils.toThousands((Number)capital, (int)2));
        this.lbFloatProfit.setText(StringUtils.toThousands((Number)floatProfit, (int)2));
        this.lbRealProfit.setText(StringUtils.toThousands((Number)realProfit, (int)2));
    }

    protected void createSumTable() {
        this.colSumPortfolioId.setCellValueFactory(data -> ((ObPosition)data.getValue()).portfolioIdProperty());
        this.colSumPortfolioName.setCellValueFactory(data -> ((ObPosition)data.getValue()).portfolioNameProperty());
        this.colSumSecId.setCellValueFactory(data -> ((ObPosition)data.getValue()).securityIdProperty());
        this.colSumSecName.setCellValueFactory(data -> ((ObPosition)data.getValue()).securityNameProperty());
        this.colSumSecSubType.setCellValueFactory(data -> ((ObPosition)data.getValue()).secSubTypeProperty());
        this.colSumCostPrice.setCellValueFactory(data -> ((ObPosition)data.getValue()).buyCostProperty());
        this.colSumCostPrice.setCellFactory(data -> new DoubleTableCell(4));
        this.colSumPosition.setCellValueFactory(data -> ((ObPosition)data.getValue()).secBalanceProperty());
        this.colSumPosition.setCellFactory(data -> new DoubleTableCell());
        this.colSumAvailable.setCellValueFactory(data -> ((ObPosition)data.getValue()).secAvailProperty());
        this.colSumAvailable.setCellFactory(data -> new DoubleTableCell());
        this.colSumCost.setCellValueFactory(data -> ((ObPosition)data.getValue()).buyCostAmtProperty());
        this.colSumCost.setCellFactory(data -> new DoubleTableCell());
        this.colSumNet.setCellValueFactory(data -> ((ObPosition)data.getValue()).nowPriceProperty());
        this.colSumNet.setCellFactory(data -> new DoubleTableCell(4));
        this.colSumNetDate.setCellValueFactory(data -> ((ObPosition)data.getValue()).netValueDateProperty());
        this.colSumCapital.setCellValueFactory(data -> ((ObPosition)data.getValue()).marketValueProperty());
        this.colSumCapital.setCellFactory(data -> new DoubleTableCell());
        this.colSumFloatProfit.setCellValueFactory(data -> ((ObPosition)data.getValue()).floatPnlProperty());
        this.colSumFloatProfit.setCellFactory(data -> new DoubleTableCell());
        this.colSumRealProfit.setCellValueFactory(data -> ((ObPosition)data.getValue()).realPnlProperty());
        this.colSumRealProfit.setCellFactory(data -> new DoubleTableCell());
        this.colSumProfit.setCellValueFactory(data -> ((ObPosition)data.getValue()).yieldProperty());
        this.colSumProfit.setCellFactory(data -> new DoubleTableCell());
        this.colSumScope.setCellValueFactory(data -> ((ObPosition)data.getValue()).fundSizeProperty());
        this.colSumScope.setCellFactory(data -> new DoubleTableCell());
        this.colSumAcc.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorIdProperty());
        this.colSumSecAcc.setCellValueFactory(data -> ((ObPosition)data.getValue()).investorSecIdProperty());
        this.tablePositionSum.setPlaceholder((Node)new Label());
        this.tablePositionSum.setItems(this.mxSumList.getList());
        TableUtils.orgnizeClmWidth(this.tablePositionSum);
    }
}

