/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.EditTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.table.TooltipTableCell;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.entity.trade.ObSingleOrderNeeq;
import cms.tmx.http.api.strategy.dto.Order;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.otc.models.OtcFundOrderModel;
import cms.tmx.query.utils.SideCell;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javax.inject.Inject;

public class OtcFundOrderPart
extends MxPagePart<Order, ObSingleOrderNeeq> {
    @FXML
    protected TableColumn<ObSingleOrderNeeq, MxNode> side;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> errInfo;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> userName;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> orderQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> cumQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> wthQty;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> price;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> orderAmount;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> avgPx;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> totalValue;
    @Inject
    protected MxAlert alert;
    @Inject
    private OtcFundOrderModel otcOrderModel;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> securitySubType;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> securityGroup;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, String> matchType;
    @FXML
    protected TableColumn<ObSingleOrderNeeq, Number> frozenMargin;

    protected void createTableView() {
        TableUtils.initValueFactory((TableView)this.tableView);
        this.side.setCellFactory(cell -> new SideCell());
        this.userName.setCellValueFactory(data -> ((ObSingleOrderNeeq)data.getValue()).userNameProperty());
        this.errInfo.setCellFactory(data -> new TooltipTableCell<ObSingleOrderNeeq, String>(){

            public String tooltip() {
                if (this.getTableRow().getItem() != null) {
                    return ((ObSingleOrderNeeq)this.getValue()).getErrInfo();
                }
                return null;
            }
        });
        this.orderQty.setCellFactory(p -> new EditTableCell(2));
        this.orderQty.setEditable(false);
        this.cumQty.setCellFactory(data -> new DoubleTableCell());
        this.wthQty.setCellFactory(data -> new NumberTableCell());
        this.price.setCellFactory(data -> new DoubleTableCell());
        this.orderAmount.setCellFactory(data -> new DoubleTableCell());
        this.frozenMargin.setCellFactory(data -> new DoubleTableCell());
        this.avgPx.setCellFactory(data -> new DoubleTableCell());
        this.totalValue.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel((TableView)this.tableView, (List)listOrder, (String)"\u59d4\u6258\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead((TableView)this.tableView, (ObservableList)this.mxList.getList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getOrdTime().compareTo(o1.getOrdTime()));
    }

    @FXML
    protected void refresh() {
        try {
            this.otcOrderModel.query();
        }
        catch (MException | Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), e);
        }
    }

    protected List<Order> getList() {
        return this.otcOrderModel.getList();
    }

    protected MxModel getModel() {
        return this.otcOrderModel;
    }

    protected boolean predicate(Order data) {
        String text = this.searchText.getText().trim().toUpperCase();
        String code = data.getInstrument().getSecurityId().toUpperCase();
        String name = data.getInstrument().getSymbol().toUpperCase();
        String orderId = data.getExtOrderId();
        return code.contains(text) || orderId.contains(text) || name.contains(text);
    }
}

