/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MObjFactory;
import cms.tmx.define.MxDict;
import cms.tmx.entity.Portfolio;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.ObExecutionOtc;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.otc.models.OtcFundExecutionModel;
import cms.tmx.query.otc.views.ExecutionDownDialog;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ChangeListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.di.Focus;

public class OtcFundExecutionPart
extends MxPart {
    @FXML
    protected TableView<ObExecutionOtc> tableExecution;
    @FXML
    private TableColumn<ObExecutionOtc, String> colPortfolioId;
    @FXML
    private TableColumn<ObExecutionOtc, String> colPortfolioName;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSecId;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSecName;
    @FXML
    private TableColumn<ObExecutionOtc, SecSubType> colSecType;
    @FXML
    private TableColumn<ObExecutionOtc, Side> colSide;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colNet;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colSec;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colCash;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colFee;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colInterest;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colChangeAmount;
    @FXML
    private TableColumn<ObExecutionOtc, String> colTradeDate;
    @FXML
    private TableColumn<ObExecutionOtc, String> colExecTime;
    @FXML
    private TableColumn<ObExecutionOtc, String> colUser;
    @FXML
    private TableColumn<ObExecutionOtc, Object> colConfirmLetter;
    @FXML
    private TableColumn<ObExecutionOtc, String> colInstructionId;
    @FXML
    protected TextField searchText;
    @FXML
    private CheckComboBox<Portfolio> ccmbPort;
    @FXML
    private Label lbPort;
    @FXML
    private CheckComboBox<String> ccmbSide;
    @FXML
    private Label lbSide;
    @FXML
    private Label lbNum;
    @FXML
    private Label lbSec;
    @FXML
    private Label lbCash;
    @FXML
    private Label lbFee;
    @Inject
    protected OtcFundExecutionModel model;
    @Inject
    protected OtcPortfolioAccountModel portfolioModel;
    protected MxList<ObExecutionOtc> mxList = new MxList();
    private static final Logger logger = LogManager.getLogger(OtcFundExecutionPart.class);
    private boolean portfolioFlag = false;
    private Portfolio portfolio = new Portfolio();
    private List<String> listPortId = FxUtils.newList();
    private List<Portfolio> listPortfolio = new LinkedList<Portfolio>();
    private List<String> listSide = new LinkedList<String>();
    private boolean sideFlag = false;
    private static final String ALL = "\u5168\u9009";
    private String accStr = "";
    @Inject
    private MxAlert alert;
    protected Predicate<ObExecutionOtc> pd = deal -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObExecutionOtc)deal)) {
            return false;
        }
        if (!this.premisePortfolio((ObExecutionOtc)deal)) {
            return false;
        }
        if (!this.premiseSide((ObExecutionOtc)deal)) {
            return false;
        }
        if (deal.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (deal.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        return this.extend((ObExecutionOtc)deal);
    };
    protected InvalidationListener lstnModel = ob -> {
        List<ObExecutionOtc> list = Collections.synchronizedList(new ArrayList());
        ObservableList<ObExecutionOtc> observableList = this.model.getList();
        synchronized (observableList) {
            list.addAll((Collection<ObExecutionOtc>)this.model.getList());
        }
        Platform.runLater(() -> {
            this.mxList.update(list, this.pd);
            this.tableExecution.sort();
            this.lstnExtendOperation((List<ObExecutionOtc>)this.mxList.getList());
        });
    };
    protected InvalidationListener lstnSearch = ob -> {
        ObservableList<ObExecutionOtc> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
            this.lstnExtendOperation((List<ObExecutionOtc>)this.mxList.getList());
        }
    };
    private ChangeListener<Boolean> lstnSide = (obv, old, now) -> {
        if (this.sideFlag) {
            this.sideFlag = false;
            if (!now.booleanValue() && this.ccmbSide.getItemBooleanProperty(0).get()) {
                this.ccmbSide.getItemBooleanProperty(0).set(false);
            }
            if (now.booleanValue() && this.ccmbSide.getItems().size() - this.ccmbSide.getCheckModel().getCheckedItems().size() == 1) {
                this.ccmbSide.getItemBooleanProperty(0).set(true);
            }
            this.lstnSearch.invalidated(null);
            this.sideFlag = true;
        }
    };
    private ChangeListener<Boolean> lstnSideFirst = (obv, old, now) -> {
        if (now == null) {
            return;
        }
        if (this.sideFlag) {
            this.sideFlag = false;
            if (now.booleanValue()) {
                this.ccmbSide.getCheckModel().checkAll();
            } else {
                this.ccmbSide.getCheckModel().clearChecks();
            }
            this.lstnSearch.invalidated(null);
            this.sideFlag = true;
        }
    };
    private InvalidationListener lstnSideAll = ob -> {
        ObservableList listItem = this.ccmbSide.getCheckModel().getCheckedItems();
        this.accStr = listItem.contains(ALL) ? listItem.toString().substring(2 + ALL.length(), listItem.toString().length() - 1) : listItem.toString().substring(1, listItem.toString().length() - 1);
        this.lbSide.setText(this.accStr);
        this.lbSide.setTooltip(new Tooltip(this.lbSide.getText()));
    };
    private InvalidationListener lstnPortAll = ob -> {
        ObservableList checkedItems = this.ccmbPort.getCheckModel().getCheckedItems();
        ObservableList listPortName = FxUtils.newList();
        this.listPortId.clear();
        for (Portfolio port : checkedItems) {
            if (port.getId().isEmpty()) continue;
            listPortName.add(port.getName());
            this.listPortId.add(port.getId());
        }
        String portStr = listPortName.toString();
        this.lbPort.setText(portStr.substring(1, portStr.length() - 1));
        this.lbPort.setTooltip(new Tooltip(this.lbPort.getText()));
    };
    private ChangeListener<Boolean> lstnPort = (obv, old, now) -> {
        if (this.portfolioFlag) {
            this.portfolioFlag = false;
            if (!now.booleanValue() && this.ccmbPort.getItemBooleanProperty(0).get()) {
                this.ccmbPort.getItemBooleanProperty(0).set(false);
            }
            if (now.booleanValue() && this.ccmbPort.getItems().size() - this.ccmbPort.getCheckModel().getCheckedItems().size() == 1) {
                this.ccmbPort.getItemBooleanProperty(0).set(true);
            }
            this.lstnSearch.invalidated(null);
            this.portfolioFlag = true;
        }
    };
    private ChangeListener<Boolean> lstnPortFirst = (obv, old, now) -> {
        if (now == null) {
            return;
        }
        if (this.portfolioFlag) {
            this.portfolioFlag = false;
            if (now.booleanValue()) {
                this.ccmbPort.getCheckModel().checkAll();
            } else {
                this.ccmbPort.getCheckModel().clearChecks();
            }
            this.lstnSearch.invalidated(null);
            this.portfolioFlag = true;
        }
    };
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
    }

    protected void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
        this.initPortfolio();
        this.initSide();
        this.lstnSearch.invalidated(null);
    }

    private void initPortfolio() {
        this.portfolio.setId("");
        this.portfolio.setName(ALL);
        this.listPortfolio.add(this.portfolio);
        ArrayList<Portfolio> portfolioList = new ArrayList<Portfolio>(this.portfolioModel.getPortfolios());
        portfolioList.forEach(item -> {
            if (this.portfolioModel.getMap((Portfolio)item) != null && !this.portfolioModel.getMap((Portfolio)item).isEmpty()) {
                this.listPortfolio.add((Portfolio)item);
            }
        });
        this.ccmbPort.getItems().addAll(this.listPortfolio);
        this.ccmbPort.getCheckModel().checkAll();
        int i = 1;
        while (i < this.listPortfolio.size()) {
            this.ccmbPort.getItemBooleanProperty(i).addListener(this.lstnPort);
            ++i;
        }
        this.ccmbPort.getItemBooleanProperty(0).addListener(this.lstnPortFirst);
        this.ccmbPort.getCheckModel().getCheckedItems().addListener(this.lstnPortAll);
        this.ccmbPort.getCheckModel().checkAll();
        this.portfolioFlag = true;
    }

    private void initSide() {
        this.listSide.add(ALL);
        Map map = MxDict.NEW_INSTRUCTION_SIDE_MAP;
        for (String str : map.values()) {
            if ("\u8f6c\u6362".equals(str)) continue;
            this.listSide.add(str);
        }
        this.ccmbSide.getItems().addAll(this.listSide);
        this.ccmbSide.getCheckModel().checkAll();
        int i = 1;
        while (i < this.listSide.size()) {
            this.ccmbSide.getItemBooleanProperty(i).addListener(this.lstnSide);
            ++i;
        }
        this.ccmbSide.getItemBooleanProperty(0).addListener(this.lstnSideFirst);
        this.ccmbSide.getCheckModel().getCheckedItems().addListener(this.lstnSideAll);
        this.ccmbSide.getCheckModel().checkAll();
        this.sideFlag = true;
    }

    public void lstnExtendOperation(List<ObExecutionOtc> list) {
        double sec = 0.0;
        double cash = 0.0;
        double fee = 0.0;
        for (ObExecutionOtc exec : list) {
            sec += exec.getLastQty();
            cash += exec.getLastAmount();
            fee += exec.getExecFee();
        }
        this.lbSec.setText(StringUtils.toThousands((Number)sec, (int)2));
        this.lbCash.setText(StringUtils.toThousands((Number)cash, (int)2));
        this.lbFee.setText(StringUtils.toThousands((Number)fee, (int)2));
        this.lbNum.setText(StringUtils.toThousands((Number)list.size()));
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
        int i = 1;
        while (i < this.listSide.size()) {
            this.ccmbSide.getItemBooleanProperty(i).removeListener(this.lstnSide);
            ++i;
        }
        this.ccmbSide.getItemBooleanProperty(0).removeListener(this.lstnSideFirst);
        this.ccmbSide.getCheckModel().getCheckedItems().removeListener(this.lstnSideAll);
        i = 1;
        while (i < this.listPortfolio.size()) {
            this.ccmbPort.getItemBooleanProperty(i).removeListener(this.lstnPort);
            ++i;
        }
        this.ccmbPort.getItemBooleanProperty(0).removeListener(this.lstnPortFirst);
        this.ccmbPort.getCheckModel().getCheckedItems().removeListener(this.lstnPortAll);
    }

    @Focus
    public void onFocus() {
        this.tableExecution.refresh();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableExecution);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableExecution, (String)"\u6210\u4ea4\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    public boolean premise(ObExecutionOtc e) {
        return true;
    }

    private boolean premisePortfolio(ObExecutionOtc e) {
        ObservableList listAccnt = this.ccmbPort.getCheckModel().getCheckedItems();
        if (listAccnt.contains(this.portfolio)) {
            return true;
        }
        return this.listPortId.contains(e.getPortfolioId());
    }

    private boolean premiseSide(ObExecutionOtc e) {
        ObservableList listSide = this.ccmbSide.getCheckModel().getCheckedItems();
        if (listSide.contains(ALL)) {
            return true;
        }
        return listSide.contains(e.getSide().toString());
    }

    public boolean extend(ObExecutionOtc e) {
        return false;
    }

    protected void createTable() {
        this.colPortfolioId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).portfolioIdProperty());
        this.colPortfolioName.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).portfolioNameProperty());
        this.colSecId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).getInstrument().symbolProperty());
        this.colSecType.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).secSubTypeProperty());
        this.colSide.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).sideProperty());
        this.colNet.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastPxProperty());
        this.colNet.setCellFactory(data -> new DoubleTableCell(4));
        this.colSec.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastQtyProperty());
        this.colSec.setCellFactory(data -> new DoubleTableCell());
        this.colCash.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastAmountProperty());
        this.colCash.setCellFactory(data -> new DoubleTableCell());
        this.colChangeAmount.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).changeAmountProperty());
        this.colChangeAmount.setCellFactory(data -> new DoubleTableCell());
        this.colFee.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).execFeeProperty());
        this.colFee.setCellFactory(data -> new DoubleTableCell());
        this.colInterest.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).interestProperty());
        this.colInterest.setCellFactory(data -> new DoubleTableCell());
        this.colTradeDate.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).execDateProperty());
        this.colExecTime.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).execTimeProperty());
        this.colUser.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).userIdProperty());
        this.colConfirmLetter.setCellValueFactory(data -> this.setOperation((ObExecutionOtc)data.getValue()));
        this.colInstructionId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).instructionIdProperty());
        this.tableExecution.setPlaceholder((Node)new Label());
        this.tableExecution.setItems(this.mxList.getList());
        TableUtils.orgnizeClmWidth(this.tableExecution);
        this.colInstructionId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableExecution.getSortOrder().add(this.colInstructionId);
    }

    protected void selectRow(ObExecutionOtc execution) {
        this.tableExecution.getSelectionModel().select((Object)execution);
    }

    protected ReadOnlyObjectWrapper<Object> setOperation(final ObExecutionOtc execution) {
        HBox box = new HBox(){

            public String toString() {
                if ("810".equals(execution.getInstrument().getApplId())) {
                    return "";
                }
                return "\u9644\u4ef6";
            }
        };
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button button = new Button("\u9644\u4ef6");
        button.getStyleClass().add((Object)"btnOperation");
        button.setOnAction(event -> this.showOperation(execution));
        if (!"810".equals(execution.getInstrument().getApplId())) {
            box.getChildren().addAll((Object[])new Node[]{button});
        }
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void showOperation(ObExecutionOtc execution) {
        this.selectRow(execution);
        ExecutionDownDialog obj = (ExecutionDownDialog)((Object)this.of.create(ExecutionDownDialog.class));
        obj.setExecution(execution);
        obj.initialValues();
        MxDialog dialog = this.df.create((DialogObj)obj, "\u9644\u4ef6\u8be6\u60c5");
        dialog.launch();
    }
}

