/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.views;

import cms.tmx.control.dialog.DialogFactory;
import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.dialog.MxDialog;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.entity.web.workflow.ObWorkflowLog;
import cms.tmx.entity.web.workflow.Result;
import cms.tmx.entity.web.workflow.WorkflowAttachment;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.ObExecutionOtc;
import cms.tmx.http.api.strategy.dto.Side;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.otc.models.OtcFundExecutionModel;
import cms.tmx.query.otc.models.OtcFundWorkflowLogModel;
import cms.tmx.query.otc.views.ExecutionDownDialog;
import cms.tmx.utils.StringUtils;
import cms.tmx.web.api.core.HttpClientService;
import cmx.tmx.data.IRefDataMng;
import java.io.InputStream;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import okhttp3.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class InstructionOtcDialog
extends DialogObj {
    protected ObInstruction obInstruction;
    @FXML
    protected TableView<ObExecutionOtc> tableExecution;
    @FXML
    private TableColumn<ObExecutionOtc, String> colPortfolioId;
    @FXML
    private TableColumn<ObExecutionOtc, String> colPortfolioName;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSecId;
    @FXML
    private TableColumn<ObExecutionOtc, String> colSecName;
    @FXML
    private TableColumn<ObExecutionOtc, SecSubType> colSecType;
    @FXML
    private TableColumn<ObExecutionOtc, Side> colSide;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colNet;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colSec;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colCash;
    @FXML
    private TableColumn<ObExecutionOtc, Number> colFee;
    @FXML
    private TableColumn<ObExecutionOtc, String> colTradeDate;
    @FXML
    private TableColumn<ObExecutionOtc, Object> colConfirmLetter;
    @FXML
    private TableColumn<ObExecutionOtc, String> colInstructionId;
    @FXML
    private TableView<ObWorkflowLog> tableLog;
    @FXML
    private TableColumn<ObWorkflowLog, String> colWorkflowId;
    @FXML
    private TableColumn<ObWorkflowLog, String> colStartTime;
    @FXML
    private TableColumn<ObWorkflowLog, String> colNodeName;
    @FXML
    private TableColumn<ObWorkflowLog, Result> colOpReault;
    @FXML
    private TableColumn<ObWorkflowLog, String> colOpUser;
    @FXML
    private TableColumn<ObWorkflowLog, String> colOpTime;
    @FXML
    private TableView<WorkflowAttachment> tableAttachment;
    @FXML
    private TableColumn<WorkflowAttachment, String> colFileName;
    @FXML
    private TableColumn<WorkflowAttachment, String> colType;
    @FXML
    private TableColumn<WorkflowAttachment, Object> colOperat;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private OtcFundExecutionModel executionModel;
    @Inject
    private OtcFundWorkflowLogModel logModel;
    @Inject
    private HttpClientService https;
    private ObservableList<WorkflowAttachment> attachmentList = FxUtils.newList();
    private MxList<ObExecutionOtc> execuMxList = new MxList();
    private MxList<ObWorkflowLog> logMxList = new MxList();
    private static final Logger logger = LogManager.getLogger(InstructionOtcDialog.class);
    @Inject
    private MxAlert alert;
    private InvalidationListener lstnProgressModel = ob -> Platform.runLater(() -> {
        this.execuMxList.update(this.executionModel.getList());
        this.tableExecution.sort();
    });
    private InvalidationListener lstnLogModel = ob -> Platform.runLater(() -> {
        this.logMxList.update(this.logModel.getList());
        this.tableLog.sort();
    });
    @Inject
    protected DialogFactory df;
    @Inject
    protected MObjFactory of;

    public ButtonType[] getTypes() {
        return new ButtonType[0];
    }

    @FXML
    public void initialize() {
        this.executionModel.setObInstruction(this.obInstruction);
        this.logModel.setEntryId(this.obInstruction.getEntryId());
        this.listener();
        this.createExecutionTable();
        this.createLogTable();
        this.createAttachmentTable();
        this.refreshExecution();
        this.refreshLog();
    }

    private void listener() {
        this.executionModel.changedProperty().addListener(this.lstnProgressModel);
        this.logModel.changedProperty().addListener(this.lstnLogModel);
    }

    public void onDlgClosed() {
        super.onDlgClosed();
        this.executionModel.changedProperty().removeListener(this.lstnProgressModel);
        this.logModel.changedProperty().removeListener(this.lstnLogModel);
    }

    @FXML
    public void copyExecution() {
        TableUtils.copyContentWithHead(this.tableExecution);
    }

    @FXML
    public void refreshExecution() {
        try {
            if (StringUtils.isEmpty((String)this.obInstruction.getId())) {
                throw new MException(999997, String.valueOf(this.obInstruction.getId()) + "\u6307\u4ee4ID\u4e3a\u7a7a");
            }
            this.executionModel.query();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportExecution() {
        try {
            ExcelUtils.writeExcel(this.tableExecution, (String)"\u6210\u4ea4\u8be6\u60c5");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    @FXML
    public void copyLog() {
        TableUtils.copyContentWithHead(this.tableLog);
    }

    @FXML
    public void refreshLog() {
        try {
            if (StringUtils.isEmpty((String)this.obInstruction.getEntryId())) {
                throw new MException(999997, String.valueOf(this.obInstruction.getId()) + "\u6307\u4ee4\u6d41\u7a0bID\u4e3a\u7a7a");
            }
            this.logModel.query();
        }
        catch (MException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    public void exportLog() {
        try {
            ExcelUtils.writeExcel(this.tableLog, (String)"\u5ba1\u6279\u65e5\u5fd7");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createExecutionTable() {
        this.colPortfolioId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).portfolioIdProperty());
        this.colPortfolioName.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).portfolioNameProperty());
        this.colSecId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).getInstrument().symbolProperty());
        this.colSecType.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).secSubTypeProperty());
        this.colSide.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).sideProperty());
        this.colNet.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastPxProperty());
        this.colNet.setCellFactory(data -> new DoubleTableCell(4));
        this.colSec.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastQtyProperty());
        this.colSec.setCellFactory(data -> new DoubleTableCell());
        this.colCash.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).lastAmountProperty());
        this.colCash.setCellFactory(data -> new DoubleTableCell());
        this.colFee.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).execFeeProperty());
        this.colFee.setCellFactory(data -> new DoubleTableCell());
        this.colTradeDate.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).execDateProperty());
        this.colConfirmLetter.setCellValueFactory(data -> this.setOperation((ObExecutionOtc)data.getValue()));
        this.colInstructionId.setCellValueFactory(data -> ((ObExecutionOtc)data.getValue()).instructionIdProperty());
        this.colInstructionId.setSortType(TableColumn.SortType.DESCENDING);
        this.tableExecution.getSortOrder().add(this.colInstructionId);
        this.tableExecution.sort();
        this.tableExecution.setPlaceholder((Node)new Label());
        this.tableExecution.setItems(this.execuMxList.getList());
        TableUtils.orgnizeClmWidth(this.tableExecution);
    }

    private void selectRow(ObExecutionOtc execution) {
        this.tableExecution.getSelectionModel().select((Object)execution);
    }

    protected ReadOnlyObjectWrapper<Object> setOperation(ObExecutionOtc execution) {
        HBox box = new HBox(){

            public String toString() {
                return "\u9644\u4ef6";
            }
        };
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        Button button = new Button("\u9644\u4ef6");
        button.getStyleClass().add((Object)"btnOperation");
        button.setOnAction(event -> this.showOperation(execution));
        box.getChildren().addAll((Object[])new Node[]{button});
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void showOperation(ObExecutionOtc execution) {
        this.selectRow(execution);
        ExecutionDownDialog obj = (ExecutionDownDialog)((Object)this.of.create(ExecutionDownDialog.class));
        obj.setExecution(execution);
        obj.initialValues();
        MxDialog dialog = this.df.create((DialogObj)obj, "\u9644\u4ef6\u8be6\u60c5");
        dialog.launch();
    }

    private void createLogTable() {
        this.colWorkflowId.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).workflowIdProperty());
        this.colStartTime.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).startTimeProperty());
        this.colNodeName.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).nodeNameProperty());
        this.colOpReault.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).resultProperty());
        this.colOpUser.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).opUserProperty());
        this.colOpTime.setCellValueFactory(data -> ((ObWorkflowLog)data.getValue()).opTimeProperty());
        this.tableLog.setItems(this.logMxList.getList());
        this.tableLog.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableLog);
    }

    private void createAttachmentTable() {
        this.colFileName.setCellValueFactory(data -> new SimpleStringProperty(((WorkflowAttachment)data.getValue()).getFileName()));
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((WorkflowAttachment)data.getValue()).getType()));
        this.colType.setCellFactory(cell -> new AttachTypeTableCell());
        this.colOperat.setCellValueFactory(data -> this.setOperation((WorkflowAttachment)data.getValue()));
        this.tableAttachment.setItems(this.attachmentList);
        this.tableAttachment.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableAttachment);
    }

    private ReadOnlyObjectWrapper<Object> setOperation(WorkflowAttachment attachment) {
        final String[] opStr = new String[]{""};
        HBox box = new HBox(){

            public String toString() {
                return opStr[0];
            }
        };
        Button btnDown = new Button("\u4e0b\u8f7d");
        btnDown.getStyleClass().add((Object)"btnOperation");
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        btnDown.setOnAction(event -> this.download(attachment));
        opStr[0] = "\u5220\u9664";
        box.getChildren().add((Object)btnDown);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void download(WorkflowAttachment attachment) {
        try {
            Response response = this.https.doGet("/workflow/file/download?fileName=" + attachment.getId());
            InputStream body = response.body().byteStream();
            if (body != null) {
                ExcelUtils.saveFile((InputStream)body, (String)attachment.getFileName());
            }
        }
        catch (MException | Exception e) {
            e.printStackTrace();
        }
    }

    public void initialValues() {
        this.attachmentList.setAll((Collection)this.obInstruction.getAttachments());
    }

    public ObInstruction getInstruction() {
        return this.obInstruction;
    }

    public void setObInstruction(ObInstruction obInstruction) {
        this.obInstruction = obInstruction;
    }

    class AttachTypeTableCell<S>
    extends TableCell<S, String> {
        AttachTypeTableCell() {
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                if ("confirmation".equals(item)) {
                    this.setText("\u4efd\u989d\u786e\u8ba4\u4e66");
                } else if ("oa".equals(item)) {
                    this.setText("OA");
                } else if ("contract".equals(item)) {
                    this.setText("\u5408\u540c");
                } else {
                    this.setText("");
                }
            } else {
                this.setText(null);
            }
        }
    }
}

