/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.views;

import cms.tmx.control.dialog.DialogObj;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.http.api.strategy.dto.ObExecutionOtc;
import cms.tmx.http.workflow.dto.WorkflowAttachment;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.web.api.core.HttpClientService;
import java.io.InputStream;
import java.util.Collection;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import javax.inject.Inject;
import okhttp3.Response;

public class ExecutionDownDialog
extends DialogObj {
    @FXML
    private TableView<WorkflowAttachment> tableAttachment;
    @FXML
    private TableColumn<WorkflowAttachment, String> colFileName;
    @FXML
    private TableColumn<WorkflowAttachment, String> colType;
    @FXML
    private TableColumn<WorkflowAttachment, Object> colOperat;
    private ObExecutionOtc execution;
    @Inject
    private HttpClientService https;
    private ObservableList<WorkflowAttachment> attachmentList = FxUtils.newList();

    public ButtonType[] getTypes() {
        return new ButtonType[]{ButtonType.OK};
    }

    @FXML
    public void initialize() {
        this.createTable();
    }

    private void createTable() {
        this.colFileName.setCellValueFactory(data -> new SimpleStringProperty(((WorkflowAttachment)data.getValue()).getFileName()));
        this.colType.setCellValueFactory(data -> new SimpleStringProperty(((WorkflowAttachment)data.getValue()).getType()));
        this.colType.setCellFactory(cell -> new AttachTypeTableCell());
        this.colOperat.setCellValueFactory(data -> this.setOperation((WorkflowAttachment)data.getValue()));
        this.tableAttachment.setItems(this.attachmentList);
        this.tableAttachment.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableAttachment);
    }

    private ReadOnlyObjectWrapper<Object> setOperation(WorkflowAttachment attachment) {
        final String[] opStr = new String[]{""};
        HBox box = new HBox(){

            public String toString() {
                return opStr[0];
            }
        };
        Button btnDown = new Button("\u4e0b\u8f7d");
        btnDown.getStyleClass().add((Object)"btnOperation");
        box.setSpacing(10.0);
        box.setAlignment(Pos.CENTER);
        btnDown.setOnAction(event -> this.download(attachment));
        opStr[0] = "\u5220\u9664";
        box.getChildren().add((Object)btnDown);
        return new ReadOnlyObjectWrapper((Object)box);
    }

    private void download(WorkflowAttachment attachment) {
        try {
            Response response = this.https.doGet("/workflow/file/download?fileName=" + attachment.getId());
            InputStream body = response.body().byteStream();
            if (body != null) {
                ExcelUtils.saveFile((InputStream)body, (String)attachment.getFileName());
            }
        }
        catch (MException | Exception e) {
            e.printStackTrace();
        }
    }

    public void initialValues() {
        this.attachmentList.setAll((Collection)this.execution.getAttachments());
    }

    public ObservableList<WorkflowAttachment> getAttachmentList() {
        return this.attachmentList;
    }

    public void setAttachmentList(ObservableList<WorkflowAttachment> attachmentList) {
        this.attachmentList = attachmentList;
    }

    public ObExecutionOtc getExecution() {
        return this.execution;
    }

    public void setExecution(ObExecutionOtc execution) {
        this.execution = execution;
    }

    class AttachTypeTableCell<S>
    extends TableCell<S, String> {
        AttachTypeTableCell() {
        }

        public void updateItem(String item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty && item != null) {
                if ("confirmation".equals(item)) {
                    this.setText("\u4efd\u989d\u786e\u8ba4\u4e66");
                } else if ("oa".equals(item)) {
                    this.setText("OA");
                } else if ("contract".equals(item)) {
                    this.setText("\u5408\u540c");
                } else {
                    this.setText("");
                }
            } else {
                this.setText(null);
            }
        }
    }
}

