/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.CcsSubSecAccount;
import cms.tmx.entity.SecAccount;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.api.PositionNewServiceApi;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.api.strategy.dto.GetExtPositionsResp;
import cms.tmx.http.api.strategy.dto.GetPositionsReq;
import cms.tmx.http.api.strategy.dto.ObPosition;
import cms.tmx.http.api.strategy.dto.PositionNew;
import cms.tmx.http.base.AccntLevel;
import cms.tmx.http.query.Condition;
import cms.tmx.http.query.QueryFilter;
import cms.tmx.javafx.MxListDirty;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OtcMarketPositionModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(OtcMarketPositionModel.class);
    @Inject
    protected MObjFactory of;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    private OtcPortfolioAccountModel otcAccountModel;
    @Inject
    private IPortfolioApi portFolioApi;
    @Inject
    private IBaseApi iba;
    private Map<String, PPortfolio.Portfolio> portFolioMap = new HashMap<String, PPortfolio.Portfolio>();
    protected static final int FULL_QUERY_INTERVAL = 3000;
    protected MxListDirty<ObPosition> listSum = new MxListDirty();
    @Inject
    private HttpBaseApi httpApi;
    private Date date = new Date();
    private SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
    private String dateString = "";
    @Inject
    private PositionNewServiceApi api;
    private Map<String, Double> balanceMap = new HashMap<String, Double>();

    public Double getBalance(String key) {
        return this.balanceMap.get(key);
    }

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.query();
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuerySum();
            }
            catch (MException | Exception e) {
                logger.error("full query position failed", e);
            }
        });
    }

    private void fullQuerySum() throws MException, IOException {
        ObservableList fundList = FxUtils.newList();
        fundList.addAll(this.otcAccountModel.getSubFundSecMap().values());
        ArrayList<ObPosition> listOb = new ArrayList<ObPosition>();
        HashSet<String> fundIdSet = new HashSet<String>();
        for (List fund : fundList) {
            for (SecAccount secAccount : fund) {
                if (!(secAccount instanceof CcsSubSecAccount)) continue;
                CcsSubSecAccount subSecAccnt = (CcsSubSecAccount)CcsSubSecAccount.class.cast(secAccount);
                fundIdSet.add(subSecAccnt.getSubSecAccntId());
            }
        }
        if (fundIdSet.size() == 0) {
            return;
        }
        GetPositionsReq reqHis = new GetPositionsReq();
        reqHis.setOpUser(this.httpApi.getHttpOpUser());
        reqHis.setMarketGroup("CCS");
        reqHis.setApplId("810");
        reqHis.setAccntType(AccntType.ACCNT_TYPE_SEC);
        reqHis.setIncludeZero(Boolean.valueOf(true));
        reqHis.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
        reqHis.setAccntId(new ArrayList(fundIdSet));
        reqHis.setStartDate("");
        reqHis.setEndDate("");
        QueryFilter filter = new QueryFilter();
        HashMap<String, Condition> arg = new HashMap<String, Condition>();
        Condition market = new Condition();
        market.setStringVal("XOTC");
        market.setOp(Condition.OP.EQ);
        arg.put("market", market);
        filter.setArg(arg);
        reqHis.setFilter(filter);
        LinkedList respList = new LinkedList();
        Page httpDefPage = this.httpApi.getHttpDefPage();
        GetExtPositionsResp res = null;
        boolean flag = false;
        do {
            reqHis.setPage(httpDefPage);
            res = this.api.getPositions(reqHis);
            respList.addAll(res.getPosData());
            flag = res.isLast();
            if (flag) continue;
            httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
        } while (!flag);
        for (PositionNew position : respList) {
            CcsSubSecAccount sec;
            CcsSubFundAccount sub;
            if (position.getAccntId() != null && (sub = this.otcAccountModel.getSubFundAccountByParentId(position.getAccntId())) != null) {
                position.setInvestorId(sub.getInvestId());
            }
            if (position.getSecAccntId() != null && (sec = this.otcAccountModel.getSubSecAccountByIdAndMarket(position.getSecAccntId(), position.getInstrument().getMarket())) != null) {
                position.setInvestorSecId(sec.getInverstorSecId());
                position.setPortfolioId(sec.getPortfolioId());
                position.setPortfolioName(sec.getPortfolioName());
            }
            ObPosition ob = new ObPosition();
            ob.update((Object)position);
            String key = String.join((CharSequence)",", ob.getPortfolioId(), ob.getInstrument().getSecurityId());
            this.balanceMap.put(key, ob.getSecAvail());
            listOb.add(ob);
        }
        this.updateList(listOb);
    }

    protected void updateList(List<ObPosition> list) {
        this.listSum.update(list);
        this.changed();
    }

    public ObservableList<ObPosition> getSumList() {
        return this.listSum.getList();
    }
}

