/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.models;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.web.workflow.GetWorkflowLogReq;
import cms.tmx.entity.web.workflow.ObWorkflowLog;
import cms.tmx.entity.web.workflow.Result;
import cms.tmx.entity.web.workflow.WorkflowLog;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.query.otc.mng.OtcFundWorkflowLogMng;
import cms.tmx.utils.StringUtils;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OtcFundWorkflowLogModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(OtcFundWorkflowLogModel.class);
    protected MxList<ObWorkflowLog> list = new MxList();
    private static final int FULL_QUERY_INTERVAL = 3000;
    private String entryId;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    protected MObjFactory of;

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuery();
            }
            catch (MException e) {
                logger.error("OtcFundWorkflowLogModel query failed", (Throwable)e);
            }
        });
    }

    private void fullQuery() throws MException {
        LinkedList<ObWorkflowLog> listLog = new LinkedList<ObWorkflowLog>();
        OtcFundWorkflowLogMng logMng = this.getQuery();
        List<WorkflowLog> listQuery = logMng.query();
        listQuery.forEach(each -> {
            if (!StringUtils.isEmpty((String)each.getOpResult())) {
                each.setResult(Result.getResult((String)each.getOpResult()));
            }
            ObWorkflowLog log = new ObWorkflowLog();
            log.update(each);
            listLog.add(log);
        });
        this.update(listLog);
    }

    private synchronized OtcFundWorkflowLogMng getQuery() {
        if (this.entryId == null) {
            return null;
        }
        GetWorkflowLogReq req = new GetWorkflowLogReq();
        req.setWorkflowId(this.entryId);
        OtcFundWorkflowLogMng query = (OtcFundWorkflowLogMng)((Object)this.of.create(OtcFundWorkflowLogMng.class));
        query.setGetWorkflowLogReq(req);
        return query;
    }

    public ObservableList<ObWorkflowLog> getList() {
        return this.list.getList();
    }

    private synchronized void update(List<ObWorkflowLog> list) {
        this.list.setAll(list);
        this.changed();
    }

    public String getEntryId() {
        return this.entryId;
    }

    public void setEntryId(String entryId) {
        this.entryId = entryId;
    }
}

