/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.models;

import cms.tmx.api.mng.IBaseApi;
import cms.tmx.api.mng.IPortfolioApi;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.datatype.proto.portfolio.PPortfolio;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.http.api.core.ObPosDetailItem;
import cms.tmx.http.api.core.PosDetailItem;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.datahub.GetPosDetailReq;
import cms.tmx.http.api.datahub.QueryType;
import cms.tmx.javafx.MxListDirty;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.otc.api.OtcFundPositionApi;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
@Singleton
public class OtcFundPositionModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(OtcFundPositionModel.class);
    @Inject
    protected MObjFactory of;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    private OtcPortfolioAccountModel otcAccountModel;
    @Inject
    private IPortfolioApi portFolioApi;
    @Inject
    private IBaseApi iba;
    private Map<String, PPortfolio.Portfolio> portFolioMap = new HashMap<String, PPortfolio.Portfolio>();
    protected static final int FULL_QUERY_INTERVAL = 3000;
    protected MxListDirty<ObPosDetailItem> listDetail = new MxListDirty();
    protected MxListDirty<ObPosDetailItem> listSum = new MxListDirty();
    private Map<String, Double> balanceMap = new HashMap<String, Double>();

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                this.fullQuerySum();
                this.fullQueryDetail();
            }
            catch (MException | Exception e) {
                logger.error("full query position failed", e);
            }
        });
    }

    private void fullQueryDetail() throws MException {
        ObservableList fundList = FxUtils.newList();
        fundList.addAll(this.otcAccountModel.getFundAccounts());
        ArrayList<ObPosDetailItem> listOb = new ArrayList<ObPosDetailItem>();
        HashSet<String> fundIdSet = new HashSet<String>();
        for (CcsSubFundAccount fund : fundList) {
            fundIdSet.add(fund.getPortfolioId());
        }
        ArrayList<PosDetailItem> listSrc = new ArrayList<PosDetailItem>();
        GetPosDetailReq req = (GetPosDetailReq)this.of.create(GetPosDetailReq.class);
        req.setQueryType(QueryType.QUERY_TYPE_DETAIL);
        req.setPortfolioIds(new ArrayList(fundIdSet));
        OtcFundPositionApi service = (OtcFundPositionApi)((Object)this.of.create(OtcFundPositionApi.class));
        listSrc.addAll(service.getPositionDetail(req));
        listSrc.forEach(each -> {
            if (each.getInstrument().getSecuritySubType() != null) {
                each.setSecSubType(SecSubType.get((String)each.getInstrument().getSecuritySubType()));
            }
            each.setYield((double)Math.round(each.getYield() * 10000.0) / 100.0);
            ObPosDetailItem pos = new ObPosDetailItem();
            pos.update(each);
            String key = String.join((CharSequence)",", pos.getPortfolioId(), pos.getInstrument().getSecId());
            this.balanceMap.put(key, pos.getBalance());
            listOb.add(pos);
        });
        this.updateDetail(listOb);
    }

    public Double getBalance(String key) {
        return this.balanceMap.get(key);
    }

    private void fullQuerySum() throws MException {
        ObservableList fundList = FxUtils.newList();
        fundList.addAll(this.otcAccountModel.getFundAccounts());
        ArrayList<ObPosDetailItem> listOb = new ArrayList<ObPosDetailItem>();
        HashSet<String> fundIdSet = new HashSet<String>();
        for (CcsSubFundAccount fund : fundList) {
            fundIdSet.add(fund.getPortfolioId());
        }
        ArrayList<PosDetailItem> listSrc = new ArrayList<PosDetailItem>();
        GetPosDetailReq req = (GetPosDetailReq)this.of.create(GetPosDetailReq.class);
        req.setQueryType(QueryType.QUERY_TYPE_SUMMARY);
        req.setPortfolioIds(new ArrayList(fundIdSet));
        OtcFundPositionApi service = (OtcFundPositionApi)((Object)this.of.create(OtcFundPositionApi.class));
        listSrc.addAll(service.getPositionDetail(req));
        listSrc.forEach(each -> {
            if (each.getInstrument().getSecuritySubType() != null) {
                each.setSecSubType(SecSubType.get((String)each.getInstrument().getSecuritySubType()));
            }
            each.setYield((double)Math.round(each.getYield() * 10000.0) / 100.0);
            each.getObject().setConcentration((double)Math.round(each.getObject().getConcentration() * 10000.0) / 100.0);
            ObPosDetailItem pos = new ObPosDetailItem();
            pos.update(each);
            listOb.add(pos);
        });
        this.updateSum(listOb);
    }

    protected void updateDetail(List<ObPosDetailItem> listPos) {
        this.listDetail.update(listPos);
        this.changed();
    }

    protected void updateSum(List<ObPosDetailItem> listPos) {
        this.listSum.update(listPos);
        this.changed();
    }

    public ObservableList<ObPosDetailItem> getDetailList() {
        return this.listDetail.getList();
    }

    public ObservableList<ObPosDetailItem> getSumList() {
        return this.listSum.getList();
    }
}

