/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.models;

import cms.tmx.core.MEvent;
import cms.tmx.core.MEventService;
import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.core.MScheduler;
import cms.tmx.entity.CcsSubFundAccount;
import cms.tmx.entity.trade.instruction.ObInstruction;
import cms.tmx.http.api.core.SecSubType;
import cms.tmx.http.api.strategy.dto.ExecEvent;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.api.strategy.dto.ObExecutionOtc;
import cms.tmx.http.query.GetExecutionsReq;
import cms.tmx.http.workflow.dto.WorkflowAttachment;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.obj.MxObject;
import cms.tmx.javafx.utils.FxUtils;
import cms.tmx.manage.IUserService;
import cms.tmx.query.current.models.OtcPortfolioAccountModel;
import cms.tmx.query.otc.api.OtcFundExecutionApi;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OtcFundExecutionModel
extends MxModel {
    private static final Logger logger = LogManager.getLogger(OtcFundExecutionModel.class);
    @Inject
    protected MObjFactory of;
    @Inject
    protected MScheduler sdFullQuery;
    @Inject
    private OtcPortfolioAccountModel otcAccountModel;
    @Inject
    private MEventService es;
    @Inject
    private IUserService userService;
    protected static final int FULL_QUERY_INTERVAL = 3000;
    protected MxList<ObExecutionOtc> list = new MxList();
    private ObInstruction obInstruction;
    private static final Gson gson = new Gson();
    DateFormat format = new SimpleDateFormat("yyyyMMdd");

    @PostConstruct
    public void init() {
        this.sdFullQuery.setInterval(3000);
        this.es.subscribe("uap.push.ExecEvent", e -> this.onPush(e));
    }

    private void onPush(MEvent event) {
        JsonObject obj = (JsonObject)event.getObj();
        ExecEvent execEvent = (ExecEvent)gson.fromJson((JsonElement)obj, ExecEvent.class);
        for (Execution each : execEvent.getExecution()) {
            if (!"OTC".equals(each.getInstrument().getMarketGroup())) continue;
            if (!StringUtils.isEmpty((String)each.getAttachment())) {
                each.setAttachments(Arrays.asList((WorkflowAttachment[])gson.fromJson(each.getAttachment(), WorkflowAttachment[].class)));
            }
            if (!StringUtils.isEmpty((String)each.getInstrument().getSecuritySubType())) {
                each.setSecSubType(SecSubType.get((String)each.getInstrument().getSecuritySubType()));
            }
            ObExecutionOtc exec = new ObExecutionOtc();
            exec.update((Object)each);
            exec.setUserId(this.userService.getUserName(exec.getUserId()).getValue());
            this.list.add((MxObject)exec);
        }
        this.changed();
    }

    public void query() {
        this.sdFullQuery.schedule(event -> {
            try {
                if (this.obInstruction != null) {
                    String begin = "";
                    if (this.obInstruction.getBeginTime().length() > 7) {
                        begin = this.obInstruction.getBeginTime().substring(0, 8);
                    }
                    this.instructionQuery("", "", this.obInstruction.getId(), begin);
                } else {
                    this.fullQuery();
                }
            }
            catch (MException | Exception e) {
                logger.error("full query execution failed", e);
            }
        });
    }

    private void fullQuery() throws MException {
        ObservableList fundList = FxUtils.newList();
        fundList.addAll(this.otcAccountModel.getFundAccounts());
        for (CcsSubFundAccount fund : fundList) {
            if (!"OTC".equals(fund.getMarketGrp()) && !"CCS".equals(fund.getMarketGrp())) continue;
            this.instructionQuery(fund.getNewCashAccntId(), fund.getSubAccntId(), "", "");
        }
    }

    private void instructionQuery(String extAccntId, String subAccntId, String instructionId, String begin) throws MException {
        ArrayList<Execution> listSrc = new ArrayList<Execution>();
        ArrayList<ObExecutionOtc> listOb = new ArrayList<ObExecutionOtc>();
        GetExecutionsReq req = (GetExecutionsReq)this.of.create(GetExecutionsReq.class);
        req.setInstructionId(instructionId);
        req.setSubCashAccntId(Arrays.asList(subAccntId));
        if (!StringUtils.isEmpty((String)begin)) {
            req.setBeginDate(begin);
        } else {
            String today = this.format.format(new Date());
            req.setBeginDate(today);
        }
        OtcFundExecutionApi service = (OtcFundExecutionApi)((Object)this.of.create(OtcFundExecutionApi.class));
        req.setMarketGrp("OTC");
        listSrc.addAll(service.getExecution(req));
        listSrc.forEach(each -> {
            if (!StringUtils.isEmpty((String)each.getAttachment())) {
                each.setAttachments(Arrays.asList((WorkflowAttachment[])gson.fromJson(each.getAttachment(), WorkflowAttachment[].class)));
            }
            if (!StringUtils.isEmpty((String)each.getInstrument().getSecuritySubType())) {
                each.setSecSubType(SecSubType.get((String)each.getInstrument().getSecuritySubType()));
            }
            ObExecutionOtc exec = new ObExecutionOtc();
            exec.update(each);
            exec.setUserId(this.userService.getUserName(exec.getUserId()).getValue());
            listOb.add(exec);
        });
        this.updateList(listOb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateList(List<ObExecutionOtc> list) {
        ObservableList observableList = this.list.getList();
        synchronized (observableList) {
            list.addAll((Collection<ObExecutionOtc>)this.list.getList());
        }
        this.list.update(list);
        this.changed();
    }

    public ObservableList<ObExecutionOtc> getList() {
        return this.list.getList();
    }

    public ObInstruction getObInstruction() {
        return this.obInstruction;
    }

    public void setObInstruction(ObInstruction obInstruction) {
        this.obInstruction = obInstruction;
    }
}

