/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.api;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.core.PosDetailItem;
import cms.tmx.http.api.datahub.GetPosDetailReq;
import cms.tmx.http.api.datahub.GetPosDetailResp;
import cms.tmx.http.api.strategy.dto.AccntType;
import cms.tmx.http.base.AccntLevel;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OtcFundPositionApi
extends HttpService {
    @Inject
    protected MObjFactory of;
    @Inject
    private HttpBaseApi httpBase;
    private Gson gson = new Gson();

    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/datahub/PositionService";
    }

    public List<PosDetailItem> getPositionDetail(GetPosDetailReq req) throws MException {
        LinkedList<PosDetailItem> list = new LinkedList<PosDetailItem>();
        if (req.getPortfolioIds() == null || req.getPortfolioIds().isEmpty()) {
            return list;
        }
        Page httpDefPage = this.httpBase.getHttpDefPage();
        req.setOpUser(this.httpBase.getHttpOpUser());
        req.setMarketGroup("OTC");
        req.setAccntType(AccntType.ACCNT_TYPE_SEC);
        req.setAccntLevel(AccntLevel.ACCNT_LEVEL_SUB);
        boolean flag = false;
        do {
            req.setPage(httpDefPage);
            String json = this.gson.toJson((Object)req);
            String respBody = this.doPost("GetPositionDetails", json);
            GetPosDetailResp resp = new GetPosDetailResp();
            if (respBody == null) {
                return list;
            }
            resp = (GetPosDetailResp)this.gson.fromJson(respBody, GetPosDetailResp.class);
            this.checkStatus(resp.getStatus());
            if (resp.getDetails() == null) {
                return list;
            }
            list.addAll(resp.getDetails());
            boolean bl = flag = resp.getPage().getTotalRow() > resp.getPage().getStartRow() + resp.getPage().getPageSize() - 1;
            if (!flag) continue;
            httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
        } while (flag);
        return list;
    }
}

