/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.otc.api;

import cms.tmx.core.MException;
import cms.tmx.core.MObjFactory;
import cms.tmx.http.api.HttpBaseApi;
import cms.tmx.http.api.HttpService;
import cms.tmx.http.api.Page;
import cms.tmx.http.api.strategy.dto.Execution;
import cms.tmx.http.query.GetExecutionsReq;
import cms.tmx.http.query.GetExecutionsResp;
import cms.tmx.utils.StringUtils;
import com.google.gson.Gson;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.core.di.annotations.Creatable;

@Creatable
public class OtcFundExecutionApi
extends HttpService {
    private static final Logger logger = LogManager.getLogger(OtcFundExecutionApi.class);
    @Inject
    protected MObjFactory of;
    @Inject
    private HttpBaseApi httpBase;
    private Gson gson = new Gson();

    @PostConstruct
    protected void init() {
        super.init();
        this.url = String.valueOf(this.url) + "/proto/orderhub/OrderService";
    }

    public List<Execution> getExecution(GetExecutionsReq req) throws MException {
        LinkedList<Execution> list = new LinkedList<Execution>();
        Page httpDefPage = this.httpBase.getHttpDefPage();
        req.setOpUser(this.httpBase.getHttpOpUser());
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
        if (StringUtils.isEmpty((String)req.getBeginDate())) {
            req.setBeginDate(today.format(formatter));
        }
        if (!"0".equals(req.getEndDate())) {
            req.setEndDate(today.format(formatter));
        } else {
            req.setEndDate("");
        }
        boolean flag = false;
        do {
            req.setPage(httpDefPage);
            String json = this.gson.toJson((Object)req);
            String respBody = this.doPost("GetExecutions", json);
            GetExecutionsResp resp = new GetExecutionsResp();
            if (respBody == null) {
                return list;
            }
            resp = (GetExecutionsResp)this.gson.fromJson(respBody, GetExecutionsResp.class);
            this.checkStatus(resp.getStatus());
            if (resp.getExecution() == null) {
                return list;
            }
            list.addAll(resp.getExecution());
            boolean bl = flag = resp.getPage().getTotalRow() > resp.getPage().getStartRow() + resp.getPage().getPageSize() - 1;
            if (!flag) continue;
            httpDefPage.setStartRow(httpDefPage.getPageSize() + httpDefPage.getStartRow());
        } while (flag);
        return list;
    }
}

