/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views.xt;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.query.ObSofp;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.margin.models.xt.RateModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class RatePart
extends MxPart {
    @FXML
    private TableView<ObSofp> tableRate;
    @FXML
    private TableColumn<ObSofp, String> colAccId;
    @FXML
    private TableColumn<ObSofp, Number> colCashIntrrate;
    @FXML
    private TableColumn<ObSofp, Number> colStkIntrrate;
    @FXML
    private TextField searchText;
    @Inject
    private RateModel model;
    private static final Logger logger = LogManager.getLogger(RatePart.class);
    @Inject
    private MxAlert alert;
    private MxList<ObSofp> mxList = new MxList();
    private Predicate<ObSofp> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObSofp)en)) {
            return false;
        }
        if (en.getInvestorId().contains(text)) {
            return true;
        }
        return this.extend((ObSofp)en);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        ObservableList<ObSofp> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
    };

    public boolean premise(ObSofp sofp) {
        return true;
    }

    public boolean extend(ObSofp sofp) {
        return false;
    }

    @Focus
    public void onFocus() {
        this.tableRate.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<ObSofp> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObSofp> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObSofp>)this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> this.tableRate.sort());
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableRate);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableRate, (String)"\u5e74\u5229\u7387\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        this.colAccId.setCellValueFactory(data -> ((ObSofp)data.getValue()).investorIdProperty());
        this.colCashIntrrate.setCellValueFactory(data -> ((ObSofp)data.getValue()).cashIntrrateProperty());
        this.colCashIntrrate.setCellFactory(data -> new PriceCell());
        this.colStkIntrrate.setCellValueFactory(data -> ((ObSofp)data.getValue()).stkIntrrateProperty());
        this.colStkIntrrate.setCellFactory(data -> new PriceCell());
        this.tableRate.setItems(this.mxList.getList());
        this.tableRate.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableRate);
    }

    private class PriceCell
    extends DoubleTableCell<ObSofp> {
        int scale = 4;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

