/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views.xt;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.query.margin.ObPledgeSecurity;
import cms.tmx.http.query.marginxt.XtPledgeSecurity;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.margin.models.xt.PledgeModel;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PledgeSecurityPart
extends MxPagePart<XtPledgeSecurity, ObPledgeSecurity> {
    @FXML
    private TableView<ObPledgeSecurity> tableView;
    @FXML
    private TableColumn<ObPledgeSecurity, Number> pledgeRate;
    @FXML
    protected TextField searchText;
    @Inject
    protected PledgeModel model;
    @Inject
    private MxAlert alert;
    private static final Logger logger = LogManager.getLogger(PledgeSecurityPart.class);

    protected boolean predicate(XtPledgeSecurity data) {
        String text = this.searchText.getText().trim();
        return data.getSecurityId().contains(text);
    }

    @FXML
    public void refresh() {
        this.exe.execute(() -> this.model.query());
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableView, (List)listOrder, (String)"\u62c5\u4fdd\u54c1\u67e5\u8be2");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.pledgeRate.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.setPlaceholder((Node)new Label());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
    }

    protected List<XtPledgeSecurity> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }
}

