/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views.xt;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.api.strategy.dto.ObPositionMargin;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.margin.models.xt.MarginPositionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;
import org.eclipse.e4.ui.di.Focus;

public class MarginPositionPart
extends MxPart {
    @FXML
    private TableView<ObPositionMargin> tablePosition;
    @FXML
    private TableColumn<ObPositionMargin, String> colAccId;
    @FXML
    private TableColumn<ObPositionMargin, String> colSecAcc;
    @FXML
    private TableColumn<ObPositionMargin, String> colSecId;
    @FXML
    private TableColumn<ObPositionMargin, String> colSecName;
    @FXML
    private TableColumn<ObPositionMargin, MxNode> colMarket;
    @FXML
    private TableColumn<ObPositionMargin, Number> colBuyIn;
    @FXML
    private TableColumn<ObPositionMargin, Number> colSellOut;
    @FXML
    private TableColumn<ObPositionMargin, Number> colMarketValue;
    @FXML
    private TableColumn<ObPositionMargin, Number> colSecBalance;
    @FXML
    private TableColumn<ObPositionMargin, Number> colSecAvail;
    @FXML
    protected TableColumn<ObPositionMargin, String> colUnit;
    @FXML
    private TextField searchText;
    @FXML
    protected ComboBox<MxNode> cmbFilter;
    @FXML
    protected CheckComboBox<String> ccmbAccnt;
    @FXML
    protected Label lbAccnt;
    @FXML
    protected CheckComboBox<MxNode> ccmbMarket;
    @FXML
    protected Label lbMarket;
    @FXML
    protected CheckComboBox<String> ccmbSecAcc;
    @FXML
    protected Label lbSecAcc;
    protected String filterType = "";
    protected boolean accFalg = false;
    protected boolean secAccFalg = false;
    protected boolean marketFalg = false;
    protected Set<String> secIds = new HashSet<String>();
    protected Set<String> accIds = new HashSet<String>();
    @Inject
    private IFundAccountService fundService;
    @Inject
    private MarginPositionModel model;
    private static final Logger logger = LogManager.getLogger(MarginPositionPart.class);
    @Inject
    private MxAlert alert;
    private MxList<ObPositionMargin> mxList = new MxList();
    private Predicate<ObPositionMargin> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObPositionMargin)en)) {
            return false;
        }
        if (en.getInstrument().getSecId().contains(text)) {
            return true;
        }
        if (en.getInstrument().getSymbol().contains(text)) {
            return true;
        }
        return this.extend((ObPositionMargin)en);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener listenerSearch = ob -> {
        ObservableList<ObPositionMargin> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
    };

    public boolean premise(ObPositionMargin ob) {
        if ("".equals(this.filterType)) {
            return true;
        }
        switch (this.filterType) {
            case "1": {
                return this.accIds.contains("\u5168\u90e8") || this.accIds.contains(ob.getInvestorId());
            }
            case "2": {
                return this.secIds.contains("\u5168\u90e8") || this.secIds.contains(ob.getInverstorSecId());
            }
            case "3": {
                ObservableList listMarket = this.ccmbMarket.getCheckModel().getCheckedItems();
                for (MxNode mxNode : listMarket) {
                    if (!"XALL".equals(mxNode.getRaw())) continue;
                    return true;
                }
                for (MxNode mktNode : listMarket) {
                    if (!mktNode.getRaw().equals(ob.getInstrument().getMarket().getRaw())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    public boolean extend(ObPositionMargin obj) {
        return false;
    }

    @Focus
    public void onFocus() {
        this.tablePosition.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<ObPositionMargin> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObPositionMargin> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObPositionMargin>)this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> this.tablePosition.sort());
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
        this.initCheckComboBox();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.listenerSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.listenerSearch);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tablePosition);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tablePosition, (String)"\u878d\u8d44\u878d\u5238\u6301\u4ed3\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        this.colAccId.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).investorIdProperty());
        this.colSecAcc.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).inverstorSecIdProperty());
        this.colSecId.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().secIdProperty());
        this.colSecName.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().symbolProperty());
        this.colMarket.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).getInstrument().marketProperty());
        this.colBuyIn.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).buyInProperty());
        this.colBuyIn.setCellFactory(data -> new NumberTableCell());
        this.colSellOut.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).sellOutProperty());
        this.colSellOut.setCellFactory(data -> new NumberTableCell());
        this.colMarketValue.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).marketValueProperty());
        this.colMarketValue.setCellFactory(data -> new DoubleTableCell());
        this.colSecBalance.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secBalanceProperty());
        this.colSecBalance.setCellFactory(data -> new NumberTableCell());
        this.colSecAvail.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).secAvailProperty());
        this.colSecAvail.setCellFactory(data -> new NumberTableCell());
        this.colUnit.setCellValueFactory(data -> ((ObPositionMargin)data.getValue()).unitProperty());
        this.tablePosition.setItems(this.mxList.getList());
        this.tablePosition.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tablePosition);
    }

    protected void initCheckComboBox() {
        this.initFilterAcc();
        this.initFilterSecAcc();
        this.initFilterMarket();
        MxNode filterTypeNode = MxNodeFactory.createNew((String)"pos_filter_type");
        this.cmbFilter.getItems().addAll((Collection)filterTypeNode.getNodes());
        this.cmbFilter.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                this.filterType = "";
                return;
            }
            this.filterType = newV.getRaw();
            switch (newV.getRaw()) {
                case "1": {
                    this.ccmbAccnt.setVisible(true);
                    this.lbAccnt.setVisible(true);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "2": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(true);
                    this.lbSecAcc.setVisible(true);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "3": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(true);
                    this.lbMarket.setVisible(true);
                    break;
                }
            }
            this.listenerSearch.invalidated(null);
        });
        this.cmbFilter.getSelectionModel().select(0);
        this.listenerSearch.invalidated(null);
        this.accFalg = true;
        this.marketFalg = true;
        this.secAccFalg = true;
    }

    protected void initFilterAcc() {
        LinkedList<String> listAccnt = new LinkedList<String>();
        listAccnt.add("\u5168\u90e8");
        this.fundService.getMarginFundAccountList().forEach(fund -> {
            boolean bl = listAccnt.add(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName());
        });
        this.ccmbAccnt.getItems().addAll(listAccnt);
        this.ccmbAccnt.getCheckModel().checkAll();
        int i = 1;
        while (i < listAccnt.size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.listenerSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.listenerSearch.invalidated(null);
                this.accFalg = true;
            }
        });
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (String id : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(id.split("__")[0]);
            }
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    protected void initFilterSecAcc() {
        LinkedList<String> listSecAccnt = new LinkedList<String>();
        listSecAccnt.add("\u5168\u90e8");
        listSecAccnt.addAll(this.model.getInvestorSecIds());
        this.ccmbSecAcc.getItems().addAll(listSecAccnt);
        this.ccmbSecAcc.getCheckModel().checkAll();
        this.lbSecAcc.setText("\u5168\u90e8");
        this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
        this.secIds.clear();
        for (String secAccount : listSecAccnt) {
            this.secIds.add(secAccount);
        }
        int i = 1;
        while (i < listSecAccnt.size()) {
            this.ccmbSecAcc.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.secAccFalg) {
                    this.secAccFalg = false;
                    if (!now.booleanValue() && this.ccmbSecAcc.getItemBooleanProperty(0).get()) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbSecAcc.getItems().size() - this.ccmbSecAcc.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(true);
                    }
                    this.listenerSearch.invalidated(null);
                    this.secAccFalg = true;
                }
            });
            ++i;
        }
        this.ccmbSecAcc.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.secAccFalg) {
                this.secAccFalg = false;
                if (now.booleanValue()) {
                    this.ccmbSecAcc.getCheckModel().checkAll();
                } else {
                    this.ccmbSecAcc.getCheckModel().clearChecks();
                }
                this.listenerSearch.invalidated(null);
                this.secAccFalg = true;
            }
        });
        this.ccmbSecAcc.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbSecAcc.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbSecAcc.setText(accStr);
            this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
            this.secIds.clear();
            this.secIds.addAll((Collection<String>)this.ccmbSecAcc.getCheckModel().getCheckedItems());
        });
    }

    protected void initFilterMarket() {
        MxNode marketNode = MxNodeFactory.createNew((String)"ccs_pos_market_code");
        this.ccmbMarket.getItems().addAll((Collection)marketNode.getNodes());
        this.ccmbMarket.getCheckModel().checkAll();
        MxNode nodeAll = (MxNode)marketNode.getNodes().get(0);
        int i = 1;
        while (i < marketNode.getNodes().size()) {
            this.ccmbMarket.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.marketFalg) {
                    this.marketFalg = false;
                    if (!now.booleanValue() && this.ccmbMarket.getItemBooleanProperty(0).get()) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbMarket.getItems().size() - this.ccmbMarket.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(true);
                    }
                    this.listenerSearch.invalidated(null);
                    this.marketFalg = true;
                }
            });
            ++i;
        }
        this.ccmbMarket.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.marketFalg) {
                this.marketFalg = false;
                if (now.booleanValue()) {
                    this.ccmbMarket.getCheckModel().checkAll();
                } else {
                    this.ccmbMarket.getCheckModel().clearChecks();
                }
                this.listenerSearch.invalidated(null);
                this.marketFalg = true;
            }
        });
        this.ccmbMarket.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbMarket.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(nodeAll)) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbMarket.setText(accStr);
            this.lbMarket.setTooltip(new Tooltip(this.lbMarket.getText()));
        });
        this.ccmbMarket.getCheckModel().checkAll();
    }
}

