/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views.xt;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.entity.data.RefItem;
import cms.tmx.http.api.strategy.dto.ObExecutionMargin;
import cms.tmx.http.query.marginxt.XtExecution;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.margin.models.xt.MarginDealModel;
import cms.tmx.utils.StringUtils;
import cmx.tmx.data.IRefDataMng;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;
import org.controlsfx.control.CheckComboBox;

public class MarginDealPart
extends MxPagePart<XtExecution, ObExecutionMargin> {
    @FXML
    private TableView<ObExecutionMargin> tableView;
    @FXML
    private TableColumn<ObExecutionMargin, Number> lastAmount;
    @FXML
    private TableColumn<ObExecutionMargin, Number> lastPx;
    @FXML
    private TableColumn<ObExecutionMargin, Number> lastQty;
    @FXML
    protected ComboBox<MxNode> cmbFilter;
    @FXML
    protected CheckComboBox<String> ccmbAccnt;
    @FXML
    protected Label lbAccnt;
    @FXML
    protected CheckComboBox<MxNode> ccmbMarket;
    @FXML
    protected Label lbMarket;
    @FXML
    protected CheckComboBox<String> ccmbSecAcc;
    @FXML
    protected Label lbSecAcc;
    protected String filterType = "";
    protected boolean accFalg = false;
    protected boolean secAccFalg = false;
    protected boolean marketFalg = false;
    protected Set<String> secIds = new HashSet<String>();
    protected Set<String> accIds = new HashSet<String>();
    @Inject
    private IFundAccountService fundService;
    @Inject
    private MarginDealModel model;
    @Inject
    private IRefDataMng refMng;
    @Inject
    private MxAlert alert;

    @FXML
    protected void initialize() {
        super.initialize();
        this.initCheckComboBox();
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            this.logger.error(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableView, (List)listExec, (String)"\u878d\u8d44\u878d\u5238\u6210\u4ea4\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.lastAmount.setCellFactory(data -> new PriceCell());
        this.lastPx.setCellFactory(data -> new PriceCell());
        this.lastQty.setCellFactory(data -> new NumberTableCell());
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableView);
    }

    protected boolean predicate(XtExecution t) {
        String text = this.searchText.getText().trim();
        if (!this.premise(t)) {
            return false;
        }
        return t.getSecurityId().contains(text) || t.getSecurityName().contains(text) || t.getInvestorId().contains(text);
    }

    protected boolean premise(XtExecution xt) {
        if ("".equals(this.filterType)) {
            return true;
        }
        switch (this.filterType) {
            case "1": {
                return this.accIds.contains("\u5168\u90e8") || this.accIds.contains(xt.getInvestorId());
            }
            case "2": {
                return this.secIds.contains("\u5168\u90e8") || this.secIds.contains(xt.getInvestorSecId());
            }
            case "3": {
                ObservableList listMarket = this.ccmbMarket.getCheckModel().getCheckedItems();
                for (MxNode mxNode : listMarket) {
                    if (!"XALL".equals(mxNode.getRaw())) continue;
                    return true;
                }
                for (MxNode mktNode : listMarket) {
                    if (!mktNode.getRaw().equals(xt.getInstrument().getMarket())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    protected void initCheckComboBox() {
        this.initFilterAcc();
        this.initFilterSecAcc();
        this.initFilterMarket();
        MxNode filterTypeNode = MxNodeFactory.createNew((String)"pos_filter_type");
        this.cmbFilter.getItems().addAll((Collection)filterTypeNode.getNodes());
        this.cmbFilter.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                this.filterType = "";
                return;
            }
            this.filterType = newV.getRaw();
            switch (newV.getRaw()) {
                case "1": {
                    this.ccmbAccnt.setVisible(true);
                    this.lbAccnt.setVisible(true);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "2": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(true);
                    this.lbSecAcc.setVisible(true);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "3": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbSecAcc.setVisible(false);
                    this.lbSecAcc.setVisible(false);
                    this.ccmbMarket.setVisible(true);
                    this.lbMarket.setVisible(true);
                    break;
                }
            }
            this.listenerSearch.invalidated(null);
        });
        this.cmbFilter.getSelectionModel().select(0);
        this.listenerSearch.invalidated(null);
        this.accFalg = true;
        this.marketFalg = true;
        this.secAccFalg = true;
    }

    protected void initFilterAcc() {
        LinkedList<String> listAccnt = new LinkedList<String>();
        listAccnt.add("\u5168\u90e8");
        this.fundService.getMarginFundAccountList().forEach(fund -> {
            boolean bl = listAccnt.add(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName());
        });
        this.ccmbAccnt.getItems().addAll(listAccnt);
        this.ccmbAccnt.getCheckModel().checkAll();
        int i = 1;
        while (i < listAccnt.size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.listenerSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.listenerSearch.invalidated(null);
                this.accFalg = true;
            }
        });
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (String id : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(id.split("__")[0]);
            }
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    protected void initFilterSecAcc() {
        LinkedList<String> listSecAccnt = new LinkedList<String>();
        listSecAccnt.add("\u5168\u90e8");
        listSecAccnt.addAll(this.model.getInvestorSecIds());
        this.ccmbSecAcc.getItems().addAll(listSecAccnt);
        this.ccmbSecAcc.getCheckModel().checkAll();
        this.lbSecAcc.setText("\u5168\u90e8");
        this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
        this.secIds.clear();
        for (String secAccount : listSecAccnt) {
            this.secIds.add(secAccount);
        }
        int i = 1;
        while (i < listSecAccnt.size()) {
            this.ccmbSecAcc.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.secAccFalg) {
                    this.secAccFalg = false;
                    if (!now.booleanValue() && this.ccmbSecAcc.getItemBooleanProperty(0).get()) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbSecAcc.getItems().size() - this.ccmbSecAcc.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbSecAcc.getItemBooleanProperty(0).set(true);
                    }
                    this.listenerSearch.invalidated(null);
                    this.secAccFalg = true;
                }
            });
            ++i;
        }
        this.ccmbSecAcc.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.secAccFalg) {
                this.secAccFalg = false;
                if (now.booleanValue()) {
                    this.ccmbSecAcc.getCheckModel().checkAll();
                } else {
                    this.ccmbSecAcc.getCheckModel().clearChecks();
                }
                this.listenerSearch.invalidated(null);
                this.secAccFalg = true;
            }
        });
        this.ccmbSecAcc.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbSecAcc.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbSecAcc.setText(accStr);
            this.lbSecAcc.setTooltip(new Tooltip(this.lbSecAcc.getText()));
            this.secIds.clear();
            this.secIds.addAll((Collection<String>)this.ccmbSecAcc.getCheckModel().getCheckedItems());
        });
    }

    protected void initFilterMarket() {
        MxNode marketNode = MxNodeFactory.createNew((String)"ccs_pos_market_code");
        this.ccmbMarket.getItems().addAll((Collection)marketNode.getNodes());
        this.ccmbMarket.getCheckModel().checkAll();
        MxNode nodeAll = (MxNode)marketNode.getNodes().get(0);
        int i = 1;
        while (i < marketNode.getNodes().size()) {
            this.ccmbMarket.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.marketFalg) {
                    this.marketFalg = false;
                    if (!now.booleanValue() && this.ccmbMarket.getItemBooleanProperty(0).get()) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbMarket.getItems().size() - this.ccmbMarket.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(true);
                    }
                    this.listenerSearch.invalidated(null);
                    this.marketFalg = true;
                }
            });
            ++i;
        }
        this.ccmbMarket.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.marketFalg) {
                this.marketFalg = false;
                if (now.booleanValue()) {
                    this.ccmbMarket.getCheckModel().checkAll();
                } else {
                    this.ccmbMarket.getCheckModel().clearChecks();
                }
                this.listenerSearch.invalidated(null);
                this.marketFalg = true;
            }
        });
        this.ccmbMarket.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbMarket.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(nodeAll)) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbMarket.setText(accStr);
            this.lbMarket.setTooltip(new Tooltip(this.lbMarket.getText()));
        });
        this.ccmbMarket.getCheckModel().checkAll();
    }

    protected List<XtExecution> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o2.getExecTime().compareTo(o1.getExecTime()));
    }

    private class PriceCell
    extends DoubleTableCell<ObExecutionMargin> {
        int scale = 3;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                RefItem refItem;
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                ObExecutionMargin exec = (ObExecutionMargin)ObExecutionMargin.class.cast(this.getTableRow().getItem());
                if (exec.getInstrument().getSecurityId() != null && exec.getInstrument().getSecurityType() != null && (refItem = MarginDealPart.this.refMng.getItem(exec.getInstrument().getSecurityType(), exec.getInstrument().getMarket(), exec.getInstrument().getSecurityId())) != null) {
                    this.scale = refItem.getScale();
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

