/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views.xt;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.query.ObSofp;
import cms.tmx.javafx.MxList;
import cms.tmx.javafx.MxPart;
import cms.tmx.query.margin.models.xt.MarginAccountModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.e4.ui.di.Focus;

public class MarginAccountDetailPart
extends MxPart {
    @FXML
    private TableView<ObSofp> tableMarginAccount;
    @FXML
    private TableColumn<ObSofp, String> colAccId;
    @FXML
    private TableColumn<ObSofp, Number> colFundAvail;
    @FXML
    private TableColumn<ObSofp, Number> colAvailable;
    @FXML
    private TableColumn<ObSofp, Number> colMarginAvl;
    @FXML
    private TableColumn<ObSofp, Number> colFcreditAvl;
    @FXML
    private TableColumn<ObSofp, Number> colDcreditAvl;
    @FXML
    private TableColumn<ObSofp, Number> colFtotalDebts;
    @FXML
    private TableColumn<ObSofp, Number> colDtotalDebts;
    @FXML
    private TableColumn<ObSofp, Number> colCreditFundOrgDebt;
    @FXML
    private TableColumn<ObSofp, Number> colCreditStockOrgDebt;
    @FXML
    private TableColumn<ObSofp, Number> colCreditFundFee;
    @FXML
    private TableColumn<ObSofp, Number> colCreditStockFee;
    @FXML
    private TableColumn<ObSofp, Number> colKeepMarginRate;
    @FXML
    private TableColumn<ObSofp, Number> colNetAsset;
    @FXML
    private TableColumn<ObSofp, Number> colTotalAsset;
    @FXML
    private TextField searchText;
    @Inject
    private MarginAccountModel model;
    private static final Logger logger = LogManager.getLogger(MarginAccountDetailPart.class);
    @Inject
    private MxAlert alert;
    private MxList<ObSofp> mxList = new MxList();
    private Predicate<ObSofp> pd = en -> {
        String text = this.searchText.getText().trim();
        if (!this.premise((ObSofp)en)) {
            return false;
        }
        if (en.getInvestorId() != null && en.getInvestorId().contains(text)) {
            return true;
        }
        return this.extend((ObSofp)en);
    };
    private InvalidationListener lstnModel = ob -> this.refreshList();
    private InvalidationListener lstnSearch = ob -> {
        ObservableList<ObSofp> observableList = this.model.getList();
        synchronized (observableList) {
            this.mxList.filter(this.model.getList(), this.pd);
        }
    };

    public boolean premise(ObSofp sofp) {
        return true;
    }

    public boolean extend(ObSofp sofp) {
        return false;
    }

    @Focus
    public void onFocus() {
        this.tableMarginAccount.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshList() {
        List<ObSofp> newList = Collections.synchronizedList(new ArrayList());
        ObservableList<ObSofp> observableList = this.model.getList();
        synchronized (observableList) {
            newList.addAll((Collection<ObSofp>)this.model.getList());
        }
        this.mxList.update(newList, this.pd);
        Platform.runLater(() -> this.tableMarginAccount.sort());
    }

    @FXML
    public void initialize() {
        this.listener();
        this.createTable();
        this.refresh();
        this.onFocus();
    }

    private void listener() {
        this.model.changedProperty().addListener(this.lstnModel);
        this.searchText.textProperty().addListener(this.lstnSearch);
    }

    @PreDestroy
    private void close() {
        this.model.changedProperty().removeListener(this.lstnModel);
        this.searchText.textProperty().removeListener(this.lstnSearch);
    }

    @FXML
    public void refresh() {
        this.model.query();
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableMarginAccount);
    }

    @FXML
    public void exportExcel() {
        try {
            ExcelUtils.writeExcel(this.tableMarginAccount, (String)"\u8d26\u53f7\u8d44\u4ea7\u67e5\u8be2");
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
            this.alert.alert(Alert.AlertType.ERROR, e.getMessage());
        }
    }

    private void createTable() {
        this.colAccId.setCellValueFactory(data -> ((ObSofp)data.getValue()).investorIdProperty());
        this.colFundAvail.setCellValueFactory(data -> ((ObSofp)data.getValue()).fundAvailProperty());
        this.colFundAvail.setCellFactory(data -> new DoubleTableCell());
        this.colAvailable.setCellValueFactory(data -> ((ObSofp)data.getValue()).availableProperty());
        this.colAvailable.setCellFactory(data -> new DoubleTableCell());
        this.colMarginAvl.setCellValueFactory(data -> ((ObSofp)data.getValue()).marginAvlProperty());
        this.colMarginAvl.setCellFactory(data -> new DoubleTableCell());
        this.colFcreditAvl.setCellValueFactory(data -> ((ObSofp)data.getValue()).fcreditAvlProperty());
        this.colFcreditAvl.setCellFactory(data -> new DoubleTableCell());
        this.colDcreditAvl.setCellValueFactory(data -> ((ObSofp)data.getValue()).dcreditAvlProperty());
        this.colDcreditAvl.setCellFactory(data -> new DoubleTableCell());
        this.colFtotalDebts.setCellValueFactory(data -> ((ObSofp)data.getValue()).ftotalDebtsProperty());
        this.colFtotalDebts.setCellFactory(data -> new DoubleTableCell());
        this.colDtotalDebts.setCellValueFactory(data -> ((ObSofp)data.getValue()).dtotalDebtsProperty());
        this.colDtotalDebts.setCellFactory(data -> new DoubleTableCell());
        this.colCreditFundOrgDebt.setCellValueFactory(data -> ((ObSofp)data.getValue()).creditFundOrgDebtProperty());
        this.colCreditFundOrgDebt.setCellFactory(data -> new DoubleTableCell());
        this.colCreditStockOrgDebt.setCellValueFactory(data -> ((ObSofp)data.getValue()).creditStockOrgDebtProperty());
        this.colCreditStockOrgDebt.setCellFactory(data -> new DoubleTableCell());
        this.colCreditFundFee.setCellValueFactory(data -> ((ObSofp)data.getValue()).creditFundFeeProperty());
        this.colCreditFundFee.setCellFactory(data -> new DoubleTableCell());
        this.colCreditStockFee.setCellValueFactory(data -> ((ObSofp)data.getValue()).creditStockFeeProperty());
        this.colCreditStockFee.setCellFactory(data -> new DoubleTableCell());
        this.colKeepMarginRate.setCellValueFactory(data -> ((ObSofp)data.getValue()).keepMarginRateProperty());
        this.colKeepMarginRate.setCellFactory(data -> new DoubleTableCell(4));
        this.colNetAsset.setCellValueFactory(data -> ((ObSofp)data.getValue()).netAssetProperty());
        this.colNetAsset.setCellFactory(data -> new DoubleTableCell());
        this.colTotalAsset.setCellValueFactory(data -> ((ObSofp)data.getValue()).totalAssetProperty());
        this.colTotalAsset.setCellFactory(data -> new DoubleTableCell());
        this.tableMarginAccount.setItems(this.mxList.getList());
        this.tableMarginAccount.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableMarginAccount);
    }
}

