/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views.xt;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.NumberTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.http.query.ObOrderRecord;
import cms.tmx.http.query.marginxt.XtOrderRecord;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxNode;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.javafx.utils.MxNodeFactory;
import cms.tmx.manage.IFundAccountService;
import cms.tmx.query.margin.models.xt.ContractModel;
import cms.tmx.utils.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javax.inject.Inject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.controlsfx.control.CheckComboBox;

public class ContractPart
extends MxPagePart<XtOrderRecord, ObOrderRecord> {
    @FXML
    private TableView<ObOrderRecord> tableView;
    @FXML
    private TableColumn<ObOrderRecord, Number> orderQty;
    @FXML
    private TableColumn<ObOrderRecord, Number> lastQty;
    @FXML
    private TableColumn<ObOrderRecord, Number> orderAmount;
    @FXML
    private TableColumn<ObOrderRecord, Number> tradeAmount;
    @FXML
    private TableColumn<ObOrderRecord, Number> exFee;
    @FXML
    private TableColumn<ObOrderRecord, Number> annualInterestRate;
    @FXML
    private TableColumn<ObOrderRecord, Number> marginRate;
    @FXML
    private TableColumn<ObOrderRecord, Number> repayAmount;
    @FXML
    private TableColumn<ObOrderRecord, Number> fundRemain;
    @FXML
    private TableColumn<ObOrderRecord, Number> repayQty;
    @FXML
    private TableColumn<ObOrderRecord, Number> stkRemain;
    @FXML
    private TableColumn<ObOrderRecord, Number> feeRepay;
    @FXML
    private TableColumn<ObOrderRecord, Number> overdueFee;
    @FXML
    private TableColumn<ObOrderRecord, Number> puniFeeRepay;
    @FXML
    private TableColumn<ObOrderRecord, Number> feeSum;
    @FXML
    protected ComboBox<MxNode> cmbFilter;
    @FXML
    protected CheckComboBox<String> ccmbAccnt;
    @FXML
    protected Label lbAccnt;
    @FXML
    protected CheckComboBox<MxNode> ccmbMarket;
    @FXML
    protected Label lbMarket;
    protected String filterType = "";
    protected boolean accFalg = false;
    protected boolean marketFalg = false;
    protected Set<String> accIds = new HashSet<String>();
    @Inject
    private IFundAccountService fundService;
    @Inject
    private ContractModel model;
    private static final Logger logger = LogManager.getLogger(ContractPart.class);
    @Inject
    private MxAlert alert;

    @FXML
    protected void initialize() {
        this.getList().clear();
        super.initialize();
        this.initCheckComboBox();
    }

    protected boolean predicate(XtOrderRecord t) {
        String text = this.searchText.getText().trim();
        if (!this.premise(t)) {
            return false;
        }
        return t.getSecId().contains(text) || t.getSecName().contains(text);
    }

    protected boolean premise(XtOrderRecord or) {
        if ("".equals(this.filterType)) {
            return true;
        }
        switch (this.filterType) {
            case "1": {
                return this.accIds.contains("\u5168\u90e8") || this.accIds.contains(or.getInvestorId());
            }
            case "3": {
                ObservableList listMarket = this.ccmbMarket.getCheckModel().getCheckedItems();
                for (MxNode mxNode : listMarket) {
                    if (!"XALL".equals(mxNode.getRaw())) continue;
                    return true;
                }
                for (MxNode mktNode : listMarket) {
                    if (!mktNode.getRaw().equals(or.getInstrument().getMarket())) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    @FXML
    protected void refresh() {
        try {
            this.model.query();
        }
        catch (Exception e) {
            Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @FXML
    protected void copy() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportExcel() {
        ArrayList listExec = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listExec.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableView, (List)listExec, (String)"\u5408\u7ea6\u67e5\u8be2");
            }
            catch (Exception e) {
                logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.orderQty.setCellFactory(data -> new NumberTableCell());
        this.lastQty.setCellFactory(data -> new NumberTableCell());
        this.orderAmount.setCellFactory(data -> new DoubleTableCell());
        this.tradeAmount.setCellFactory(data -> new DoubleTableCell());
        this.exFee.setCellFactory(data -> new DoubleTableCell());
        this.annualInterestRate.setCellFactory(data -> new PriceCell());
        this.marginRate.setCellFactory(data -> new DoubleTableCell());
        this.repayAmount.setCellFactory(data -> new DoubleTableCell());
        this.fundRemain.setCellFactory(data -> new DoubleTableCell());
        this.repayQty.setCellFactory(data -> new NumberTableCell());
        this.stkRemain.setCellFactory(data -> new NumberTableCell());
        this.feeRepay.setCellFactory(data -> new DoubleTableCell());
        this.feeSum.setCellFactory(data -> new DoubleTableCell());
        this.puniFeeRepay.setCellFactory(data -> new DoubleTableCell());
        this.overdueFee.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setItems(this.mxList.getPageList());
        this.tableView.setPlaceholder((Node)new Label());
        TableUtils.orgnizeClmWidth(this.tableView);
    }

    protected List<XtOrderRecord> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    public void defaultSort() {
    }

    protected void initCheckComboBox() {
        this.initFilterAcc();
        this.initFilterMarket();
        MxNode filterTypeNode = MxNodeFactory.createNew((String)"pos_filter_type");
        filterTypeNode.removeNode("2");
        this.cmbFilter.getItems().addAll((Collection)filterTypeNode.getNodes());
        this.cmbFilter.valueProperty().addListener((ob, oldV, newV) -> {
            if (newV == null) {
                this.filterType = "";
                return;
            }
            this.filterType = newV.getRaw();
            switch (newV.getRaw()) {
                case "1": {
                    this.ccmbAccnt.setVisible(true);
                    this.lbAccnt.setVisible(true);
                    this.ccmbMarket.setVisible(false);
                    this.lbMarket.setVisible(false);
                    break;
                }
                case "3": {
                    this.ccmbAccnt.setVisible(false);
                    this.lbAccnt.setVisible(false);
                    this.ccmbMarket.setVisible(true);
                    this.lbMarket.setVisible(true);
                    break;
                }
            }
            this.listenerSearch.invalidated(null);
        });
        this.cmbFilter.getSelectionModel().select(0);
        this.listenerSearch.invalidated(null);
        this.accFalg = true;
        this.marketFalg = true;
    }

    protected void initFilterAcc() {
        LinkedList<String> listAccnt = new LinkedList<String>();
        listAccnt.add("\u5168\u90e8");
        this.fundService.getMarginFundAccountList().forEach(fund -> {
            boolean bl = listAccnt.add(String.valueOf(fund.getInvestId()) + "__" + fund.getAccountName());
        });
        this.ccmbAccnt.getItems().addAll(listAccnt);
        this.ccmbAccnt.getCheckModel().checkAll();
        int i = 1;
        while (i < listAccnt.size()) {
            this.ccmbAccnt.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.accFalg) {
                    this.accFalg = false;
                    if (!now.booleanValue() && this.ccmbAccnt.getItemBooleanProperty(0).get()) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbAccnt.getItems().size() - this.ccmbAccnt.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbAccnt.getItemBooleanProperty(0).set(true);
                    }
                    this.listenerSearch.invalidated(null);
                    this.accFalg = true;
                }
            });
            ++i;
        }
        this.ccmbAccnt.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.accFalg) {
                this.accFalg = false;
                if (now.booleanValue()) {
                    this.ccmbAccnt.getCheckModel().checkAll();
                } else {
                    this.ccmbAccnt.getCheckModel().clearChecks();
                }
                this.listenerSearch.invalidated(null);
                this.accFalg = true;
            }
        });
        this.ccmbAccnt.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbAccnt.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains("\u5168\u90e8")) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbAccnt.setText(accStr);
            this.lbAccnt.setTooltip(new Tooltip(this.lbAccnt.getText()));
            this.accIds.clear();
            for (String id : this.ccmbAccnt.getCheckModel().getCheckedItems()) {
                this.accIds.add(id.split("__")[0]);
            }
        });
        this.ccmbAccnt.getCheckModel().checkAll();
    }

    protected void initFilterMarket() {
        MxNode marketNode = MxNodeFactory.createNew((String)"ccs_pos_market_code");
        this.ccmbMarket.getItems().addAll((Collection)marketNode.getNodes());
        this.ccmbMarket.getCheckModel().checkAll();
        MxNode nodeAll = (MxNode)marketNode.getNodes().get(0);
        int i = 1;
        while (i < marketNode.getNodes().size()) {
            this.ccmbMarket.getItemBooleanProperty(i).addListener((ob, old, now) -> {
                if (this.marketFalg) {
                    this.marketFalg = false;
                    if (!now.booleanValue() && this.ccmbMarket.getItemBooleanProperty(0).get()) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(false);
                    }
                    if (now.booleanValue() && this.ccmbMarket.getItems().size() - this.ccmbMarket.getCheckModel().getCheckedItems().size() == 1) {
                        this.ccmbMarket.getItemBooleanProperty(0).set(true);
                    }
                    this.listenerSearch.invalidated(null);
                    this.marketFalg = true;
                }
            });
            ++i;
        }
        this.ccmbMarket.getItemBooleanProperty(0).addListener((ob, old, now) -> {
            if (now == null) {
                return;
            }
            if (this.marketFalg) {
                this.marketFalg = false;
                if (now.booleanValue()) {
                    this.ccmbMarket.getCheckModel().checkAll();
                } else {
                    this.ccmbMarket.getCheckModel().clearChecks();
                }
                this.listenerSearch.invalidated(null);
                this.marketFalg = true;
            }
        });
        this.ccmbMarket.getCheckModel().getCheckedItems().addListener(ob -> {
            ObservableList listItem = this.ccmbMarket.getCheckModel().getCheckedItems();
            String accStr = "\u5168\u90e8";
            if (!listItem.contains(nodeAll)) {
                accStr = listItem.toString().substring(1, listItem.toString().length() - 1);
            }
            this.lbMarket.setText(accStr);
            this.lbMarket.setTooltip(new Tooltip(this.lbMarket.getText()));
        });
        this.ccmbMarket.getCheckModel().checkAll();
    }

    private class PriceCell
    extends DoubleTableCell<ObOrderRecord> {
        int scale = 4;

        private PriceCell() {
        }

        public void updateItem(Number item, boolean empty) {
            super.updateItem(item, empty);
            if (!empty) {
                if (this.getTableRow() == null || this.getTableRow().getItem() == null) {
                    return;
                }
                this.setText(StringUtils.toStr((double)item.doubleValue(), (int)this.scale));
            }
        }
    }
}

