/*
 * Decompiled with CFR 0.152.
 */
package cms.tmx.query.margin.views;

import cms.tmx.control.dialog.MxAlert;
import cms.tmx.control.table.DoubleTableCell;
import cms.tmx.control.table.TableUtils;
import cms.tmx.control.utils.ExcelUtils;
import cms.tmx.core.MException;
import cms.tmx.http.query.margin.ObUnderlyingSecurity;
import cms.tmx.http.query.margin.UnderlyingSecurityQuery;
import cms.tmx.javafx.MxModel;
import cms.tmx.javafx.MxPagePart;
import cms.tmx.query.margin.models.UnderlyingModel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javax.inject.Inject;

public class UnderlyingSecurityPart
extends MxPagePart<UnderlyingSecurityQuery, ObUnderlyingSecurity> {
    @FXML
    private TableView<ObUnderlyingSecurity> tableView;
    @FXML
    private TableColumn<ObUnderlyingSecurity, Number> marginRateFund;
    @FXML
    private TableColumn<ObUnderlyingSecurity, Number> marginRateSec;
    @FXML
    protected TextField searchText;
    @Inject
    protected UnderlyingModel model;
    @Inject
    private MxAlert alert;
    @Inject
    private ExecutorService exe;

    @FXML
    public void refresh() {
        this.exe.execute(() -> {
            try {
                this.model.query();
            }
            catch (MException e) {
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
                this.logger.error((Object)e, (Throwable)e);
            }
        });
    }

    @FXML
    public void copy() {
        TableUtils.copyContentWithHead(this.tableView, (ObservableList)this.mxList.getList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    public void exportExcel() {
        ArrayList listOrder = new ArrayList();
        ObservableList observableList = this.mxList.getList();
        synchronized (observableList) {
            listOrder.addAll(this.mxList.getList());
        }
        this.exe.execute(() -> {
            try {
                ExcelUtils.writeExcel(this.tableView, (List)listOrder, (String)"\u6807\u7684\u5238\u67e5\u8be2");
            }
            catch (Exception e) {
                this.logger.error("\u5bfc\u51faEXCEL\u5f02\u5e38", (Throwable)e);
                Platform.runLater(() -> this.alert.alert(Alert.AlertType.ERROR, e.getMessage()));
            }
        });
    }

    protected boolean predicate(UnderlyingSecurityQuery data) {
        String text = this.searchText.getText().trim();
        return data.getSecurityId().contains(text);
    }

    protected List<UnderlyingSecurityQuery> getList() {
        return this.model.getList();
    }

    protected MxModel getModel() {
        return this.model;
    }

    protected void createTableView() {
        TableUtils.initValueFactory(this.tableView);
        this.marginRateFund.setCellFactory(data -> new DoubleTableCell());
        this.marginRateSec.setCellFactory(data -> new DoubleTableCell());
        this.tableView.setPlaceholder((Node)new Label());
        this.mxList.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
        this.tableView.setItems(this.mxList.getPageList());
    }

    public void defaultSort() {
        this.mxList.getList().sort((o1, o2) -> o1.getSecurityId().compareTo(o2.getSecurityId()));
    }
}

